/*
 * Decompiled with CFR 0.152.
 */
package javax0.geci.tools;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax0.geci.api.Segment;
import javax0.geci.api.Source;
import javax0.geci.tools.AbstractGeneratorEx;
import javax0.geci.tools.CaseTools;
import javax0.geci.tools.CompoundParams;
import javax0.geci.tools.GeciAnnotationTools;
import javax0.geci.tools.GeciReflectionTools;
import javax0.geci.tools.Tracer;

public abstract class AbstractJavaGenerator
extends AbstractGeneratorEx {
    private static final Pattern CLASS_LINE = Pattern.compile("class\\s+[a-zA-Z_][\\w$]*\\s*.*\\{\\s*$");
    protected int phase = 0;
    protected final List<Class<?>> classes = new ArrayList();
    private final String calculatedMnemonic = CaseTools.lcase(this.getClass().getSimpleName());

    protected void writeGenerated(Segment segment, Class<? extends Annotation> annotation) {
        if (annotation != null) {
            segment.write("@" + annotation.getCanonicalName() + "(\"" + this.mnemonic() + "\")", new Object[0]);
        }
    }

    protected boolean processAllClasses() {
        return false;
    }

    @Override
    public final void processEx(Source source) throws Exception {
        Class klass = source.getKlass();
        if (klass != null) {
            CompoundParams editorFoldParams;
            CompoundParams annotationParams;
            CompoundParams nullableAnnotationParams;
            if (this.phase == 0) {
                this.classes.add(klass);
            }
            if ((nullableAnnotationParams = GeciReflectionTools.getParameters(klass, this.mnemonic())) == null) {
                Tracer.log("Parameters were not found in annotation");
                CompoundParams commentParams = GeciAnnotationTools.getParameters(source, this.mnemonic(), "//", CLASS_LINE);
                if (commentParams == null) {
                    Tracer.log("Parameters were not found in annotation like comment");
                    annotationParams = null;
                } else {
                    annotationParams = commentParams;
                    Tracer.push("Parameters collected from the comment");
                }
            } else {
                Tracer.push("Parameters collected from the annotation");
                annotationParams = nullableAnnotationParams;
            }
            if (annotationParams != null) {
                annotationParams.trace();
                Tracer.pop();
            }
            try (Segment segment = source.open(this.mnemonic());){
                editorFoldParams = segment == null ? null : (CompoundParams)segment.sourceParams();
            }
            if (editorFoldParams != null) {
                Tracer.push("Parameters collected from the editor fold header");
                editorFoldParams.trace();
                Tracer.pop();
            }
            CompoundParams global = new CompoundParams(annotationParams, editorFoldParams);
            Tracer.push("Composed effective parameter set");
            global.trace();
            Tracer.pop();
            try (Tracer pos = Tracer.push("setting the constraint on the parameters keys=[" + (this.implementedKeys() == null ? "" : String.join((CharSequence)",", this.implementedKeys())) + "]");){
                global.setConstraints(source, this.mnemonic(), this.implementedKeys());
            }
            if (nullableAnnotationParams != null || this.processAllClasses()) {
                Tracer.log("Allowing default segment");
                source.allowDefaultSegment();
            }
            if (nullableAnnotationParams != null || editorFoldParams != null || this.processAllClasses()) {
                try (Tracer tracePosition = Tracer.push("Start", this.getClass().getName() + ".process( source=" + klass.getName() + " )");){
                    this.process(source, klass, global);
                }
                Tracer.prepend("Source", "[PROCESSED] ");
            } else {
                Tracer.log("NotExecuted", "There are no annotations, no editor-fold with id='" + this.mnemonic() + "' and this generator processAllCasses() returns false");
            }
        } else if (source.getAbsoluteFile().endsWith("module-info.java")) {
            Tracer.log("ModuleInfo", source.getAbsoluteFile() + " has no class, it is not processed.");
        } else {
            Tracer.log("ERROR", "There is no class " + source.getKlassName() + " for " + source.getAbsoluteFile() + " skipping ");
        }
    }

    public Set<String> implementedKeys() {
        return null;
    }

    public abstract void process(Source var1, Class<?> var2, CompoundParams var3) throws Exception;

    public String mnemonic() {
        return this.calculatedMnemonic;
    }
}

