/*
 * Decompiled with CFR 0.152.
 */
package javax0.geci.tools;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax0.geci.api.Source;
import javax0.geci.tools.AbstractMethodsGenerator;
import javax0.geci.tools.CompoundParams;
import javax0.geci.tools.reflection.Selector;

public abstract class AbstractFilteredMethodsGenerator
extends AbstractMethodsGenerator {
    private final List<Method> methods = new ArrayList<Method>();

    @Override
    protected final void processMethodHook(Source source, Class<?> klass, CompoundParams params, Method method) throws Exception {
        String filter = params.get("filter", this.defaultFilterExpression());
        Selector selector = Selector.compile(filter);
        if (selector.match(method)) {
            this.processSelectedMethodHook(source, klass, params, method);
            this.methods.add(method);
        }
    }

    @Override
    protected final void preprocessHook(Source source, Class<?> klass, CompoundParams global) throws Exception {
        this.methods.clear();
        this.preprocess(source, klass, global);
    }

    @Override
    protected final void processMethodHook(Source source, Class<?> klass, CompoundParams global, Method[] methods) throws Exception {
        this.processSelectedMethodHook(source, klass, global, this.methods.toArray(new Method[this.methods.size()]));
    }

    protected String defaultFilterExpression() {
        return "true";
    }

    protected void processSelectedMethodHook(Source source, Class<?> klass, CompoundParams global, Method[] methods) throws Exception {
        this.process(source, klass, global, methods);
    }

    protected void processSelectedMethodHook(Source source, Class<?> klass, CompoundParams params, Method method) throws Exception {
        this.process(source, klass, params, method);
    }
}

