/*
 * Decompiled with CFR 0.152.
 */
package javax0.geci.lexeger.matchers;

import java.util.HashMap;
import java.util.Map;
import javax0.geci.javacomparator.LexicalElement;
import javax0.geci.lexeger.JavaLexed;
import javax0.geci.lexeger.MatchResult;
import javax0.geci.lexeger.matchers.LexMatcher;
import javax0.geci.lexeger.matchers.Lexpression;

public class ModifierMatcher
extends LexMatcher {
    private static final Map<String, Integer> modifierMap = new HashMap<String, Integer>();
    private final int modifiers;

    public ModifierMatcher(Lexpression factory, JavaLexed javaLexed) {
        super(factory, javaLexed);
        this.modifiers = -1;
    }

    public ModifierMatcher(Lexpression factory, JavaLexed javaLexed, int modifiers) {
        super(factory, javaLexed);
        this.modifiers = modifiers;
    }

    @Override
    public MatchResult matchesAt(int i) {
        LexicalElement lex = this.javaLexed.get(i);
        if (lex.getType() == LexicalElement.Type.IDENTIFIER && modifierMap.containsKey(lex.getLexeme()) && (modifierMap.get(lex.getLexeme()) & this.modifiers) > 0) {
            return new MatchResult(true, i, i + 1);
        }
        return MatchResult.NO_MATCH;
    }

    static {
        modifierMap.putAll(Map.of("public", 1, "private", 2, "protected", 4, "static", 8, "final", 16, "synchronized", 32));
        modifierMap.putAll(Map.of("volatile", 64, "transient", 128, "native", 256, "interface", 512, "abstract", 1024, "strict", 2048));
    }
}

