/*
 * Decompiled with CFR 0.152.
 */
package javax0.geci.lexeger.matchers;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import javax0.geci.javacomparator.lex.Lexer;
import javax0.geci.javacomparator.lex.LexicalElement;
import javax0.geci.lexeger.JavaLexed;
import javax0.geci.lexeger.LexpressionBuilder;
import javax0.geci.lexeger.matchers.CharacterMatcher;
import javax0.geci.lexeger.matchers.CommentMatcher;
import javax0.geci.lexeger.matchers.FloatMatcher;
import javax0.geci.lexeger.matchers.GroupMatcher;
import javax0.geci.lexeger.matchers.IdentifierMatcher;
import javax0.geci.lexeger.matchers.IntegerMatcher;
import javax0.geci.lexeger.matchers.LexMatcher;
import javax0.geci.lexeger.matchers.ListMatcher;
import javax0.geci.lexeger.matchers.ModifierMatcher;
import javax0.geci.lexeger.matchers.NotMatcher;
import javax0.geci.lexeger.matchers.NumberMatcher;
import javax0.geci.lexeger.matchers.OneOfLexMatcher;
import javax0.geci.lexeger.matchers.Repeat;
import javax0.geci.lexeger.matchers.SetMatcher;
import javax0.geci.lexeger.matchers.StringMatcher;
import javax0.geci.lexeger.matchers.TerminalLexMatcher;
import javax0.geci.lexeger.matchers.TypeMatcher;

public class Lexpression {
    public static final int NO_SENSITIVITY = 0;
    public static final int SPACE_SENSITIVE = 1;
    public static final int COMMENT_SENSITIVE = 2;
    private final Lexer lexer;
    private final JavaLexed javaLexed;
    private final Map<String, List<javax0.geci.javacomparator.LexicalElement>> groups = new HashMap<String, List<javax0.geci.javacomparator.LexicalElement>>();
    private final Map<String, MatchResult> regexResults = new HashMap<String, MatchResult>();

    public Lexpression(JavaLexed javaLexed, Lexer lexer) {
        this.javaLexed = javaLexed;
        this.lexer = lexer;
    }

    public boolean isSpaceSensitive() {
        return this.lexer.isSpaceSensitive();
    }

    public boolean isCommentSensitive() {
        return this.lexer.isCommentSensitive();
    }

    void clean() {
        this.groups.clear();
        this.regexResults.clear();
    }

    void remove(String name) {
        this.groups.remove(name);
        this.regexResults.remove(name);
    }

    void store(String name, List<javax0.geci.javacomparator.LexicalElement> elements) {
        if (this.regexResults.containsKey(name)) {
            throw new IllegalArgumentException(name + " cannot be used to identify both a lex group and regex result");
        }
        this.groups.put(name, elements);
    }

    void store(String name, MatchResult patternMatchResult) {
        if (this.groups.containsKey(name)) {
            throw new IllegalArgumentException(name + " cannot be used to identify both a lex group and regex result");
        }
        this.regexResults.put(name, patternMatchResult);
    }

    public List<javax0.geci.javacomparator.LexicalElement> group(String name) {
        if (this.groups.containsKey(name)) {
            return this.groups.get(name);
        }
        return Collections.emptyList();
    }

    public Optional<MatchResult> regexGroups(String name) {
        if (this.regexResults.containsKey(name)) {
            return Optional.of(this.regexResults.get(name));
        }
        return Optional.empty();
    }

    private LexMatcher terminal(LexicalElement le) {
        return new TerminalLexMatcher(this, this.javaLexed, le);
    }

    public LexMatcher modifier(int mask) {
        return new ModifierMatcher(this, this.javaLexed, mask);
    }

    public LexMatcher keyword(String id) {
        return this.identifier(id);
    }

    public LexMatcher oneOf(LexMatcher ... matchers) {
        return new OneOfLexMatcher(this, this.javaLexed, matchers);
    }

    public LexMatcher zeroOrMore(LexMatcher matcher) {
        return new Repeat(this, this.javaLexed, matcher, 0, Integer.MAX_VALUE);
    }

    public LexMatcher zeroOrMore(String string) {
        return this.zeroOrMore(this.getMatcher(string));
    }

    public LexMatcher optional(LexMatcher matcher) {
        return new Repeat(this, this.javaLexed, matcher, 0, 1);
    }

    public LexMatcher optional(String string) {
        return this.optional(this.getMatcher(string));
    }

    public LexMatcher oneOrMore(LexMatcher matcher) {
        return new Repeat(this, this.javaLexed, matcher, 1, Integer.MAX_VALUE);
    }

    public LexMatcher oneOrMore(String string) {
        return this.oneOrMore(this.getMatcher(string));
    }

    public LexMatcher repeat(LexMatcher matcher, int times) {
        return new Repeat(this, this.javaLexed, matcher, times, times);
    }

    public LexMatcher repeat(LexMatcher matcher, int min, int max) {
        return new Repeat(this, this.javaLexed, matcher, min, max);
    }

    public LexMatcher integerNumber() {
        return new IntegerMatcher(this, this.javaLexed);
    }

    public LexMatcher integerNumber(Predicate<Long> predicate) {
        return new IntegerMatcher(this, this.javaLexed, predicate);
    }

    public LexMatcher number() {
        return new NumberMatcher(this, this.javaLexed);
    }

    public LexMatcher number(Predicate<Number> predicate) {
        return new NumberMatcher(this, this.javaLexed, predicate);
    }

    public LexMatcher floatNumber() {
        return new FloatMatcher(this, this.javaLexed);
    }

    public LexMatcher floatNumber(Predicate<Double> predicate) {
        return new FloatMatcher(this, this.javaLexed, predicate);
    }

    private LexMatcher list(LexpressionBuilder.GroupNameWrapper name, LexicalElement ... elements) {
        return this.group(name.toString(), this.list(elements));
    }

    private LexMatcher list(LexicalElement ... elements) {
        LexMatcher[] matchers = this.getLexMatchers(elements);
        return new ListMatcher(this, this.javaLexed, matchers);
    }

    public LexMatcher list(String ... strings) {
        return this.list(this.getMatchers(strings));
    }

    public LexMatcher list(LexMatcher ... matchers) {
        return new ListMatcher(this, this.javaLexed, matchers);
    }

    public LexMatcher match(String string) {
        return this.list(this.lexer.apply(Collections.singletonList(string)));
    }

    public LexMatcher unordered(LexMatcher ... matchers) {
        return new SetMatcher(this, this.javaLexed, matchers);
    }

    public LexMatcher unordered(LexicalElement ... elements) {
        LexMatcher[] matchers = this.getLexMatchers(elements);
        return this.unordered(matchers);
    }

    public LexMatcher unordered(String string) {
        return this.unordered(this.lexer.apply(Collections.singletonList(string)));
    }

    public LexMatcher group(String name, LexMatcher matcher) {
        return new GroupMatcher(this, this.javaLexed, name, matcher);
    }

    public LexMatcher oneOf(String ... strings) {
        return this.oneOf(this.getMatchers(strings));
    }

    public LexMatcher not(LexMatcher ... matchers) {
        return new NotMatcher(this, this.javaLexed, matchers);
    }

    public LexMatcher not(LexicalElement ... elements) {
        LexMatcher[] matchers = this.getLexMatchers(elements);
        return this.not(matchers);
    }

    public LexMatcher not(String string) {
        return this.not(this.lexer.apply(Collections.singletonList(string)));
    }

    public LexMatcher anyTill(LexMatcher ... matchers) {
        return this.zeroOrMore(this.not(matchers));
    }

    public LexMatcher anyTill(LexicalElement ... elements) {
        LexMatcher[] matchers = this.getLexMatchers(elements);
        return this.anyTill(matchers);
    }

    public LexMatcher anyTill(String string) {
        return this.anyTill(this.lexer.apply(Collections.singletonList(string)));
    }

    public LexMatcher modifier(LexpressionBuilder.GroupNameWrapper nameWrapper, int mask) {
        return this.group(nameWrapper.toString(), this.modifier(mask));
    }

    public LexMatcher keyword(LexpressionBuilder.GroupNameWrapper nameWrapper, String id) {
        return this.group(nameWrapper.toString(), this.keyword(id));
    }

    public LexMatcher oneOf(LexpressionBuilder.GroupNameWrapper nameWrapper, LexMatcher ... matchers) {
        return this.group(nameWrapper.toString(), this.oneOf(matchers));
    }

    public LexMatcher zeroOrMore(LexpressionBuilder.GroupNameWrapper nameWrapper, LexMatcher matcher) {
        return this.group(nameWrapper.toString(), this.zeroOrMore(matcher));
    }

    public LexMatcher zeroOrMore(LexpressionBuilder.GroupNameWrapper nameWrapper, String string) {
        return this.group(nameWrapper.toString(), this.zeroOrMore(string));
    }

    public LexMatcher optional(LexpressionBuilder.GroupNameWrapper nameWrapper, LexMatcher matcher) {
        return this.group(nameWrapper.toString(), this.optional(matcher));
    }

    public LexMatcher optional(LexpressionBuilder.GroupNameWrapper nameWrapper, String string) {
        return this.group(nameWrapper.toString(), this.optional(string));
    }

    public LexMatcher oneOrMore(LexpressionBuilder.GroupNameWrapper nameWrapper, LexMatcher matcher) {
        return this.group(nameWrapper.toString(), this.oneOrMore(matcher));
    }

    public LexMatcher oneOrMore(LexpressionBuilder.GroupNameWrapper nameWrapper, String string) {
        return this.group(nameWrapper.toString(), this.oneOrMore(string));
    }

    public LexMatcher repeat(LexpressionBuilder.GroupNameWrapper nameWrapper, LexMatcher matcher, int times) {
        return this.group(nameWrapper.toString(), this.repeat(matcher, times));
    }

    public LexMatcher repeat(LexpressionBuilder.GroupNameWrapper nameWrapper, LexMatcher matcher, int min, int max) {
        return this.group(nameWrapper.toString(), this.repeat(matcher, min, max));
    }

    public LexMatcher integerNumber(LexpressionBuilder.GroupNameWrapper nameWrapper) {
        return this.group(nameWrapper.toString(), this.integerNumber());
    }

    public LexMatcher integerNumber(LexpressionBuilder.GroupNameWrapper nameWrapper, Predicate<Long> predicate) {
        return this.group(nameWrapper.toString(), this.integerNumber(predicate));
    }

    public LexMatcher number(LexpressionBuilder.GroupNameWrapper nameWrapper) {
        return this.group(nameWrapper.toString(), this.number());
    }

    public LexMatcher number(LexpressionBuilder.GroupNameWrapper nameWrapper, Predicate<Number> predicate) {
        return this.group(nameWrapper.toString(), this.number(predicate));
    }

    public LexMatcher floatNumber(LexpressionBuilder.GroupNameWrapper nameWrapper) {
        return this.group(nameWrapper.toString(), this.floatNumber());
    }

    public LexMatcher floatNumber(LexpressionBuilder.GroupNameWrapper nameWrapper, Predicate<Double> predicate) {
        return this.group(nameWrapper.toString(), this.floatNumber(predicate));
    }

    public LexMatcher list(LexpressionBuilder.GroupNameWrapper nameWrapper, String ... strings) {
        return this.group(nameWrapper.toString(), this.list(strings));
    }

    public LexMatcher list(LexpressionBuilder.GroupNameWrapper nameWrapper, LexMatcher ... matchers) {
        return this.group(nameWrapper.toString(), this.list(matchers));
    }

    public LexMatcher match(LexpressionBuilder.GroupNameWrapper nameWrapper, String string) {
        return this.group(nameWrapper.toString(), this.match(string));
    }

    public LexMatcher unordered(LexpressionBuilder.GroupNameWrapper nameWrapper, LexMatcher ... matchers) {
        return this.group(nameWrapper.toString(), this.unordered(matchers));
    }

    public LexMatcher unordered(LexpressionBuilder.GroupNameWrapper nameWrapper, LexicalElement ... elements) {
        return this.group(nameWrapper.toString(), this.unordered(elements));
    }

    public LexMatcher unordered(LexpressionBuilder.GroupNameWrapper nameWrapper, String string) {
        return this.group(nameWrapper.toString(), this.unordered(string));
    }

    public LexMatcher group(LexpressionBuilder.GroupNameWrapper nameWrapper, String name, LexMatcher matcher) {
        return this.group(nameWrapper.toString(), this.group(name, matcher));
    }

    public LexMatcher oneOf(LexpressionBuilder.GroupNameWrapper nameWrapper, String ... strings) {
        return this.group(nameWrapper.toString(), this.oneOf(strings));
    }

    public LexMatcher not(LexpressionBuilder.GroupNameWrapper nameWrapper, LexMatcher ... matchers) {
        return this.group(nameWrapper.toString(), this.not(matchers));
    }

    public LexMatcher not(LexpressionBuilder.GroupNameWrapper nameWrapper, LexicalElement ... elements) {
        return this.group(nameWrapper.toString(), this.not(elements));
    }

    public LexMatcher not(LexpressionBuilder.GroupNameWrapper nameWrapper, String string) {
        return this.group(nameWrapper.toString(), this.not(string));
    }

    public LexMatcher anyTill(LexpressionBuilder.GroupNameWrapper nameWrapper, LexMatcher ... matchers) {
        return this.group(nameWrapper.toString(), this.anyTill(matchers));
    }

    public LexMatcher anyTill(LexpressionBuilder.GroupNameWrapper nameWrapper, LexicalElement ... elements) {
        return this.group(nameWrapper.toString(), this.anyTill(elements));
    }

    public LexMatcher anyTill(LexpressionBuilder.GroupNameWrapper nameWrapper, String string) {
        return this.group(nameWrapper.toString(), this.anyTill(string));
    }

    public LexMatcher identifier(LexpressionBuilder.GroupNameWrapper nameWrapper) {
        return this.group(nameWrapper.toString(), this.identifier());
    }

    public LexMatcher identifier(LexpressionBuilder.GroupNameWrapper nameWrapper, String text) {
        return this.group(nameWrapper.toString(), this.identifier(text));
    }

    public LexMatcher identifier(LexpressionBuilder.GroupNameWrapper nameWrapper, Pattern pattern) {
        return this.group(nameWrapper.toString(), this.identifier(pattern));
    }

    public LexMatcher identifier(LexpressionBuilder.GroupNameWrapper nameWrapper, String name, Pattern pattern) {
        return this.group(nameWrapper.toString(), this.identifier(name, pattern));
    }

    public LexMatcher character(LexpressionBuilder.GroupNameWrapper nameWrapper) {
        return this.group(nameWrapper.toString(), this.character());
    }

    public LexMatcher character(LexpressionBuilder.GroupNameWrapper nameWrapper, String text) {
        return this.group(nameWrapper.toString(), this.character(text));
    }

    public LexMatcher character(LexpressionBuilder.GroupNameWrapper nameWrapper, Pattern pattern) {
        return this.group(nameWrapper.toString(), this.character(pattern));
    }

    public LexMatcher character(LexpressionBuilder.GroupNameWrapper nameWrapper, String name, Pattern pattern) {
        return this.group(nameWrapper.toString(), this.character(name, pattern));
    }

    public LexMatcher string(LexpressionBuilder.GroupNameWrapper nameWrapper) {
        return this.group(nameWrapper.toString(), this.string());
    }

    public LexMatcher string(LexpressionBuilder.GroupNameWrapper nameWrapper, String text) {
        return this.group(nameWrapper.toString(), this.string(text));
    }

    public LexMatcher string(LexpressionBuilder.GroupNameWrapper nameWrapper, Pattern pattern) {
        return this.group(nameWrapper.toString(), this.string(pattern));
    }

    public LexMatcher string(LexpressionBuilder.GroupNameWrapper nameWrapper, String name, Pattern pattern) {
        return this.group(nameWrapper.toString(), this.string(name, pattern));
    }

    public LexMatcher type(LexpressionBuilder.GroupNameWrapper nameWrapper) {
        return this.group(nameWrapper.toString(), this.type());
    }

    public LexMatcher type(LexpressionBuilder.GroupNameWrapper nameWrapper, String text) {
        return this.group(nameWrapper.toString(), this.type(text));
    }

    public LexMatcher type(LexpressionBuilder.GroupNameWrapper nameWrapper, Pattern pattern) {
        return this.group(nameWrapper.toString(), this.type(pattern));
    }

    public LexMatcher type(LexpressionBuilder.GroupNameWrapper nameWrapper, String name, Pattern pattern) {
        return this.group(nameWrapper.toString(), this.type(name, pattern));
    }

    public LexMatcher comment(LexpressionBuilder.GroupNameWrapper nameWrapper) {
        return this.group(nameWrapper.toString(), this.comment());
    }

    public LexMatcher comment(LexpressionBuilder.GroupNameWrapper nameWrapper, String text) {
        return this.group(nameWrapper.toString(), this.comment(text));
    }

    public LexMatcher comment(LexpressionBuilder.GroupNameWrapper nameWrapper, Pattern pattern) {
        return this.group(nameWrapper.toString(), this.comment(pattern));
    }

    public LexMatcher comment(LexpressionBuilder.GroupNameWrapper nameWrapper, String name, Pattern pattern) {
        return this.group(nameWrapper.toString(), this.comment(name, pattern));
    }

    public LexMatcher identifier() {
        return new IdentifierMatcher(this, this.javaLexed);
    }

    public LexMatcher identifier(String text) {
        return new IdentifierMatcher(this, this.javaLexed, text);
    }

    public LexMatcher identifier(Pattern pattern) {
        return new IdentifierMatcher(this, this.javaLexed, pattern);
    }

    public LexMatcher identifier(String name, Pattern pattern) {
        return new IdentifierMatcher(this, this.javaLexed, pattern, name);
    }

    public LexMatcher character() {
        return new CharacterMatcher(this, this.javaLexed);
    }

    public LexMatcher character(String text) {
        return new CharacterMatcher(this, this.javaLexed, text);
    }

    public LexMatcher character(Pattern pattern) {
        return new CharacterMatcher(this, this.javaLexed, pattern);
    }

    public LexMatcher character(String name, Pattern pattern) {
        return new CharacterMatcher(this, this.javaLexed, pattern, name);
    }

    public LexMatcher string() {
        return new StringMatcher(this, this.javaLexed);
    }

    public LexMatcher string(String text) {
        return new StringMatcher(this, this.javaLexed, text);
    }

    public LexMatcher string(Pattern pattern) {
        return new StringMatcher(this, this.javaLexed, pattern);
    }

    public LexMatcher string(String name, Pattern pattern) {
        return new StringMatcher(this, this.javaLexed, pattern, name);
    }

    public LexMatcher type() {
        return new TypeMatcher(this, this.javaLexed);
    }

    public LexMatcher type(String text) {
        return new TypeMatcher(this, this.javaLexed, text);
    }

    public LexMatcher type(Pattern pattern) {
        return new TypeMatcher(this, this.javaLexed, pattern);
    }

    public LexMatcher type(String name, Pattern pattern) {
        return new TypeMatcher(this, this.javaLexed, pattern, name);
    }

    public LexMatcher comment() {
        return new CommentMatcher(this, this.javaLexed);
    }

    public LexMatcher comment(String text) {
        return new CommentMatcher(this, this.javaLexed, text);
    }

    public LexMatcher comment(Pattern pattern) {
        return new CommentMatcher(this, this.javaLexed, pattern);
    }

    public LexMatcher comment(String name, Pattern pattern) {
        return new CommentMatcher(this, this.javaLexed, pattern, name);
    }

    private LexMatcher getMatcher(String string) {
        LexicalElement[] lexicalElements = this.lexer.apply(Collections.singletonList(string));
        if (lexicalElements.length == 1) {
            return this.terminal(lexicalElements[0]);
        }
        return this.list(lexicalElements);
    }

    private LexMatcher[] getLexMatchers(LexicalElement[] elements) {
        LexMatcher[] matchers = new LexMatcher[elements.length];
        for (int i = 0; i < elements.length; ++i) {
            matchers[i] = this.terminal(elements[i]);
        }
        return matchers;
    }

    private LexMatcher[] getMatchers(String ... strings) {
        LexMatcher[] matchers = new LexMatcher[strings.length];
        int i = 0;
        for (String string : strings) {
            matchers[i++] = this.getMatcher(string);
        }
        return matchers;
    }
}

