/*
 * Decompiled with CFR 0.152.
 */
package javax0.geci.lexeger.matchers;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax0.geci.javacomparator.LexicalElement;
import javax0.geci.lexeger.JavaLexed;
import javax0.geci.lexeger.MatchResult;
import javax0.geci.lexeger.matchers.LexMatcher;
import javax0.geci.lexeger.matchers.Lexpression;

abstract class AbstractPatternedMatcher
extends LexMatcher {
    private final String text;
    private final Pattern pattern;
    private final String name;

    AbstractPatternedMatcher(Lexpression expression, JavaLexed javaLexed, Pattern pattern) {
        this(expression, javaLexed, null, pattern);
    }

    AbstractPatternedMatcher(Lexpression expression, JavaLexed javaLexed, Pattern pattern, String name) {
        this(expression, javaLexed, null, pattern, name);
    }

    AbstractPatternedMatcher(Lexpression expression, JavaLexed javaLexed, String text) {
        this(expression, javaLexed, text, null);
    }

    AbstractPatternedMatcher(Lexpression factory, JavaLexed javaLexed) {
        this(factory, javaLexed, (String)null, null);
    }

    AbstractPatternedMatcher(Lexpression expression, JavaLexed javaLexed, String text, Pattern pattern) {
        this(expression, javaLexed, text, pattern, null);
    }

    private AbstractPatternedMatcher(Lexpression expression, JavaLexed javaLexed, String text, Pattern pattern, String name) {
        super(expression, javaLexed);
        this.text = text;
        this.pattern = pattern;
        this.name = name;
    }

    public MatchResult match(int i, LexicalElement.Type type) {
        if (this.consumed()) {
            return MatchResult.NO_MATCH;
        }
        int start = this.skipSpacesAndComments(i);
        if (this.javaLexed.get(start).getType() != type) {
            return MatchResult.NO_MATCH;
        }
        if (this.text != null) {
            if (this.text.equals(this.javaLexed.get(start).getLexeme())) {
                return this.matching(start, start + 1);
            }
            return MatchResult.NO_MATCH;
        }
        if (this.pattern != null) {
            Matcher regex = this.pattern.matcher(this.javaLexed.get(start).getLexeme());
            if (regex.find()) {
                this.store(this.name, regex);
                return this.matching(start, start + 1);
            }
            this.remove(this.name);
            return MatchResult.NO_MATCH;
        }
        return this.matching(start, start + 1);
    }
}

