/*
 * Decompiled with CFR 0.152.
 */
package javax0.geci.lexeger;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.BiFunction;
import javax0.geci.api.Source;
import javax0.geci.javacomparator.LexicalElement;
import javax0.geci.javacomparator.lex.Lexer;
import javax0.geci.javacomparator.lex.LexicalElement;
import javax0.geci.lexeger.LexMatcher;
import javax0.geci.lexeger.MatchResult;
import javax0.geci.lexeger.matchers.Lexpression;

public class JavaLexed
implements AutoCloseable {
    private final Source source;
    private final ArrayList<javax0.geci.javacomparator.LexicalElement> lexicalElements;
    private boolean isOpen = true;
    private static final javax0.geci.javacomparator.LexicalElement INVALID = new javax0.geci.javacomparator.LexicalElement(){

        @Override
        public String getLexeme() {
            return null;
        }

        @Override
        public void setLexeme(String lexeme) {
        }

        @Override
        public void setOriginal(String original) {
        }

        @Override
        public String getFullLexeme() {
            return null;
        }

        @Override
        public String getOriginalLexeme() {
            return null;
        }

        @Override
        public LexicalElement.Type getType() {
            return LexicalElement.Type.INVALID;
        }
    };
    private BiFunction<JavaLexed, Lexpression, LexMatcher> function = null;
    private Action action = null;
    private int sensitivity;
    private Lexpression expression;
    private MatchResult lastMatchResult = MatchResult.NO_MATCH;

    public JavaLexed(Source source) {
        this.source = source;
        this.lexicalElements = new ArrayList<LexicalElement>(Arrays.asList(new Lexer().spaceSensitive().commentSensitive().apply(source.borrows())));
    }

    @Override
    public void close() {
        this.assertOpen();
        this.isOpen = false;
        ArrayList<String> lines = new ArrayList<String>();
        StringBuilder currentLine = new StringBuilder();
        for (javax0.geci.javacomparator.LexicalElement lex : this.lexicalElements) {
            String lexeme = lex.getType() == LexicalElement.Type.CHARACTER || lex.getType() == LexicalElement.Type.STRING ? lex.getOriginalLexeme() : lex.getFullLexeme();
            while (lexeme.contains("\n")) {
                int nlpos = lexeme.indexOf("\n");
                String start = lexeme.substring(0, nlpos);
                currentLine.append(start);
                lines.add(currentLine.toString());
                currentLine.delete(0, currentLine.length());
                lexeme = lexeme.substring(nlpos + 1);
            }
            currentLine.append(lexeme);
        }
        if (currentLine.length() > 0) {
            lines.add(currentLine.toString());
        }
        this.source.returns(lines);
    }

    private void assertStartEndOrder(int start, int end) {
        if (start > end) {
            throw new IllegalArgumentException(start + " start value cannot be larger than " + end + " end value.");
        }
    }

    private void assertOpen() {
        if (!this.isOpen) {
            throw new IllegalArgumentException("JavaLexed must not be used after it was closed.");
        }
    }

    public Iterable<javax0.geci.javacomparator.LexicalElement> lexicalElements() {
        this.assertOpen();
        return new LexicalIterable();
    }

    public javax0.geci.javacomparator.LexicalElement get(int i) {
        this.assertOpen();
        if (i < 0 || i >= this.lexicalElements.size()) {
            return null;
        }
        return this.lexicalElements.get(i);
    }

    public javax0.geci.javacomparator.LexicalElement remove(int i) {
        this.assertOpen();
        return this.lexicalElements.remove(i);
    }

    public void removeRange(int start, int end) {
        this.assertStartEndOrder(start, end);
        this.assertOpen();
        if (end > start) {
            this.lexicalElements.subList(start, end).clear();
        }
    }

    public int replaceWith(List<javax0.geci.javacomparator.LexicalElement> ... lists) {
        this.assertOpen();
        return this.replace(this.lastMatchResult, lists);
    }

    public int replace(MatchResult result, List<javax0.geci.javacomparator.LexicalElement> ... lists) {
        this.assertOpen();
        if (result == null) {
            throw new IllegalArgumentException("Illegal sequence of invocation, there is no match result.");
        }
        if (result.matches) {
            return this.replace(result.start, result.end, lists);
        }
        return -1;
    }

    public int replace(int start, int end, List<javax0.geci.javacomparator.LexicalElement> ... lists) {
        this.assertOpen();
        this.assertStartEndOrder(start, end);
        this.removeRange(start, end);
        int j = start;
        for (List<javax0.geci.javacomparator.LexicalElement> list : lists) {
            for (javax0.geci.javacomparator.LexicalElement element : list) {
                this.add(j++, element);
            }
        }
        return j;
    }

    public void add(int index, javax0.geci.javacomparator.LexicalElement le) {
        this.assertOpen();
        this.lexicalElements.add(index, le);
    }

    public int size() {
        this.assertOpen();
        return this.lexicalElements.size();
    }

    public JavaLexed match(BiFunction<JavaLexed, Lexpression, LexMatcher> expression) {
        this.function = expression;
        this.action = Action.MATCH;
        this.lastMatchResult = null;
        return this;
    }

    public JavaLexed find(BiFunction<JavaLexed, Lexpression, LexMatcher> expression) {
        this.function = expression;
        this.action = Action.FIND;
        this.lastMatchResult = null;
        return this;
    }

    public JavaLexed sensitivity(int sensitivity) {
        this.sensitivity = sensitivity;
        return this;
    }

    public JavaLexed fromStart() {
        return this.fromIndex(0);
    }

    public JavaLexed fromIndex(int i) {
        Lexer lexer = new Lexer();
        if ((this.sensitivity & 1) > 0) {
            lexer.spaceSensitive();
        }
        if ((this.sensitivity & 2) > 0) {
            lexer.commentSensitive();
        }
        this.expression = new Lexpression(this, lexer);
        switch (this.action) {
            case MATCH: {
                this.lastMatchResult = this.function.apply(this, this.expression).matchesAt(i);
                return this;
            }
            case FIND: {
                this.lastMatchResult = this.function.apply(this, this.expression).find(i);
                return this;
            }
        }
        throw new IllegalArgumentException("action is " + this.action + "can only be MATCH or FIND");
    }

    public Optional<java.util.regex.MatchResult> regexGroups(String name) {
        return this.expression.regexGroups(name);
    }

    public List<javax0.geci.javacomparator.LexicalElement> group(String name) {
        return this.expression.group(name);
    }

    public MatchResult result() {
        return this.lastMatchResult;
    }

    private static enum Action {
        MATCH,
        FIND;

    }

    private class LexicalIterator
    implements Iterator<javax0.geci.javacomparator.LexicalElement> {
        private int index = 0;

        private LexicalIterator() {
        }

        @Override
        public boolean hasNext() {
            JavaLexed.this.assertOpen();
            return this.index < JavaLexed.this.lexicalElements.size();
        }

        @Override
        public javax0.geci.javacomparator.LexicalElement next() throws NoSuchElementException {
            JavaLexed.this.assertOpen();
            if (this.index >= JavaLexed.this.lexicalElements.size()) {
                throw new NoSuchElementException("The JavaLexed source contains only " + JavaLexed.this.lexicalElements.size() + " lexemes and there was a query for the " + this.index + "-th element.");
            }
            return JavaLexed.this.lexicalElements.get(this.index++);
        }
    }

    private class LexicalIterable
    implements Iterable<javax0.geci.javacomparator.LexicalElement> {
        private LexicalIterable() {
        }

        @Override
        public Iterator<javax0.geci.javacomparator.LexicalElement> iterator() {
            return new LexicalIterator();
        }
    }
}

