/*
 * Decompiled with CFR 0.152.
 */
package javax0.geci.javacomparator.lex;

import javax0.geci.javacomparator.lex.Escape;
import javax0.geci.javacomparator.lex.LexEater;
import javax0.geci.javacomparator.lex.LexicalElement;

public class StringLiteral
implements LexEater {
    public static final String MULTI_LINE_STRING_DELIMITER = "\"\"\"";
    private static final String ENCLOSING = "\"";
    private static final char ENCLOSING_CH = '\"';
    private static final String STRING = "String";

    @Override
    public LexicalElement.StringLiteral apply(StringBuilder sb) {
        if (sb.length() == 0 || sb.charAt(0) != '\"') {
            return null;
        }
        StringBuilder output = Escape.createOutput(sb, STRING);
        StringBuilder original = Escape.createOutput(sb, STRING);
        if (sb.length() >= 3 && sb.subSequence(0, 3).equals(MULTI_LINE_STRING_DELIMITER)) {
            return this.getMultiLineStringLiteral(sb, output, original);
        }
        return this.getSimpleStringLiteral(sb, output, original);
    }

    private LexicalElement.StringLiteral getMultiLineStringLiteral(StringBuilder sb, StringBuilder output, StringBuilder original) {
        this.deleteMultiLineStringDelimiter(sb);
        while (sb.length() >= 3 && !sb.subSequence(0, 3).equals(MULTI_LINE_STRING_DELIMITER)) {
            char ch = sb.charAt(0);
            if (ch == '\\') {
                Escape.handleEscape(sb, output, original);
                continue;
            }
            Escape.handleNormalMultiLineStringCharacter(sb, output, original);
        }
        if (sb.length() < 3) {
            throw new IllegalArgumentException("Multi-line string is not terminated before eof");
        }
        this.deleteMultiLineStringDelimiter(sb);
        return new LexicalElement.StringLiteral(output.toString(), original.toString(), MULTI_LINE_STRING_DELIMITER);
    }

    private void deleteMultiLineStringDelimiter(StringBuilder sb) {
        sb.deleteCharAt(0);
        sb.deleteCharAt(0);
        sb.deleteCharAt(0);
    }

    private LexicalElement.StringLiteral getSimpleStringLiteral(StringBuilder sb, StringBuilder output, StringBuilder original) {
        sb.deleteCharAt(0);
        while (sb.length() > 0 && sb.charAt(0) != '\"') {
            char ch = sb.charAt(0);
            if (ch == '\\') {
                Escape.handleEscape(sb, output, original);
                continue;
            }
            Escape.handleNormalCharacter(sb, output, original);
        }
        if (sb.length() == 0) {
            throw new IllegalArgumentException("String is not terminated before eol");
        }
        sb.deleteCharAt(0);
        return new LexicalElement.StringLiteral(output.toString(), original.toString(), ENCLOSING);
    }
}

