/*
 * Decompiled with CFR 0.152.
 */
package javax0.geci.javacomparator.lex;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax0.geci.javacomparator.lex.LexEater;
import javax0.geci.javacomparator.lex.LexicalElement;

public class NumberLiteral
implements LexEater {
    private static final Pattern[] patterns = new Pattern[]{Pattern.compile("^([+-]?(?:0[Bb])?\\d[\\d_]*[lL]?)"), Pattern.compile("^([+-]?0[Xx][\\da-fA-F][\\d_a-fA-F]*[lL]?)"), Pattern.compile("^([+-]?\\d+(?:\\.\\d*)?(?:[eE][+-]?\\d+)?[fFdD]?)"), Pattern.compile("^([+-]?0[Xx][\\da-fA-F]*(?:\\.[\\da-fA-F]*)?[pP][+-]?\\d+[fFdD]?)")};

    @Override
    public LexicalElement apply(StringBuilder sb) {
        String[] literals = new String[patterns.length];
        for (int i = 0; i < patterns.length; ++i) {
            Matcher matcher = patterns[i].matcher(sb.toString());
            literals[i] = matcher.find() ? matcher.group(1) : "";
        }
        int maxLength = literals[0].length();
        int index = 0;
        for (int i = 1; i < patterns.length; ++i) {
            if (maxLength >= literals[i].length()) continue;
            index = i;
            maxLength = literals[i].length();
        }
        if (maxLength == 0) {
            return null;
        }
        sb.delete(0, maxLength);
        return index > 1 ? new LexicalElement.FloatLiteral(literals[index]) : new LexicalElement.IntegerLiteral(literals[index]);
    }
}

