/*
 * Decompiled with CFR 0.152.
 */
package javax0.geci.javacomparator.lex;

import java.util.Objects;
import javax0.geci.api.GeciException;
import javax0.geci.javacomparator.LexicalElement;
import javax0.geci.javacomparator.lex.Escape;

public class LexicalElement
implements javax0.geci.javacomparator.LexicalElement {
    public String lexeme;
    public String original;
    public final LexicalElement.Type type;

    LexicalElement(String lexeme, LexicalElement.Type type) {
        this.lexeme = lexeme;
        this.type = type;
    }

    @Override
    public String getLexeme() {
        return this.lexeme;
    }

    @Override
    public void setLexeme(String lexeme) {
        this.lexeme = lexeme;
    }

    @Override
    public void setOriginal(String original) {
        if (this.type != LexicalElement.Type.CHARACTER && this.type != LexicalElement.Type.STRING) {
            throw new GeciException("Setting the original is possible only in case the lexeme is character or string", new Object[0]);
        }
        this.original = original;
        this.lexeme = Escape.escape(original);
    }

    @Override
    public String getOriginalLexeme() {
        if (this.type == LexicalElement.Type.STRING) {
            String enclosing = ((StringLiteral)this).enclosing;
            return enclosing + this.original + enclosing;
        }
        if (this.type == LexicalElement.Type.CHARACTER) {
            return "'" + this.original + "'";
        }
        return this.original;
    }

    @Override
    public String getFullLexeme() {
        if (this.type == LexicalElement.Type.STRING) {
            String enclosing = ((StringLiteral)this).enclosing;
            return enclosing + this.lexeme + enclosing;
        }
        if (this.type == LexicalElement.Type.CHARACTER) {
            return "'" + this.lexeme + "'";
        }
        return this.lexeme;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LexicalElement that = (LexicalElement)o;
        return this.lexeme.equals(that.lexeme);
    }

    @Override
    public LexicalElement.Type getType() {
        return this.type;
    }

    public int hashCode() {
        return Objects.hash(this.lexeme);
    }

    public String toString() {
        return this.type.toString() + "[" + this.lexeme + "]";
    }

    public static class Comment
    extends LexicalElement {
        public Comment(String lexeme) {
            super(lexeme, LexicalElement.Type.COMMENT);
        }
    }

    public static class Spacing
    extends LexicalElement {
        public Spacing(String lexeme) {
            super(lexeme, LexicalElement.Type.SPACING);
        }
    }

    public static class Identifier
    extends LexicalElement {
        public Identifier(String lexeme) {
            super(lexeme, LexicalElement.Type.IDENTIFIER);
        }
    }

    public static class CharacterLiteral
    extends LexicalElement {
        public CharacterLiteral(String lexeme, String original) {
            super(lexeme, LexicalElement.Type.CHARACTER);
            this.original = original;
        }
    }

    public static class StringLiteral
    extends LexicalElement {
        public final String enclosing;

        StringLiteral(String lexeme, String original, String enclosing) {
            super(lexeme, LexicalElement.Type.STRING);
            this.original = original;
            this.enclosing = enclosing;
        }
    }

    public static class Symbol
    extends LexicalElement {
        public Symbol(String lexeme) {
            super(lexeme, LexicalElement.Type.SYMBOL);
        }
    }

    public static class FloatLiteral
    extends LexicalElement {
        public final double value;

        public FloatLiteral(String lexeme) {
            super(lexeme, LexicalElement.Type.FLOAT);
            this.value = Double.parseDouble(lexeme);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FloatLiteral literal = (FloatLiteral)o;
            return Double.compare(literal.value, this.value) == 0;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.value);
        }
    }

    public static class IntegerLiteral
    extends LexicalElement {
        public final long value;

        public IntegerLiteral(String lexeme) {
            super(lexeme, LexicalElement.Type.INTEGER);
            int radix;
            if (lexeme.startsWith("0x") || lexeme.startsWith("0X")) {
                radix = 16;
                lexeme = lexeme.substring(2);
            } else {
                radix = 10;
            }
            if (lexeme.toUpperCase().endsWith("L")) {
                lexeme = lexeme.substring(0, lexeme.length() - 1);
            }
            this.value = Long.parseLong(lexeme, radix);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IntegerLiteral literal = (IntegerLiteral)o;
            return this.value == literal.value;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.value);
        }
    }
}

