/*
 * Decompiled with CFR 0.152.
 */
package javax0.geci.javacomparator.lex;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax0.geci.javacomparator.LexicalElement;
import javax0.geci.javacomparator.lex.CharacterLiteral;
import javax0.geci.javacomparator.lex.CommentLiteral;
import javax0.geci.javacomparator.lex.IdentifierLiteral;
import javax0.geci.javacomparator.lex.LexEater;
import javax0.geci.javacomparator.lex.LexicalElement;
import javax0.geci.javacomparator.lex.NumberLiteral;
import javax0.geci.javacomparator.lex.SpaceLiteral;
import javax0.geci.javacomparator.lex.StringLiteral;
import javax0.geci.javacomparator.lex.SymbolLiteral;

public class Lexer
implements Function<List<String>, LexicalElement[]> {
    private boolean spaceSensitive = false;
    private boolean commentSensitive = false;
    private static final LexEater[] lexEaters = new LexEater[]{new SpaceLiteral(), new CharacterLiteral(), new StringLiteral(), new CommentLiteral(), new IdentifierLiteral(), new NumberLiteral(), new SymbolLiteral()};

    public boolean isSpaceSensitive() {
        return this.spaceSensitive;
    }

    public boolean isCommentSensitive() {
        return this.commentSensitive;
    }

    public Lexer spaceSensitive() {
        this.spaceSensitive = true;
        return this;
    }

    public Lexer commentSensitive() {
        this.commentSensitive = true;
        return this;
    }

    @Override
    public LexicalElement[] apply(List<String> strings) {
        StringBuilder code = new StringBuilder(String.join((CharSequence)"\n", strings));
        ArrayList<LexicalElement> lexes = new ArrayList<LexicalElement>();
        while (code.length() > 0) {
            LexicalElement nextLex = this.next(code);
            if (nextLex == null) continue;
            lexes.add(nextLex);
        }
        return lexes.toArray(new LexicalElement[0]);
    }

    private LexicalElement next(StringBuilder sb) {
        boolean repeat = true;
        block0: while (repeat) {
            repeat = false;
            for (LexEater lexEater : lexEaters) {
                LexicalElement nlextElement = (LexicalElement)lexEater.apply(sb);
                if (nlextElement == null) continue;
                if (!this.ignore(nlextElement)) {
                    return nlextElement;
                }
                repeat = true;
                continue block0;
            }
        }
        if (sb.length() > 0) {
            throw new IllegalArgumentException("Cannot analyze Java source code at " + sb.toString());
        }
        return null;
    }

    private boolean ignore(LexicalElement nlextElement) {
        return !this.spaceSensitive && nlextElement.getType() == LexicalElement.Type.SPACING || !this.commentSensitive && nlextElement.getType() == LexicalElement.Type.COMMENT;
    }
}

