/*
 * Decompiled with CFR 0.152.
 */
package javax0.geci.javacomparator.lex;

import javax0.geci.api.GeciException;

public class Escape {
    private static final String escapes = "btnfr\"'\\";
    private static final String escaped = "\b\t\n\f\r\"'\\";

    static char octal(StringBuilder sb, int maxLen, StringBuilder original) {
        int occ = 0;
        for (int i = maxLen; i > 0 && sb.length() > 0 && sb.charAt(0) >= '0' && sb.charAt(0) <= '7'; --i) {
            occ = 8 * occ + sb.charAt(0) - 48;
            original.append(sb.charAt(0));
            sb.deleteCharAt(0);
        }
        return (char)occ;
    }

    static String escape(String original) {
        StringBuilder sb = new StringBuilder(original);
        StringBuilder output = new StringBuilder();
        StringBuilder ignored = new StringBuilder();
        while (sb.length() > 0) {
            char ch = sb.charAt(0);
            if (ch == '\\') {
                Escape.handleEscape(sb, output, ignored);
                continue;
            }
            output.append(ch);
            sb.deleteCharAt(0);
        }
        return output.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void handleEscape(StringBuilder sb, StringBuilder output, StringBuilder original) {
        original.append(sb.charAt(0));
        sb.deleteCharAt(0);
        if (sb.length() == 0) {
            throw new IllegalArgumentException("Source ended inside a string.");
        }
        char nextCh = sb.charAt(0);
        int esindex = escapes.indexOf(nextCh);
        if (esindex == -1) {
            if (nextCh >= '0' && nextCh <= '3') {
                output.append(Escape.octal(sb, 3, original));
                return;
            } else {
                if (nextCh < '4' || nextCh > '7') throw new IllegalArgumentException("Invalid escape sequence in string: \\" + nextCh);
                output.append(Escape.octal(sb, 2, original));
            }
            return;
        } else {
            original.append(nextCh);
            output.append(escaped.charAt(esindex));
            sb.deleteCharAt(0);
        }
    }

    static void handleNormalCharacter(StringBuilder sb, StringBuilder output, StringBuilder original) {
        char ch = sb.charAt(0);
        if (ch == '\n' || ch == '\r') {
            throw new GeciException("String not terminated before eol:\n" + sb.substring(1, Math.min(sb.length(), 60)) + "...", new Object[0]);
        }
        output.append(ch);
        original.append(ch);
        sb.deleteCharAt(0);
    }

    static void handleNormalMultiLineStringCharacter(StringBuilder sb, StringBuilder output, StringBuilder original) {
        char ch = sb.charAt(0);
        if (ch == '\n' || ch == '\r') {
            Escape.normalizedNewLines(sb, output, original);
        } else {
            output.append(ch);
            original.append(ch);
            sb.deleteCharAt(0);
        }
    }

    private static void normalizedNewLines(StringBuilder sb, StringBuilder output, StringBuilder original) {
        char ch = sb.charAt(0);
        int countNewLines = 0;
        while (sb.length() > 0 && (ch == '\n' || ch == '\r')) {
            if (ch == '\n') {
                ++countNewLines;
            }
            sb.deleteCharAt(0);
            original.append(ch);
            if (sb.length() <= 0) continue;
            ch = sb.charAt(0);
        }
        if (countNewLines == 0) {
            ++countNewLines;
        }
        output.append("\n".repeat(countNewLines));
    }

    static StringBuilder createOutput(StringBuilder sb, String string) {
        if (sb.length() < 2) {
            throw new IllegalArgumentException(string + " has to be at least two characters long.");
        }
        return new StringBuilder();
    }
}

