/*
 * Decompiled with CFR 0.152.
 */
package javax0.geci.javacomparator.lex;

import javax0.geci.api.GeciException;
import javax0.geci.javacomparator.lex.LexEater;
import javax0.geci.javacomparator.lex.LexicalElement;

public class CommentLiteral
implements LexEater {
    @Override
    public LexicalElement apply(StringBuilder sb) {
        if (sb.length() < 2 || sb.charAt(0) != '/' || sb.charAt(1) != '/' && sb.charAt(1) != '*') {
            return null;
        }
        if (sb.charAt(1) == '/') {
            return this.singleLineComment(sb);
        }
        return this.multiLineComment(sb);
    }

    private LexicalElement multiLineComment(StringBuilder sb) {
        StringBuilder output = new StringBuilder("/*");
        sb.delete(0, 2);
        while (sb.length() >= 2 && (sb.charAt(0) != '*' || sb.charAt(1) != '/')) {
            output.append(sb.charAt(0));
            sb.deleteCharAt(0);
        }
        if (sb.length() >= 2) {
            sb.delete(0, 2);
            output.append("*/");
            return new LexicalElement.Comment(output.toString());
        }
        throw new GeciException("Comment is not terminated till end of file", new Object[0]);
    }

    private LexicalElement singleLineComment(StringBuilder sb) {
        StringBuilder output = new StringBuilder("//");
        sb.delete(0, 2);
        while (sb.length() > 0 && sb.charAt(0) != '\n' && sb.charAt(0) != '\r') {
            output.append(sb.charAt(0));
            sb.deleteCharAt(0);
        }
        return new LexicalElement.Comment(output.toString());
    }
}

