/*
 * Decompiled with CFR 0.152.
 */
package javax0.geci.javacomparator.lex;

import javax0.geci.javacomparator.lex.Escape;
import javax0.geci.javacomparator.lex.LexEater;
import javax0.geci.javacomparator.lex.LexicalElement;

public class CharacterLiteral
implements LexEater {
    private static final String CHARACTER = "Character";
    private static final char ENCLOSING = '\'';

    @Override
    public LexicalElement.CharacterLiteral apply(StringBuilder sb) {
        if (sb.length() == 0 || sb.charAt(0) != '\'') {
            return null;
        }
        StringBuilder output = Escape.createOutput(sb, CHARACTER);
        StringBuilder original = Escape.createOutput(sb, CHARACTER);
        sb.deleteCharAt(0);
        while (sb.length() > 0 && sb.charAt(0) != '\'') {
            char ch = sb.charAt(0);
            if (ch == '\\') {
                Escape.handleEscape(sb, output, original);
                continue;
            }
            Escape.handleNormalCharacter(sb, output, original);
        }
        if (sb.length() == 0) {
            throw new IllegalArgumentException("Character is not terminated before eol");
        }
        sb.deleteCharAt(0);
        return new LexicalElement.CharacterLiteral(output.toString(), original.toString());
    }
}

