/*
 * Decompiled with CFR 0.152.
 */
package javax0.geci.jamal.junit5;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax0.geci.api.Generator;
import javax0.geci.api.Source;
import javax0.geci.engine.Geci;
import javax0.geci.jamal.JamalGenerator;
import javax0.geci.jamal.junit5.GeciJamalTestDescriptor;
import javax0.geci.jamal.junit5.GeciTestSource;
import javax0.geci.log.Logger;
import javax0.geci.log.LoggerFactory;
import org.junit.platform.engine.ConfigurationParameters;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.ExecutionRequest;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestEngine;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.UniqueId;
import org.opentest4j.AssertionFailedError;
import org.opentest4j.TestAbortedException;

public class Engine
implements TestEngine {
    private static final Logger LOG = LoggerFactory.getLogger();
    private TestDescriptor testDescriptor;

    public String getId() {
        return "Junit5::Geci";
    }

    public TestDescriptor discover(EngineDiscoveryRequest engineDiscoveryRequest, UniqueId uniqueId) {
        if (this.testDescriptor != null) {
            LOG.info("discovery invocation repeated", new Object[0]);
            return this.testDescriptor;
        }
        LOG.info("discovery invoked", new Object[0]);
        this.testDescriptor = new GeciJamalTestDescriptor(UniqueId.root((String)this.getId(), (String)"Geci::Jamal"), "Geci::Jamal code generation execution", new GeciTestSource());
        return this.testDescriptor;
    }

    public void execute(ExecutionRequest executionRequest) {
        Optional optional;
        ConfigurationParameters cp = executionRequest.getConfigurationParameters();
        TestDescriptor td = executionRequest.getRootTestDescriptor();
        EngineExecutionListener listener = executionRequest.getEngineExecutionListener();
        listener.executionStarted(td);
        Geci geci = new Geci();
        for (Source.NamedSourceSet namedSourceSet : this.getNamedSourceSets(cp)) {
            geci = geci.source(namedSourceSet);
        }
        for (String string : this.getIgnorePatterns(cp)) {
            geci = geci.ignore(new String[]{string});
        }
        for (String string : this.getOnlyPatterns(cp)) {
            geci = geci.only(new String[]{string});
        }
        Optional ignoreBinary = cp.getBoolean("geci.ignoreBinary");
        if (ignoreBinary.isPresent() && ((Boolean)ignoreBinary.get()).booleanValue()) {
            geci.ignoreBinary();
        }
        if ((optional = cp.get("geci.diffOutput")).isPresent()) {
            geci = geci.diffOutput((String)optional.get());
        }
        try {
            LOG.info("GECI Jamal executing code generator for all the files in the source set", new Object[0]);
            if (geci.register(new Generator[]{new JamalGenerator()}).generate()) {
                listener.executionFinished(td, TestExecutionResult.failed((Throwable)new AssertionFailedError(geci.failed(), (Object)"", (Object)"")));
            } else {
                listener.executionFinished(td, TestExecutionResult.successful());
            }
        }
        catch (Exception e) {
            LOG.info("GECI Jamal There was an exception executing the code generation.", new Object[0]);
            listener.executionFinished(td, TestExecutionResult.failed((Throwable)e));
        }
        LOG.info("Junit5::Geci execute()", new Object[0]);
    }

    private List<String> getIgnorePatterns(ConfigurationParameters cp) {
        return this.getPatterns(cp, "ignore");
    }

    private List<String> getOnlyPatterns(ConfigurationParameters cp) {
        return this.getPatterns(cp, "only");
    }

    private List<String> getPatterns(ConfigurationParameters cp, String keyword) {
        ArrayList<String> ignores = new ArrayList<String>();
        Optional ignore = cp.get("geci." + keyword);
        if (ignore.isPresent()) {
            ignores.add((String)ignore.get());
        }
        for (int i = 0; (ignore = cp.get("geci." + keyword + "." + i)).isPresent() || i <= 100; ++i) {
            if (!ignore.isPresent()) continue;
            ignores.add((String)ignore.get());
        }
        return ignores;
    }

    private List<Source.NamedSourceSet> getNamedSourceSets(ConfigurationParameters cp) {
        ArrayList<Source.NamedSourceSet> sets = new ArrayList<Source.NamedSourceSet>();
        Optional setsOpt = cp.get("geci.sourceSets");
        if (setsOpt.isPresent()) {
            LOG.info("GECI Jamal source sets defined are: ", new Object[]{setsOpt.get()});
            for (String setName : Arrays.stream(((String)setsOpt.get()).split(",")).map(String::trim).collect(Collectors.toList())) {
                Optional setOpt = cp.get(setName);
                if (setOpt.isEmpty()) {
                    throw new TestAbortedException(String.format("Set named '%s' is not configured in the file '%s'", setName, "junit-platform.properties"));
                }
                sets.add(new Source.NamedSourceSet(Source.Set.set((String)setName), (String[])Arrays.stream(((String)setOpt.get()).split(",")).map(String::trim).toArray(String[]::new)));
            }
        }
        return sets;
    }

    public Optional<String> getGroupId() {
        return Optional.of("com.javax0.geci");
    }

    public Optional<String> getArtifactId() {
        return Optional.of("javageci-jamal");
    }

    public Optional<String> getVersion() {
        return Optional.of("1.6.3");
    }
}

