/*
 * Decompiled with CFR 0.152.
 */
package javax0.geci.jamal.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.stream.Collectors;
import javax0.geci.tools.GeciReflectionTools;
import javax0.geci.tools.reflection.ModifiersBuilder;

public class EntityStringer {
    private static String importedClass(String fqClassName, String[] imports) {
        if (imports != null) {
            for (String cn : imports) {
                if (cn == null) continue;
                int i = fqClassName.lastIndexOf(46);
                if (cn.equals(fqClassName)) {
                    if (i == -1) {
                        return fqClassName;
                    }
                    return fqClassName.substring(i + 1);
                }
                if (!cn.endsWith("*") || !fqClassName.startsWith(cn.substring(0, cn.length() - 1))) continue;
                return fqClassName.substring(i + 1);
            }
        }
        return fqClassName;
    }

    public static String method2Fingerprint(Method method, String format, String argSep, String exceptionSep, String[] imports) {
        Object throwFqExceptions;
        Object throwExceptions;
        String fqClassName = method.getDeclaringClass().getCanonicalName();
        String className = EntityStringer.importedClass(fqClassName.replaceAll("^java.lang.", ""), imports);
        String fqArgs = EntityStringer.getTypeList(method, argSep, null);
        String args = EntityStringer.getTypeList(method, argSep, imports);
        String modifiers = GeciReflectionTools.modifiersString((Method)method).trim();
        String fqType = GeciReflectionTools.getGenericTypeName(method.getReturnType());
        String type = EntityStringer.importedClass(fqType.replaceAll("^java.lang.", ""), imports);
        String fqExceptions = Arrays.stream(method.getExceptionTypes()).map(Type::getTypeName).collect(Collectors.joining(exceptionSep));
        String exceptions = Arrays.stream(method.getExceptionTypes()).map(Type::getTypeName).map(s -> s.replaceAll("^java.lang.", "")).map(tn -> EntityStringer.importedClass(tn, imports)).collect(Collectors.joining(exceptionSep));
        if (exceptions.length() > 0) {
            throwExceptions = "throw " + exceptions;
            throwFqExceptions = "throw " + fqExceptions;
        } else {
            throwExceptions = "";
            throwFqExceptions = "";
        }
        return format.replaceAll("\\$class", className).replaceAll("\\$fqClass", fqClassName).replaceAll("\\$modifiers", modifiers + (modifiers.length() > 0 ? " " : "")).replaceAll("\\$name", method.getName()).replaceAll("\\$exceptions", exceptions).replaceAll("\\$fqExceptions", fqExceptions).replaceAll("\\$throws", (String)throwExceptions).replaceAll("\\$fqThrows", (String)throwFqExceptions).replaceAll("\\$args", args).replaceAll("\\$fqArgs", fqArgs).replaceAll("\\$fqType", fqType).replaceAll("\\$type", type);
    }

    private static String getTypeList(Method method, String argSep, String[] imports) {
        String argList = Arrays.stream(method.getGenericParameterTypes()).map(Type::getTypeName).map(tn -> EntityStringer.importedClass(tn, imports)).collect(Collectors.joining(argSep));
        if (argList.endsWith("[]") && method.isVarArgs()) {
            return argList.substring(0, argList.length() - 2) + "...";
        }
        return argList;
    }

    public static String field2Fingerprint(Field field, String format, String[] imports) {
        String fqClassName = field.getDeclaringClass().getCanonicalName();
        String className = EntityStringer.importedClass(fqClassName, imports);
        String fqType = GeciReflectionTools.getGenericTypeName(field.getType());
        String type = EntityStringer.importedClass(fqType, imports);
        String modifiers = new ModifiersBuilder(field.getModifiers()).field().toString().trim();
        return format.replaceAll("\\$class", className).replaceAll("\\$fqClass", fqClassName).replaceAll("\\$name", field.getName()).replaceAll("\\$type", type).replaceAll("\\$fqType", fqType).replaceAll("\\$modifiers", modifiers + (modifiers.length() > 0 ? " " : ""));
    }
}

