/*
 * Decompiled with CFR 0.152.
 */
package javax0.geci.jamal.macros;

import javax0.jamal.api.BadSyntax;
import javax0.jamal.api.Input;
import javax0.jamal.api.Macro;
import javax0.jamal.api.Processor;
import javax0.jamal.tools.InputHandler;

public class ArgumentFormatters {
    private static void normalize(String[] typeNames) {
        for (int i = 0; i < typeNames.length; ++i) {
            typeNames[i] = typeNames[i].trim();
            if (!typeNames[i].startsWith("java.lang.")) continue;
            typeNames[i] = typeNames[i].substring("java.lang.".length());
        }
    }

    public static class ClassList
    extends ArgConverter {
        public String getId() {
            return "classList";
        }

        @Override
        protected String argConverter(String s, int position) {
            if (s.endsWith("...")) {
                return s.substring(0, s.length() - 3) + "[].class";
            }
            return s + ".class";
        }
    }

    public static class CallArgs
    extends ArgConverter {
        public String getId() {
            return "callArgs";
        }

        @Override
        protected String argConverter(String s, int position) {
            return "arg" + position;
        }
    }

    public static class ArgList
    extends ArgConverter {
        public String getId() {
            return "argList";
        }

        @Override
        protected String argConverter(String s, int position) {
            return s + " arg" + position;
        }
    }

    private static abstract class ArgConverter
    implements Macro {
        private ArgConverter() {
        }

        protected abstract String argConverter(String var1, int var2);

        public String evaluate(Input in, Processor processor) throws BadSyntax {
            String[] typeNames;
            InputHandler.skipWhiteSpaces((Input)in);
            boolean startWithComma = InputHandler.firstCharIs((CharSequence)in, (char[])new char[]{','});
            if (startWithComma) {
                InputHandler.skip((Input)in, (int)1);
            }
            if ((typeNames = in.toString().split(":", -1)).length == 1 && typeNames[0].length() == 0) {
                return "";
            }
            ArgumentFormatters.normalize(typeNames);
            for (int i = 0; i < typeNames.length; ++i) {
                typeNames[i] = this.argConverter(typeNames[i], i);
            }
            StringBuilder sb = new StringBuilder();
            boolean i = true;
            String sep = startWithComma ? "," : "";
            for (String typeName : typeNames) {
                sb.append(sep).append(typeName);
                sep = ",";
            }
            return sb.toString();
        }
    }
}

