/*
 * Decompiled with CFR 0.152.
 */
package javax0.geci.jamal;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax0.geci.api.GeciException;
import javax0.geci.api.Segment;
import javax0.geci.api.Source;
import javax0.geci.jamal.macros.holders.ImportsHolder;
import javax0.geci.tools.AbstractGeneratorEx;
import javax0.geci.tools.CompoundParams;
import javax0.geci.tools.CompoundParamsBuilder;
import javax0.jamal.api.BadSyntax;
import javax0.jamal.api.Identified;
import javax0.jamal.api.Input;
import javax0.jamal.api.Position;
import javax0.jamal.engine.Processor;

public class JamalGenerator
extends AbstractGeneratorEx {
    private static final Pattern START = Pattern.compile("^\\s*/\\*!(jamal\\s*.*)$");
    private static final Pattern COMMENT_END = Pattern.compile("^\\s*\\*/\\s*$");
    private static final Pattern SEGMENT_END = Pattern.compile("^\\s*//\\s*__END__\\s*$");
    private static final Pattern IMPORT = Pattern.compile("^\\s*import\\s*(.*);\\s*$");
    private static final Pattern PACKAGE = Pattern.compile("^\\s*package\\s*(.*);\\s*$");
    private static final Pattern CLASS_START = Pattern.compile("^\\s*(:?private\\s+|protected\\s+|public\\s+)?class\\s+.*$");

    public void processEx(Source source) {
        Processor processor = null;
        List lines = source.getLines();
        ArrayList<Object> imports = new ArrayList<Object>();
        for (String line : lines) {
            Matcher importMatcher;
            Matcher packageMatcher = PACKAGE.matcher(line);
            if (packageMatcher.matches()) {
                imports.add(packageMatcher.group(1) + ".*");
            }
            if ((importMatcher = IMPORT.matcher(line)).matches()) {
                imports.add(importMatcher.group(1));
            }
            if (!CLASS_START.matcher(line).matches()) continue;
            break;
        }
        boolean touched = false;
        StringBuilder sb = new StringBuilder();
        PROCESSING state = PROCESSING.COPY;
        StringBuilder macro = new StringBuilder();
        int lineNr = 0;
        int positionLineNr = 0;
        String optionsLine = "";
        for (String line : lines) {
            ++lineNr;
            switch (state) {
                case COPY: {
                    sb.append(line).append("\n");
                    Matcher startMatcher = START.matcher(line);
                    if (!startMatcher.matches()) break;
                    optionsLine = startMatcher.group(1);
                    touched = true;
                    state = PROCESSING.INSOURCE;
                    macro.delete(0, macro.length());
                    positionLineNr = lineNr + 1;
                    break;
                }
                case INSOURCE: {
                    sb.append(line).append("\n");
                    if (COMMENT_END.matcher(line).matches()) {
                        String result;
                        state = PROCESSING.OUTPUT;
                        try {
                            if (processor == null) {
                                CompoundParams params = new CompoundParamsBuilder(optionsLine).build();
                                String debug = params.get("debug", "");
                                try {
                                    System.setProperty("jamal.debug", debug);
                                    processor = new Processor("{%", "%}");
                                    processor.define((Identified)new ImportsHolder((String[])imports.toArray(String[]::new)));
                                }
                                catch (IllegalArgumentException ex) {
                                    throw new GeciException("Jamal processor opening threw exception", (Throwable)ex);
                                }
                            }
                            result = processor.process((Input)new javax0.jamal.tools.Input(macro.toString(), new Position(source.getAbsoluteFile(), positionLineNr)));
                            macro.delete(0, macro.length());
                        }
                        catch (BadSyntax badSyntax) {
                            throw new GeciException("Macro processing in file '" + source.getAbsoluteFile() + "' threw exception", (Throwable)badSyntax);
                        }
                        sb.append(result);
                        break;
                    }
                    macro.append(line).append("\n");
                    break;
                }
                case OUTPUT: {
                    if (!SEGMENT_END.matcher(line).matches()) break;
                    sb.append(line).append("\n");
                    state = PROCESSING.COPY;
                }
            }
        }
        if (touched) {
            try (Segment output = source.open();){
                output.write(sb.toString(), new Object[0]);
            }
        }
        if (processor != null) {
            processor.close();
        }
    }

    private static enum PROCESSING {
        COPY,
        INSOURCE,
        OUTPUT;

    }
}

