/*
 * Decompiled with CFR 0.152.
 */
package javax0.geci.engine.testsupport;

import java.util.Arrays;
import java.util.List;
import javax0.geci.api.GeciException;
import javax0.geci.api.Generator;
import javax0.geci.engine.Source;
import javax0.geci.tools.AbstractJavaGenerator;
import javax0.geci.tools.CompoundParams;
import javax0.geci.tools.CompoundParamsBuilder;

public class GeneratorTester {
    final Generator sut;
    private Class<?> klass = null;
    private String[] sourceLines;
    private List<String> expected;
    private boolean mustModify = true;
    private Source source;

    private GeneratorTester(Generator sut) {
        this.sut = sut;
    }

    public static GeneratorTester generator(Generator generator) {
        return new GeneratorTester(generator);
    }

    public GeneratorTester klass(Class<?> klass) {
        this.klass = klass;
        return this;
    }

    public GeneratorTester source(String ... sourceLines) {
        this.sourceLines = sourceLines;
        return this;
    }

    public GeneratorTester expected(String ... expectedLines) {
        this.expected = Arrays.asList(expectedLines);
        return this;
    }

    public GeneratorTester noChange() {
        this.expected = Arrays.asList(this.sourceLines);
        this.mustModify = false;
        return this;
    }

    public GeneratorTester test() throws Exception {
        Source.MockBuilder mockBuilder = Source.mock(this.sut);
        this.source = mockBuilder.lines(this.sourceLines).getSource();
        CompoundParams global = new CompoundParamsBuilder("jdocify").build();
        if (this.sut instanceof AbstractJavaGenerator) {
            ((AbstractJavaGenerator)this.sut).process((javax0.geci.api.Source)this.source, this.klass, global);
        } else {
            this.sut.process((javax0.geci.api.Source)this.source);
        }
        this.source.consolidate();
        if (!mockBuilder.isTouched()) {
            throw new GeciException("Source code was not touched", new Object[0]);
        }
        if (mockBuilder.isModified((orig, gen) -> !orig.equals(gen)) != this.mustModify) {
            throw new GeciException("The code was " + (this.mustModify ? "not modifed" : "modified"), new Object[0]);
        }
        return this;
    }

    public String expected() {
        return String.join((CharSequence)"\n", this.expected);
    }

    public String actual() {
        return String.join((CharSequence)"\n", this.source.getLines());
    }
}

