/*
 * Decompiled with CFR 0.152.
 */
package javax0.geci.engine;

import javax0.geci.api.Generator;
import javax0.geci.api.Logger;
import javax0.geci.engine.Source;

public class SourceLogger
implements Logger {
    final Source source;
    static final int TRACE = 1;
    static final int DEBUG = 2;
    static final int INFO = 3;
    static final int WARNING = 4;
    static final int ERROR = 5;

    public SourceLogger(Source source) {
        this.source = source;
    }

    public void trace(String format, Object ... params) {
        this.source.logEntries.add(new LogEntry(String.format(format, params), this.source.currentGenerator, 1));
    }

    public void debug(String format, Object ... params) {
        this.source.logEntries.add(new LogEntry(String.format(format, params), this.source.currentGenerator, 2));
    }

    public void info(String format, Object ... params) {
        this.source.logEntries.add(new LogEntry(String.format(format, params), this.source.currentGenerator, 3));
    }

    public void warning(String format, Object ... params) {
        this.source.logEntries.add(new LogEntry(String.format(format, params), this.source.currentGenerator, 4));
    }

    public void error(String format, Object ... params) {
        this.source.logEntries.add(new LogEntry(String.format(format, params), this.source.currentGenerator, 5));
    }

    static class LogEntry {
        final String message;
        final Generator generator;
        final int level;

        LogEntry(String message, Generator generator, int level) {
            this.message = message;
            this.generator = generator;
            this.level = level;
        }
    }
}

