/*
 * Decompiled with CFR 0.152.
 */
package javax0.geci.engine;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.stream.Stream;
import javax0.geci.api.CompoundParams;
import javax0.geci.api.Distant;
import javax0.geci.api.GeciException;
import javax0.geci.api.Generator;
import javax0.geci.api.Logger;
import javax0.geci.api.SegmentSplitHelper;
import javax0.geci.api.Source;
import javax0.geci.engine.FileCollector;
import javax0.geci.engine.FileSystemSourceStore;
import javax0.geci.engine.MockSourceStore;
import javax0.geci.engine.Segment;
import javax0.geci.engine.SourceLogger;
import javax0.geci.engine.SourceStore;
import javax0.geci.tools.GeciReflectionTools;
import javax0.geci.util.JavaSegmentSplitHelper;

public class Source
implements javax0.geci.api.Source {
    final List<String> lines = new ArrayList<String>();
    private final String className;
    final String relativeFile;
    final String absoluteFile;
    private final Map<String, Segment> segments = new HashMap<String, Segment>();
    final List<String> originals = new ArrayList<String>();
    private final FileCollector collector;
    private final SegmentSplitHelper splitHelper;
    boolean inMemory = false;
    private Segment globalSegment = null;
    private boolean touched = false;
    private long touchBits = 0L;
    boolean allowDefaultSegment = false;
    boolean isBinary = false;
    private boolean isBorrowed = false;
    private final SourceStore store;
    Generator currentGenerator = null;
    final List<SourceLogger.LogEntry> logEntries = new ArrayList<SourceLogger.LogEntry>();
    private final Logger logger = new SourceLogger(this);
    private boolean segmentsLoaded = false;

    public MockSourceStore getSourceStore() {
        if (this.store instanceof MockSourceStore) {
            return (MockSourceStore)this.store;
        }
        throw new GeciException("Source.getSourceStore() must be invoked only from test code", new Object[0]);
    }

    private void assertTouching() {
        if (this.currentGenerator != null && this.currentGenerator instanceof Distant) {
            throw new GeciException("The distant generator " + this.currentGenerator.getClass().getName() + " tried to touch the source " + this.getAbsoluteFile(), new Object[0]);
        }
    }

    public static MockBuilder mock(Generator sut) {
        return new MockBuilder(sut);
    }

    private Source(Generator currentGenerator, String className, String relativeFile, String absoluteFile, SegmentSplitHelper splitHelper, List<String> lines) {
        this.currentGenerator = currentGenerator;
        this.className = className;
        this.relativeFile = relativeFile;
        this.absoluteFile = absoluteFile;
        this.splitHelper = splitHelper;
        this.lines.addAll(lines);
        this.originals.addAll(lines);
        this.collector = null;
        this.inMemory = true;
        this.store = new MockSourceStore();
    }

    Source(FileCollector collector, String dir, Path path) {
        this.collector = collector;
        this.className = FileCollector.calculateClassName(dir, path);
        this.relativeFile = FileCollector.calculateRelativeName(dir, path);
        this.absoluteFile = FileCollector.toAbsolute(path);
        this.splitHelper = collector.getSegmentSplitHelper(this);
        this.store = new FileSystemSourceStore(this.collector, this.relativeFile, dir);
    }

    boolean isTouched() {
        return this.touched;
    }

    long getTouchBits() {
        return this.touchBits;
    }

    public String getAbsoluteFile() {
        return this.absoluteFile;
    }

    public void init(String id) throws IOException {
        if (id == null || id.isEmpty()) {
            return;
        }
        this.open(id);
    }

    public javax0.geci.api.Source newSource(Source.Set sourceSet, String fileName) {
        this.assertTouching();
        return this.store.get(sourceSet, fileName);
    }

    public javax0.geci.api.Source newSource(String fileName) {
        this.assertTouching();
        return this.store.get(fileName);
    }

    public String toString() {
        if (!this.inMemory) {
            try {
                this.readToMemory();
            }
            catch (IOException e) {
                throw new GeciException((Throwable)e);
            }
        }
        return String.join((CharSequence)"\n", this.lines);
    }

    public void returns(List<String> lines) {
        if (!this.isBorrowed) {
            throw new GeciException("Source " + this.getAbsoluteFile() + " cannot be returned before it was borrowed.", new Object[0]);
        }
        if (!this.inMemory) {
            throw new GeciException("Source " + this.getAbsoluteFile() + " cannot be returned before it is read from file.", new Object[0]);
        }
        this.inMemory = true;
        if (lines != null) {
            this.lines.clear();
            this.lines.addAll(lines);
        }
        this.isBorrowed = false;
        this.touched = true;
    }

    public List<String> borrows() {
        if (this.isBorrowed) {
            throw new GeciException("Source " + this.getAbsoluteFile() + " cannot be borrowed more than once. Has to be returned before.", new Object[0]);
        }
        List<String> lines = this.getLines();
        this.isBorrowed = true;
        return lines;
    }

    public List<String> getLines() {
        this.assertNotBorrowed();
        this.readToMemorySafely();
        return this.lines;
    }

    private void readToMemorySafely() {
        if (!this.inMemory) {
            try {
                this.readToMemory();
            }
            catch (IOException e) {
                this.inMemory = true;
                this.originals.clear();
                this.lines.clear();
            }
        }
    }

    public Segment open() {
        this.assertNotBorrowed();
        this.assertTouching();
        if (!this.segments.isEmpty()) {
            throw new GeciException("Global segment was opened when the there were already opened segments", new Object[0]);
        }
        if (this.globalSegment == null) {
            this.globalSegment = new Segment(0);
        }
        this.readToMemorySafely();
        return this.globalSegment;
    }

    public Set<String> segmentNames() {
        this.assertNotBorrowed();
        this.loadSegments();
        return this.segments.keySet();
    }

    public Segment temporary() {
        this.assertTouching();
        return new Segment(0);
    }

    public Segment safeOpen(String id) throws IOException {
        Segment segment = this.open(id);
        if (segment == null) {
            throw new GeciException(this.getAbsoluteFile() + " does not have segment named '" + id + "'", new Object[0]);
        }
        return segment;
    }

    private String[] mnemonize(String id, String ... s) {
        return (String[])Arrays.stream(s).map(item -> item.replaceAll("\\{\\{mnemonic}}", id)).toArray(String[]::new);
    }

    public void allowDefaultSegment() {
        this.allowDefaultSegment = true;
    }

    public Segment open(String id) throws IOException {
        this.assertNotBorrowed();
        this.assertTouching();
        if (this.globalSegment != null) {
            throw new GeciException("Segment was opened after the global segment was already created.", new Object[0]);
        }
        if (!this.inMemory) {
            this.readToMemory();
        }
        if (!this.segments.containsKey(id)) {
            boolean defaultSegment = false;
            SegmentDescriptor segDesc = this.findSegment(id);
            if (segDesc == null) {
                segDesc = this.findDefaultSegment();
                if (segDesc == null) {
                    return null;
                }
                defaultSegment = true;
            }
            try (Segment segment = new Segment(segDesc.tab, segDesc.attr, segDesc.originals);){
                if (defaultSegment) {
                    segment.setPreface(this.mnemonize(id, this.splitHelper.getSegmentPreface()));
                    segment.setPostface(this.mnemonize(id, this.splitHelper.getSegmentPostface()));
                }
                this.segments.put(id, segment);
            }
        }
        return this.segments.get(id);
    }

    public String getKlassName() {
        return this.className;
    }

    public String getKlassSimpleName() {
        return this.className.replaceAll("^.*\\.", "");
    }

    public Class<?> getKlass() {
        try {
            return GeciReflectionTools.classForName((String)this.className);
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            return null;
        }
    }

    public Logger getLogger() {
        return this.logger;
    }

    public String getPackageName() {
        return this.getKlassName().replaceAll("\\.\\w+$", "");
    }

    private void assertNotBorrowed() {
        if (this.isBorrowed) {
            throw new GeciException("Source " + this.getAbsoluteFile() + " was borrowed and not returned.", new Object[0]);
        }
    }

    public void consolidate() {
        this.assertNotBorrowed();
        if (!this.inMemory && !this.segments.isEmpty()) {
            throw new GeciException("This is an internal error: source was not read into memory but segments were generated", new Object[0]);
        }
        if (this.globalSegment == null) {
            this.segments.forEach((id, segment) -> {
                this.touched = true;
                this.touchBits |= segment.touch(0L);
                SegmentDescriptor segmentLocation = this.findSegment((String)id);
                if (segmentLocation == null && (segmentLocation = this.findDefaultSegment()) == null) {
                    throw new GeciException("Segment " + id + " disappeared from source" + this.absoluteFile, new Object[0]);
                }
                this.mergeSegment((Segment)segment, segmentLocation);
            });
        } else {
            this.touched = true;
            this.lines.clear();
            this.lines.addAll(this.globalSegment.lines);
        }
    }

    private void mergeSegment(Segment segment, SegmentDescriptor segmentLocation) {
        if (segmentLocation.startLine < segmentLocation.endLine || segment.lines.size() > 0) {
            if (segmentLocation.startLine < segmentLocation.endLine) {
                this.lines.subList(segmentLocation.startLine, segmentLocation.endLine).clear();
            }
            this.lines.addAll(segmentLocation.startLine, segment.postface);
            this.lines.addAll(segmentLocation.startLine, segment.lines);
            this.lines.addAll(segmentLocation.startLine, segment.preface);
        }
    }

    boolean isModified(BiPredicate<List<String>, List<String>> sourceModified) {
        return sourceModified.test(this.originals, this.lines);
    }

    void save() throws IOException {
        Path path = Paths.get(this.absoluteFile, new String[0]);
        Path parent = path.getParent();
        if (!Files.exists(parent, new LinkOption[0])) {
            try {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Files.write(path, this.lines, StandardCharsets.UTF_8, new OpenOption[0]);
    }

    private void readToMemory() throws IOException {
        try (Stream<String> stream = Files.lines(Paths.get(this.absoluteFile, new String[0]));){
            stream.forEach(line -> {
                this.lines.add((String)line);
                this.originals.add((String)line);
            });
            this.inMemory = true;
        }
        catch (IOException e) {
            throw e;
        }
        catch (UncheckedIOException e) {
            this.isBinary = true;
            throw new SourceIsBinary(this.absoluteFile);
        }
        catch (Exception e) {
            throw new GeciException("Cannot read the file " + this.absoluteFile + "\nIt is probably binary file. Use '.ignore()' to filter binary files out", (Throwable)e);
        }
    }

    private SegmentDescriptor findDefaultSegment() {
        if (this.allowDefaultSegment) {
            for (int i = this.lines.size() - 1; 0 < i; --i) {
                SegmentSplitHelper.Matcher matcher = this.splitHelper.match(this.lines, i);
                if (!matcher.isDefaultSegmentEnd()) continue;
                SegmentDescriptor seg = new SegmentDescriptor();
                seg.attr = null;
                seg.startLine = i + matcher.headerLength();
                seg.endLine = i;
                seg.tab = matcher.tabbing();
                return seg;
            }
        }
        return null;
    }

    private SegmentDescriptor findSegment(String id) {
        for (int i = 0; i < this.lines.size(); ++i) {
            CompoundParams attr;
            String line = this.lines.get(i);
            SegmentSplitHelper.Matcher matcher = this.splitHelper.match(this.lines, i);
            if (!matcher.isSegmentStart() || !id.equals((attr = matcher.attributes()).id())) continue;
            SegmentDescriptor seg = new SegmentDescriptor();
            seg.id = id;
            seg.originals = new ArrayList<String>();
            seg.attr = attr;
            seg.tab = matcher.tabbing();
            for (int j = seg.startLine = i + matcher.headerLength(); j < this.lines.size(); ++j) {
                line = this.lines.get(j);
                SegmentSplitHelper.Matcher endMatcher = this.splitHelper.match(line);
                if (endMatcher.isSegmentEnd()) {
                    seg.endLine = j;
                    return seg;
                }
                seg.originals.add(line);
            }
            throw new GeciException("Segment '" + seg.attr.id() + "'does not end in file " + this.getAbsoluteFile(), new Object[0]);
        }
        return null;
    }

    private void loadSegments() {
        if (this.segmentsLoaded) {
            return;
        }
        for (int i = 0; i < this.lines.size(); ++i) {
            String line = this.lines.get(i);
            SegmentSplitHelper.Matcher matcher = this.splitHelper.match(this.lines, i);
            if (!matcher.isSegmentStart()) continue;
            CompoundParams attr = matcher.attributes();
            SegmentDescriptor seg = new SegmentDescriptor();
            seg.id = attr.id();
            seg.originals = new ArrayList<String>();
            seg.attr = attr;
            seg.tab = matcher.tabbing();
            for (i = seg.startLine = i + matcher.headerLength(); i < this.lines.size(); ++i) {
                line = this.lines.get(i);
                SegmentSplitHelper.Matcher endMatcher = this.splitHelper.match(this.lines, i);
                if (endMatcher.isSegmentEnd()) {
                    seg.endLine = i;
                    if (!this.segments.containsKey(seg.id)) {
                        this.segments.put(seg.id, new Segment(seg.tab, seg.attr, seg.originals));
                        break;
                    }
                    throw new GeciException("Segment " + seg.id + " is defined multiple times in source " + this.getAbsoluteFile(), new Object[0]);
                }
                seg.originals.add(line);
            }
            if (i < this.lines.size()) continue;
            throw new GeciException("Segment '" + seg.attr.id() + "' does not end in file " + this.getAbsoluteFile(), new Object[0]);
        }
        this.segmentsLoaded = true;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        Source source = (Source)other;
        return this.absoluteFile.equals(source.absoluteFile);
    }

    public int hashCode() {
        return Objects.hash(this.absoluteFile);
    }

    private static class SegmentDescriptor {
        String id;
        List<String> originals;
        int startLine;
        int endLine;
        CompoundParams attr;
        int tab;

        private SegmentDescriptor() {
        }
    }

    public static class MockBuilder {
        private final Generator sut;
        private String className;
        private String relativeFile = "DIRECTORY\\MOCKED_FILE.MOCKED";
        private String absoluteFile = "C:\\MOCKED\\DIRECTORY\\MOCKED_FILE.MOCKED";
        private SegmentSplitHelper splitHelper = new JavaSegmentSplitHelper();
        final List<String> lines = new ArrayList<String>();
        private Source mockedSource;

        public MockBuilder(Generator sut) {
            this.sut = sut;
        }

        public MockBuilder absoluteFile(String absoluteFile) {
            this.absoluteFile = absoluteFile;
            return this;
        }

        public MockBuilder className(String className) {
            this.className = className;
            return this;
        }

        public MockBuilder relativeFile(String relativeFile) {
            this.relativeFile = relativeFile;
            return this;
        }

        public MockBuilder splitHelper(String fileName) {
            this.splitHelper = this.splitHelper;
            return this;
        }

        public MockBuilder splitHelper(SegmentSplitHelper splitHelper) {
            this.splitHelper = splitHelper;
            return this;
        }

        public MockBuilder lines(String ... lines) {
            for (String line : lines) {
                this.lines.addAll(Arrays.asList(line.split("\n")));
            }
            return this;
        }

        public boolean isTouched() {
            return this.mockedSource.isTouched();
        }

        public boolean isModified(BiPredicate<List<String>, List<String>> sourceModified) {
            return this.mockedSource.isModified(sourceModified);
        }

        public Source getSource() {
            this.mockedSource = new Source(this.sut, this.className, this.relativeFile, this.absoluteFile, this.splitHelper, this.lines);
            return this.mockedSource;
        }
    }

    static class SourceIsBinary
    extends GeciException {
        final String absoluteFile;

        String getAbsoluteFile() {
            return this.absoluteFile;
        }

        SourceIsBinary(String absoluteFile) {
            this.absoluteFile = absoluteFile;
        }
    }
}

