/*
 * Decompiled with CFR 0.152.
 */
package javax0.geci.engine;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax0.geci.api.GeciException;
import javax0.geci.tools.CompoundParams;
import javax0.geci.tools.Template;
import javax0.geci.tools.Tracer;

public class Segment
implements javax0.geci.api.Segment {
    private static final int TAB = 4;
    final List<String> preface = new LinkedList<String>();
    final List<String> lines = new LinkedList<String>();
    final List<String> postface = new LinkedList<String>();
    private final int openingTabStop;
    private int tabStop;
    private final Map<String, String> params = new HashMap<String, String>();
    private final javax0.geci.api.CompoundParams cparams;
    private final List<String> originals;
    private long touchBits = 0L;

    public Segment(int tabStop) {
        this.openingTabStop = tabStop;
        this.tabStop = tabStop;
        this.cparams = new CompoundParams(new CompoundParams[0]);
        this.originals = Collections.emptyList();
    }

    public Segment(int tabStop, javax0.geci.api.CompoundParams cparams, List<String> originals) {
        this.openingTabStop = tabStop;
        this.tabStop = tabStop;
        this.cparams = cparams;
        this.originals = originals;
    }

    public long touch(long value) {
        return this.touchBits |= value;
    }

    public javax0.geci.api.CompoundParams sourceParams() {
        return this.cparams;
    }

    public void resetParams() {
        this.params.clear();
    }

    public Segment param(String ... keyValuePairs) {
        if (keyValuePairs.length % 2 == 1) {
            throw new IllegalArgumentException("Parameters to Segment.param() should be in pair");
        }
        for (int i = 0; i < keyValuePairs.length; i += 2) {
            this.params.put(keyValuePairs[i], keyValuePairs[i + 1]);
        }
        return this;
    }

    public Optional<String> getParam(String key) {
        if (this.params.containsKey(key)) {
            return Optional.of(this.params.get(key));
        }
        return Optional.empty();
    }

    public Set<String> paramKeySet() {
        return this.params.keySet();
    }

    public void traceParams() {
        this.params.forEach(Tracer::log);
    }

    public void traceLines() {
        try (Tracer pos = Tracer.push((String)"SegmentContent", null);){
            try (Tracer lines = Tracer.push((String)"Originals", null);){
                this.originals.forEach(line -> Tracer.log((String)"Line", (String)line));
            }
            try (Tracer linesPos = Tracer.push((String)"Updated", null);){
                this.lines.forEach(line -> Tracer.log((String)"Line", (String)line));
            }
        }
    }

    public List<String> originalLines() {
        return this.originals;
    }

    public String getContent() {
        return String.join((CharSequence)"\n", this.preface) + String.join((CharSequence)"\n", this.lines) + String.join((CharSequence)"\n", this.postface);
    }

    public void setPreface(String ... preface) {
        for (String s : preface) {
            this.preface.add((this.tabStop > 0 ? String.format("%" + this.tabStop + "s", " ") : "") + s);
        }
    }

    public void setPostface(String ... postface) {
        for (String s : postface) {
            this.postface.add((this.tabStop > 0 ? String.format("%" + this.tabStop + "s", " ") : "") + s);
        }
    }

    public void setContent(String content) {
        this.lines.clear();
        this.lines.addAll(Arrays.asList(content.split("\n", -1)));
    }

    public void close() {
    }

    public Segment write(javax0.geci.api.Segment segment) {
        if (segment != null) {
            if (segment instanceof Segment) {
                Segment other = (Segment)segment;
                other.lines.forEach(line -> this.write((String)line, new Object[0]));
            } else {
                throw new GeciException("Segment " + segment + " is not instance of " + Segment.class.getName() + ". It is " + segment.getClass().getName() + "which is not compatible with this implementation", new Object[0]);
            }
        }
        return this;
    }

    public Segment write(String s, Object ... parameters) {
        if (s != null) {
            if (!s.contains("\n") && s.trim().length() == 0) {
                this.newline();
            } else {
                String formatted = !this.params.isEmpty() ? new Template(this.params).resolve(parameters.length == 0 ? s : String.format(s, parameters)) : (parameters.length == 0 ? s : String.format(s, parameters));
                if (formatted.contains("\n")) {
                    Arrays.stream(formatted.split("\r?\n", -1)).forEach(x$0 -> this.write((String)x$0, new Object[0]));
                } else {
                    this.lines.add((this.tabStop > 0 ? String.format("%" + this.tabStop + "s", " ") : "") + formatted);
                }
            }
        }
        return this;
    }

    public Segment newline() {
        this.lines.add("");
        return this;
    }

    public Segment write_r(String s, Object ... parameters) {
        this.write(s, parameters);
        this.tabStop += 4;
        return this;
    }

    public Segment write_l(String s, Object ... parameters) {
        this.tabStop -= 4;
        if (this.tabStop < this.openingTabStop) {
            this.tabStop = this.openingTabStop;
        }
        this.write(s, parameters);
        return this;
    }
}

