/*
 * Decompiled with CFR 0.152.
 */
package javax0.geci.engine;

import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import javax0.geci.api.SegmentSplitHelper;
import javax0.geci.tools.CompoundParams;
import javax0.geci.tools.CompoundParamsBuilder;

public class RegexBasedSegmentSplitHelper
implements SegmentSplitHelper {
    private final Pattern startPattern;
    private final Pattern endPattern;
    private final Pattern defaultPattern;
    private final List<String> excludedKeys;
    protected int defaultOffset = 0;
    private String[] segmentPreface = new String[]{""};
    private String[] segmentPostface = new String[]{""};

    protected void setSegmentPreface(String ... segmentPreface) {
        this.segmentPreface = segmentPreface;
    }

    protected void setSegmentPostface(String ... segmentPostface) {
        this.segmentPostface = segmentPostface;
    }

    public String[] getSegmentPreface() {
        return this.segmentPreface;
    }

    public String[] getSegmentPostface() {
        return this.segmentPostface;
    }

    public RegexBasedSegmentSplitHelper(Pattern startPattern, Pattern endPattern, Pattern defaultPattern) {
        this.startPattern = startPattern;
        this.endPattern = endPattern;
        this.defaultPattern = defaultPattern;
        this.excludedKeys = Collections.emptyList();
    }

    public RegexBasedSegmentSplitHelper(Pattern startPattern, Pattern endPattern, Pattern defaultPattern, List<String> excludedKeys) {
        this.startPattern = startPattern;
        this.endPattern = endPattern;
        this.defaultPattern = defaultPattern;
        this.excludedKeys = excludedKeys;
    }

    public SegmentSplitHelper.Matcher match(String line) {
        CompoundParams attrs;
        java.util.regex.Matcher startMatcher = this.startPattern.matcher(line);
        boolean segmentStart = startMatcher.matches();
        int tabs = 0;
        if (segmentStart) {
            String paramsDef = RegexBasedSegmentSplitHelper.getGroup(2, startMatcher);
            if (paramsDef == null) {
                throw new IllegalArgumentException("Start pattern in " + this.getClass() + "\n" + startMatcher + "\ndoes not give a second matching group. This is probably a coding error in that class.");
            }
            attrs = new CompoundParamsBuilder(paramsDef).exclude(this.excludedKeys.toArray(new String[0])).redefineId().build();
            String startSpaces = RegexBasedSegmentSplitHelper.getGroup(1, startMatcher);
            if (startSpaces == null) {
                throw new IllegalArgumentException("Start pattern in " + this.getClass() + "\n" + startMatcher + "\ndoes not give a first matching group. This is probably a coding error in that class.");
            }
            tabs = startSpaces.length();
        } else {
            attrs = null;
        }
        boolean segmentEnd = this.endPattern.matcher(line).matches();
        java.util.regex.Matcher defaultMatcher = this.defaultPattern.matcher(line);
        boolean segmentDefault = defaultMatcher.matches();
        if (segmentDefault) {
            tabs = defaultMatcher.group(1).length() + this.defaultOffset;
        }
        return new Matcher(segmentStart, segmentEnd, segmentDefault, (javax0.geci.api.CompoundParams)attrs, tabs);
    }

    private static String getGroup(int count, java.util.regex.Matcher matcher) {
        for (int i = 1; i <= matcher.groupCount(); ++i) {
            if (matcher.group(i) != null) {
                --count;
            }
            if (count != 0) continue;
            return matcher.group(i);
        }
        return null;
    }

    protected static class Matcher
    implements SegmentSplitHelper.Matcher {
        private final boolean segmentStart;
        private final boolean segmentEnd;
        private final boolean segmentDefault;
        private final javax0.geci.api.CompoundParams attrs;
        private final int tabs;

        protected Matcher(boolean segmentStart, boolean segmentEnd, boolean segmentDefault, javax0.geci.api.CompoundParams attrs, int tabs) {
            this.segmentStart = segmentStart;
            this.segmentEnd = segmentEnd;
            this.segmentDefault = segmentDefault;
            this.attrs = attrs;
            this.tabs = tabs;
        }

        public int headerLength() {
            return this.segmentDefault ? 0 : 1;
        }

        public boolean isSegmentStart() {
            return this.segmentStart;
        }

        public boolean isSegmentEnd() {
            return this.segmentEnd;
        }

        public boolean isDefaultSegmentEnd() {
            return this.segmentDefault;
        }

        public int tabbing() {
            return this.tabs;
        }

        public javax0.geci.api.CompoundParams attributes() {
            if (!this.segmentStart) {
                throw new IllegalArgumentException("attributes on " + SegmentSplitHelper.class.getSimpleName() + "." + SegmentSplitHelper.Matcher.class.getSimpleName() + " are not defined when the it is not a segment start.");
            }
            return this.attrs;
        }
    }
}

