/*
 * Decompiled with CFR 0.152.
 */
package javax0.geci.engine;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax0.geci.api.Distant;
import javax0.geci.api.GeciException;
import javax0.geci.api.Generator;
import javax0.geci.api.GlobalGenerator;
import javax0.geci.api.SegmentSplitHelper;
import javax0.geci.api.Source;
import javax0.geci.engine.Context;
import javax0.geci.engine.FileCollector;
import javax0.geci.engine.Source;
import javax0.geci.engine.SourceLogger;
import javax0.geci.javacomparator.Comparator;
import javax0.geci.log.Logger;
import javax0.geci.log.LoggerFactory;
import javax0.geci.tools.AbstractJavaGenerator;
import javax0.geci.tools.Tracer;
import javax0.geci.util.DirectoryLocator;

public class Geci
implements javax0.geci.api.Geci {
    public static final String FAILED = "Geci modified source code. Please compile and test again.";
    public static final int ALL = 0;
    public static final int MODIFIED = -2;
    public static final int TOUCHED = -3;
    public static final int UNTOUCHED = -5;
    public static final int NONE = 255;
    private static final Logger LOG = LoggerFactory.getLogger();
    private final Map<Source.Set, javax0.geci.api.DirectoryLocator> directories = new HashMap<Source.Set, javax0.geci.api.DirectoryLocator>();
    private final Set<Generator> generators = new HashSet<Generator>();
    private final Set<javax0.geci.api.Source> modifiedSources = new HashSet<javax0.geci.api.Source>();
    private final Map<String, SegmentSplitHelper> splitHelpers = new HashMap<String, SegmentSplitHelper>();
    private final Set<Predicate<Path>> onlys = new HashSet<Predicate<Path>>();
    private final Set<Predicate<Path>> ignores = new HashSet<Predicate<Path>>();
    private int whatToLog = -4;
    private BiPredicate<List<String>, List<String>> sourceComparator = null;
    public static final BiPredicate<List<String>, List<String>> EQUALS_COMPARATOR = (orig, gen) -> !orig.equals(gen);
    public static final BiPredicate<List<String>, List<String>> JAVA_COMPARATOR = new Comparator();
    public static final BiPredicate<List<String>, List<String>> JAVA_COMPARATOR_COMMENT = new Comparator().commentSensitive();
    private final Set<Source.Set> outputSet = new HashSet<Source.Set>();
    private Source.Set lastSet = null;
    private boolean ignoreBinary = false;
    private String traceFileName = null;
    private String diffDirectory = null;
    private boolean lenient = false;
    private javax0.geci.api.Context context = null;

    public Geci source(String ... directory) {
        return this.source(Source.Predicates.exists(), directory);
    }

    public Geci source(Predicate<String> predicate, String ... directory) {
        this.source(Source.Set.set(), new DirectoryLocator(predicate, directory));
        this.lastSet = null;
        return this;
    }

    public Geci source(javax0.geci.api.DirectoryLocator locator) {
        this.source(Source.Set.set(), locator);
        this.lastSet = null;
        return this;
    }

    public Geci source(Source.Set set, javax0.geci.api.DirectoryLocator locator) {
        this.lastSet = set;
        this.directories.put(set, locator);
        return this;
    }

    public Geci log(int whatToLog) {
        this.whatToLog = whatToLog;
        return this;
    }

    public String failed() {
        StringBuilder sb = new StringBuilder();
        sb.append('\n');
        sb.append(FAILED).append('\n');
        sb.append('\n');
        sb.append(String.format("The file%s that %s modified:", this.modifiedSources.size() > 1 ? "s" : "", this.modifiedSources.size() > 1 ? "were" : "was")).append('\n');
        for (javax0.geci.api.Source source : this.modifiedSources) {
            sb.append(source.getAbsoluteFile()).append('\n');
        }
        sb.append('\n');
        return sb.toString();
    }

    public Geci source(Source.Set set, String ... directory) {
        return this.source(set, Source.Predicates.exists(), directory);
    }

    public Geci source(Source.Set set, Predicate<String> predicate, String ... directory) {
        this.lastSet = set;
        if (this.directories.containsKey(set)) {
            set.tryRename();
            if (this.directories.containsKey(set)) {
                throw new GeciException("The set '" + set + "' is defined more than once.", new Object[0]);
            }
        }
        this.directories.put(set, new DirectoryLocator(predicate, directory));
        return this;
    }

    public Geci splitHelper(String fileNameExtension, SegmentSplitHelper helper) {
        if (fileNameExtension.startsWith(".")) {
            fileNameExtension = fileNameExtension.substring(1);
        }
        if (this.splitHelpers.containsKey(fileNameExtension)) {
            throw new GeciException(fileNameExtension + " already has an associated SegmentSplitHelper.", new Object[0]);
        }
        this.splitHelpers.put(fileNameExtension, helper);
        return this;
    }

    public Geci source(Source.Maven maven) {
        this.source(maven.mainSource());
        this.source(maven.mainResources());
        this.source(maven.testSource());
        this.source(maven.testResources());
        this.lenient = true;
        this.lastSet = null;
        return this;
    }

    public Geci register(Generator ... generatorArr) {
        Collections.addAll(this.generators, generatorArr);
        return this;
    }

    public Geci only(String ... patterns) {
        Collections.addAll(this.onlys, (Predicate[])Arrays.stream(patterns).map(x$0 -> new PatternPredicate((String)x$0)).toArray(Predicate[]::new));
        return this;
    }

    public Geci output(Source.Set ... sets) {
        this.outputSet.addAll(Arrays.asList(sets));
        return this;
    }

    public Geci output() {
        if (this.lastSet == null) {
            throw new GeciException("Source set not defined but declared as output calling Geci.source()", new Object[0]);
        }
        this.outputSet.add(this.lastSet);
        return this;
    }

    public Geci ignoreBinary() {
        this.ignoreBinary = true;
        return this;
    }

    public Geci ignore(String ... patterns) {
        Collections.addAll(this.ignores, (Predicate[])Arrays.stream(patterns).map(x$0 -> new PatternPredicate((String)x$0)).toArray(Predicate[]::new));
        return this;
    }

    @SafeVarargs
    public final javax0.geci.api.Geci only(Predicate<Path> ... onlys) {
        Collections.addAll(this.onlys, onlys);
        return this;
    }

    @SafeVarargs
    public final javax0.geci.api.Geci ignore(Predicate<Path> ... ignores) {
        Collections.addAll(this.ignores, ignores);
        return this;
    }

    private BiPredicate<List<String>, List<String>> getSourceComparator(javax0.geci.api.Source source) {
        if (this.sourceComparator == null) {
            if (source.getAbsoluteFile().endsWith(".java")) {
                if (Geci.isCommentTouched(source)) {
                    return JAVA_COMPARATOR_COMMENT;
                }
                return JAVA_COMPARATOR;
            }
            return EQUALS_COMPARATOR;
        }
        return this.sourceComparator;
    }

    private static boolean isCommentTouched(javax0.geci.api.Source source) {
        if (source instanceof Source) {
            Source src = (Source)source;
            return (src.getTouchBits() & 1L) > 0L;
        }
        return false;
    }

    public Geci comparator(BiPredicate<List<String>, List<String>> sourceComparator) {
        this.sourceComparator = sourceComparator;
        return this;
    }

    private void setDefaultDirectories() {
        this.source(javax0.geci.api.Source.maven());
    }

    private void traceDirectories() {
        Tracer.push((String)"SourceSets to be collected");
        for (Map.Entry<Source.Set, javax0.geci.api.DirectoryLocator> directory : this.directories.entrySet()) {
            Source.Set set = directory.getKey();
            javax0.geci.api.DirectoryLocator locator = directory.getValue();
            Tracer.log((String)(set.toString() + " set with alternative directory locations [" + locator.alternatives().collect(Collectors.joining(",")) + "]"));
        }
        Tracer.pop();
    }

    public Geci trace(String fileName) {
        Tracer.on();
        this.traceFileName = fileName;
        return this;
    }

    public javax0.geci.api.Geci diffOutput(String directoryName) {
        this.diffDirectory = directoryName;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean generate() throws IOException {
        try {
            FileCollector collector;
            ArrayList<Source.SourceIsBinary> exceptions = new ArrayList<Source.SourceIsBinary>();
            this.injectContextIntoGenerators();
            int phases = this.getPhases();
            Tracer.log((String)("There will be " + phases + " phases."));
            if (this.directories.isEmpty()) {
                Tracer.log((String)"There are no configured directories, using the default");
                this.setDefaultDirectories();
                collector = new FileCollector(this.directories);
                collector.lenient();
            } else {
                this.traceDirectories();
                collector = new FileCollector(this.directories);
                if (this.lenient) {
                    collector.lenient();
                }
            }
            Tracer.push((String)"Registering split helpers");
            collector.registerSplitHelpers(this.splitHelpers);
            Tracer.pop();
            Tracer.push((String)"SourceCollect", (String)"Collecting sources");
            collector.collect(this.onlys, this.ignores, this.outputSet);
            Tracer.pop();
            this.invokeGeneratorsOnAllSourcesForAllPhases(exceptions, phases, collector);
            this.invokeGlobalGenerators();
            this.logAndThrowDeferredExceptionsIfAny(exceptions);
            this.consolidateSources(collector);
            boolean bl = this.sourcesModifiedAndSave(collector);
            return bl;
        }
        finally {
            this.dumpCollectedTracesAsXML();
        }
    }

    private int getPhases() {
        return this.generators.stream().mapToInt(Generator::phases).max().orElse(1);
    }

    private void dumpCollectedTracesAsXML() {
        if (this.traceFileName != null) {
            try {
                Tracer.dumpXML((String)this.traceFileName);
            }
            catch (IOException e) {
                LoggerFactory.getLogger().error("Trace cannot be written into '" + this.traceFileName + "'", new Object[]{e});
            }
        }
    }

    private void consolidateSources(FileCollector collector) {
        if (!this.sourcesConsolidate(collector) && this.generators.stream().anyMatch(g -> !(g instanceof Distant))) {
            throw new GeciException("The generators did not touch any source", new Object[0]);
        }
    }

    private void logAndThrowDeferredExceptionsIfAny(List<Source.SourceIsBinary> exceptions) {
        if (exceptions.size() > 0 && !this.ignoreBinary) {
            try (Tracer pos = Tracer.push((String)"Exceptions");){
                exceptions.forEach(Tracer::log);
            }
            GeciException geciE = new GeciException("Cannot read the files\n" + exceptions.stream().map(Source.SourceIsBinary::getAbsoluteFile).collect(Collectors.joining("\n")) + "\nThey are probably binary file. Use '.ignore()' to filter binary files out", new Object[0]);
            exceptions.forEach(arg_0 -> geciE.addSuppressed(arg_0));
            throw geciE;
        }
    }

    private void invokeGlobalGenerators() {
        try (Tracer pos1 = Tracer.push((String)"GlobalGenerators", null);){
            for (Generator generator : this.generators) {
                if (!(generator instanceof GlobalGenerator)) continue;
                Tracer pos2 = Tracer.push((String)("GlobalGenerator." + generator.getClass().getSimpleName()), (String)generator.getClass().getName());
                try {
                    ((GlobalGenerator)generator).process();
                }
                finally {
                    if (pos2 == null) continue;
                    pos2.close();
                }
            }
        }
    }

    private void invokeGeneratorsOnAllSourcesForAllPhases(ArrayList<Source.SourceIsBinary> exceptions, int phases, FileCollector collector) {
        for (int phase = 0; phase < phases; ++phase) {
            try (Tracer posPhase = Tracer.push((String)"Phase", (String)("Starting phase " + phase));){
                this.invokeGeneratorsOnAllSources(collector, exceptions, phase);
                continue;
            }
        }
    }

    private void invokeGeneratorsOnAllSources(FileCollector collector, List<Source.SourceIsBinary> exceptions, int phase) {
        for (Source source : collector.getSources()) {
            Tracer posSource = Tracer.push((String)"Source", (String)source.getAbsoluteFile());
            try {
                this.invokeGeneratorsOnNonBinary(source, exceptions, phase);
            }
            finally {
                if (posSource == null) continue;
                posSource.close();
            }
        }
    }

    private void invokeGeneratorsOnNonBinary(Source source, List<Source.SourceIsBinary> exceptions, int phase) {
        if (!source.isBinary) {
            try (Tracer posGenerators = Tracer.push((String)"Generators", null);){
                this.invokeGenerators(source, exceptions, phase);
            }
        } else {
            Tracer.log((String)(source.getAbsoluteFile() + " seems to be binary, skipped"));
        }
    }

    private void invokeGenerators(Source source, List<Source.SourceIsBinary> exceptions, int phase) {
        for (Generator generator : this.generators) {
            Tracer posGenerator = Tracer.push((String)("Generator." + generator.getClass().getSimpleName()), (String)generator.getClass().getName());
            try {
                this.invokeGeneratorIfActiveInPhase(generator, source, exceptions, phase);
            }
            finally {
                if (posGenerator == null) continue;
                posGenerator.close();
            }
        }
    }

    private void invokeGeneratorIfActiveInPhase(Generator generator, Source source, List<Source.SourceIsBinary> exceptions, int phase) {
        if (generator.activeIn(phase)) {
            Tracer.log((String)"ACTIVE");
            source.allowDefaultSegment = false;
            source.currentGenerator = generator;
            this.invokeGenerator(generator, source, exceptions);
        } else {
            Tracer.log((String)"INACTIVE");
        }
    }

    private void invokeGenerator(Generator generator, Source source, List<Source.SourceIsBinary> exceptions) {
        try {
            generator.process((javax0.geci.api.Source)source);
        }
        catch (Source.SourceIsBinary e) {
            Tracer.log((String)"source processing failed, it is a binary file");
            exceptions.add(e);
        }
        catch (GeciException e) {
            throw new SourcedGeciException(source, e);
        }
    }

    private boolean sourcesModifiedAndSave(FileCollector collector) throws IOException {
        try (Tracer pos = Tracer.push((String)"Save", null);){
            boolean generated = false;
            Set allSources = Stream.concat(collector.getSources().stream(), collector.getNewSources().stream()).collect(Collectors.toSet());
            for (Source source : allSources) {
                try {
                    BiPredicate<List<String>, List<String>> comparator = this.getSourceComparator(source);
                    boolean modified = source.isModified(comparator);
                    if (source.isTouched() && modified) {
                        Tracer.log((String)"SaveSource", (String)source.getAbsoluteFile());
                        source.save();
                        this.modifiedSources.add(source);
                        generated = true;
                    } else {
                        Tracer.log((String)"SourceUnchanged", (String)source.getAbsoluteFile());
                    }
                    if (this.diffDirectory == null || (comparator != EQUALS_COMPARATOR || !modified) && !source.isModified(EQUALS_COMPARATOR)) continue;
                    this.createDiffFiles(source);
                }
                catch (GeciException e) {
                    throw new SourcedGeciException(source, e);
                }
            }
            for (Source source : Stream.concat(collector.getSources().stream(), collector.getNewSources().stream()).collect(Collectors.toSet())) {
                if (this.modifiedSources.contains(source)) {
                    if ((this.whatToLog & 1) != 0) continue;
                    LOG.info("MODIFIED  '%s'", new Object[]{source.getAbsoluteFile()});
                    this.logSourceMessages(source);
                    continue;
                }
                if (source.isTouched()) {
                    if ((this.whatToLog & 2) != 0) continue;
                    LOG.info("TOUCHED   '%s'", new Object[]{source.getAbsoluteFile()});
                    this.logSourceMessages(source);
                    continue;
                }
                if ((this.whatToLog & 4) != 0) continue;
                LOG.info("UNTOUCHED '%s'", new Object[]{source.getAbsoluteFile()});
                this.logSourceMessages(source);
            }
            boolean bl = generated;
            return bl;
        }
    }

    private void createDiffFiles(Source source) throws IOException {
        Path pathOriginal = Paths.get(this.diffDirectory + "/geci/original", source.relativeFile);
        this.assertDirectoryExistsForPath(pathOriginal);
        Path pathNew = Paths.get(this.diffDirectory + "/geci/generated", source.relativeFile);
        this.assertDirectoryExistsForPath(pathNew);
        Files.write(pathOriginal, source.originals, StandardCharsets.UTF_8, new OpenOption[0]);
        Files.write(pathNew, source.getLines(), StandardCharsets.UTF_8, new OpenOption[0]);
    }

    private void assertDirectoryExistsForPath(Path path) {
        Path parent = path.getParent();
        if (!Files.exists(parent, new LinkOption[0])) {
            try {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void logSourceMessages(Source source) {
        for (SourceLogger.LogEntry entry : source.logEntries) {
            String generatorId = entry.generator instanceof AbstractJavaGenerator ? ((AbstractJavaGenerator)entry.generator).mnemonic() : entry.generator.getClass().getSimpleName();
            switch (entry.level) {
                case 1: {
                    LOG.trace(generatorId + ":" + entry.message, new Object[0]);
                    break;
                }
                case 2: {
                    LOG.debug(generatorId + ":" + entry.message, new Object[0]);
                    break;
                }
                case 3: {
                    LOG.info(generatorId + ":" + entry.message, new Object[0]);
                    break;
                }
                case 4: {
                    LOG.warning(generatorId + ":" + entry.message, new Object[0]);
                    break;
                }
                case 5: {
                    LOG.error(generatorId + ":" + entry.message, new Object[0]);
                }
            }
        }
    }

    private boolean sourcesConsolidate(FileCollector collector) {
        try (Tracer pos1 = Tracer.push((String)"SourceConsolidation", null);){
            boolean touched = false;
            try (Tracer pos2 = Tracer.push((String)"OldSources", null);){
                for (Source source : collector.getSources()) {
                    source.consolidate();
                    touched = touched || source.isTouched();
                    Tracer.log((String)"Source", (String)((source.isTouched() ? "[TOUCHED]" : "") + source.getAbsoluteFile()));
                }
            }
            pos2 = Tracer.push((String)"NewSources", null);
            try {
                for (Source source : collector.getNewSources()) {
                    source.consolidate();
                    touched = touched || source.isTouched();
                    Tracer.log((String)"Source", (String)((source.isTouched() ? "[TOUCHED]" : "") + source.getAbsoluteFile()));
                }
            }
            finally {
                if (pos2 != null) {
                    pos2.close();
                }
            }
            Tracer.log((String)"Result", (String)("some sources are " + (touched ? "touched" : "virgin")));
            boolean bl = touched;
            return bl;
        }
    }

    public javax0.geci.api.Context context() {
        return this.context;
    }

    public Geci context(javax0.geci.api.Context context) {
        Tracer.log((String)"Setting context for Geci engine");
        this.context = context;
        return this;
    }

    private void injectContextIntoGenerators() {
        if (this.context == null) {
            this.context = Context.singletonInstance;
        }
        this.generators.forEach(g -> g.context(this.context));
    }

    private static final class SourcedGeciException
    extends GeciException {
        public synchronized Throwable fillInStackTrace() {
            return this;
        }

        private SourcedGeciException(javax0.geci.api.Source source, GeciException e) {
            super(e.getMessage() + (String)(source == null ? "" : "\nSource: " + source.getAbsoluteFile()), e.getCause());
            this.setStackTrace(e.getStackTrace());
        }
    }

    private static class PatternPredicate
    implements Predicate<Path> {
        private final Predicate<Path> predicate;
        private final String regex;
        private final Pattern pattern;

        private PatternPredicate(String regex) {
            this.pattern = Pattern.compile(regex);
            this.predicate = s -> this.pattern.matcher(FileCollector.toAbsolute(s)).find();
            this.regex = regex;
        }

        @Override
        public boolean test(Path path) {
            return this.predicate.test(path);
        }

        public String toString() {
            return this.regex;
        }
    }
}

