/*
 * Decompiled with CFR 0.152.
 */
package javax0.geci.engine;

import java.nio.file.Path;
import java.nio.file.Paths;
import javax0.geci.api.GeciException;
import javax0.geci.api.Source;
import javax0.geci.engine.FileCollector;
import javax0.geci.engine.Source;
import javax0.geci.engine.SourceStore;

class FileSystemSourceStore
implements SourceStore {
    private final FileCollector collector;
    private final String relativeFile;
    private final String dir;

    FileSystemSourceStore(FileCollector collector, String relativeFile, String dir) {
        this.collector = collector;
        this.relativeFile = relativeFile;
        this.dir = dir;
    }

    private Path inDir(String dir, String fileName) {
        Path parent = Paths.get(this.relativeFile, new String[0]).getParent();
        return Paths.get(FileCollector.normalize(dir + (parent == null ? fileName : parent.resolve(fileName).toString())), new String[0]);
    }

    private javax0.geci.api.Source getExistingOrNew(String dir, String fileName) {
        Path path = this.inDir(dir, fileName);
        String absoluteFile = FileCollector.toAbsolute(path);
        for (Source source : this.collector.getNewSources()) {
            if (!absoluteFile.equals(source.absoluteFile)) continue;
            return source;
        }
        Source source = new Source(this.collector, dir, path);
        this.collector.addNewSource(source);
        return source;
    }

    @Override
    public javax0.geci.api.Source get(String fileName) {
        return this.getExistingOrNew(this.dir, fileName);
    }

    @Override
    public javax0.geci.api.Source get(Source.Set set, String fileName) {
        String dir = this.collector.getDirectory(set);
        if (dir == null) {
            throw new GeciException("SourceSet '" + set + "' does not exist", new Object[0]);
        }
        return this.getExistingOrNew(dir, fileName);
    }
}

