/*
 * Decompiled with CFR 0.152.
 */
package javax0.geci.engine;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax0.geci.api.DirectoryLocator;
import javax0.geci.api.GeciException;
import javax0.geci.api.Logger;
import javax0.geci.api.SegmentSplitHelper;
import javax0.geci.api.Source;
import javax0.geci.engine.Source;
import javax0.geci.tools.Tracer;
import javax0.geci.util.DirectoryLocated;
import javax0.geci.util.JavaSegmentSplitHelper;
import javax0.geci.util.NullSegmentSplitHelper;

class FileCollector {
    private static final Logger log = new javax0.geci.log.Logger(FileCollector.class);
    private static final SegmentSplitHelper nullSegmentSplitHelper = new NullSegmentSplitHelper();
    private static final SegmentSplitHelper javaSegmentSplitHelper = new JavaSegmentSplitHelper();
    private static final int MAX_DEPTH_UNLIMITED = Integer.MAX_VALUE;
    private final Map<Source.Set, DirectoryLocator> directories;
    private final Map<Source.Set, DirectoryLocated> located = new HashMap<Source.Set, DirectoryLocated>();
    private final Set<Source> newSources = new HashSet<Source>();
    private final Set<Source> sources = new HashSet<Source>();
    private final Map<String, SegmentSplitHelper> splitHelpers = new HashMap<String, SegmentSplitHelper>();
    private boolean lenient = false;

    public FileCollector(Map<Source.Set, DirectoryLocator> directories) {
        this.directories = new HashMap<Source.Set, DirectoryLocator>(directories);
    }

    public static String normalize(String s) {
        return Paths.get(s, new String[0]).normalize().toString().replace("\\", "/");
    }

    public static String normalized(String s) {
        if (!((String)(s = FileCollector.normalize((String)s))).endsWith("/")) {
            s = (String)s + "/";
        }
        return s;
    }

    public static String calculateClassName(String directory, Path path) {
        return FileCollector.calculateRelativeName(directory, path).replaceAll("/", ".").replaceAll("\\.\\w+$", "");
    }

    public static String calculateRelativeName(String directory, Path path) {
        return FileCollector.normalize(path.toString()).substring(directory.length());
    }

    public static String toAbsolute(Path path) {
        return FileCollector.normalize(path.toAbsolutePath().toString());
    }

    private static String getCwd() {
        try {
            return new File(".").getCanonicalPath();
        }
        catch (IOException ignored) {
            return null;
        }
    }

    public void registerSplitHelpers(Map<String, SegmentSplitHelper> splitHelpers) {
        splitHelpers.forEach((key, value) -> Tracer.log((String)("Helper " + key + " = " + value.getClass().getName())));
        this.splitHelpers.putAll(splitHelpers);
    }

    public String getDirectory(Source.Set sourceSet) {
        return this.located.get(sourceSet).getDirectory();
    }

    public Set<Source> getNewSources() {
        return this.newSources;
    }

    public Set<Source> getSources() {
        return this.sources;
    }

    public void lenient() {
        this.lenient = true;
    }

    public SegmentSplitHelper getSegmentSplitHelper(Source source) {
        String absFn = source.getAbsoluteFile();
        int extStartPos = absFn.lastIndexOf(46);
        if (extStartPos == -1) {
            return nullSegmentSplitHelper;
        }
        String ext = absFn.substring(extStartPos + 1);
        if (this.splitHelpers.containsKey(ext)) {
            return this.splitHelpers.get(ext);
        }
        if ("java".equals(ext)) {
            return javaSegmentSplitHelper;
        }
        return nullSegmentSplitHelper;
    }

    public void collect(Set<Predicate<Path>> onlySet, Set<Predicate<Path>> ignoreSet, Set<Source.Set> outputSets) {
        Tracer.log((String)("Current Working Directory is '" + FileCollector.getCwd() + "'"));
        boolean processedSomeOfTheEntries = false;
        for (Map.Entry<Source.Set, DirectoryLocator> entry2 : this.directories.entrySet()) {
            processedSomeOfTheEntries |= this.collectEntry(entry2, onlySet, ignoreSet, outputSets);
        }
        if (!processedSomeOfTheEntries) {
            throw new GeciException("None of the configured directories {" + this.directories.entrySet().stream().map(entry -> "\"" + entry.getKey() + " : [" + ((DirectoryLocator)entry.getValue()).alternatives().collect(Collectors.joining(",")) + "]").collect(Collectors.joining(",\n")) + "} are found.", new Object[0]);
        }
    }

    private boolean collectEntry(Map.Entry<Source.Set, DirectoryLocator> entry, Set<Predicate<Path>> onlySet, Set<Predicate<Path>> ignoreSet, Set<Source.Set> outputSets) {
        Tracer.push((String)"Entry", (String)("File collecting started for entry [" + entry.getValue().alternatives().collect(Collectors.joining(",")) + "]"));
        AtomicBoolean processedSome = new AtomicBoolean(false);
        AtomicBoolean processed = new AtomicBoolean(false);
        DirectoryLocator locator = entry.getValue();
        locator.alternatives().filter(x -> !processed.get()).forEach(directory -> this.collectDirectoryTraced((String)directory, entry, onlySet, ignoreSet, outputSets, processedSome, processed, locator));
        Tracer.pop();
        if (!processed.get() && !this.lenient) {
            throw new GeciException("Source directory [" + locator.alternatives().collect(Collectors.joining(",")) + "] is not found", new Object[0]);
        }
        return processedSome.get();
    }

    private void collectDirectoryTraced(String directory, Map.Entry<Source.Set, DirectoryLocator> entry, Set<Predicate<Path>> onlySet, Set<Predicate<Path>> ignoreSet, Set<Source.Set> outputSets, AtomicBoolean processedSome, AtomicBoolean processed, DirectoryLocator locator) {
        try (Tracer __ = Tracer.push((String)"Alternative", (String)("File collecting started for alternative '" + directory + "'"));){
            this.collectDirectory(directory, entry, onlySet, ignoreSet, outputSets, processedSome, processed, locator);
        }
        catch (IOException ioException) {
            throw new GeciException("The directory '" + FileCollector.normalized(directory) + "' was selected but no files can be collected from it.", (Throwable)ioException);
        }
    }

    private void collectDirectory(String directory, Map.Entry<Source.Set, DirectoryLocator> entry, Set<Predicate<Path>> onlySet, Set<Predicate<Path>> ignoreSet, Set<Source.Set> outputSets, AtomicBoolean processedSome, AtomicBoolean processed, DirectoryLocator locator) throws IOException {
        String dir = FileCollector.normalized(directory);
        if (locator.test(dir)) {
            this.collectTestedDirectory(directory, entry, onlySet, ignoreSet, outputSets, processedSome, processed, dir);
        } else {
            Tracer.log((String)("'" + directory + "' is not the right alternative"));
        }
    }

    private void collectTestedDirectory(String directory, Map.Entry<Source.Set, DirectoryLocator> entry, Set<Predicate<Path>> onlySet, Set<Predicate<Path>> ignoreSet, Set<Source.Set> outputSets, AtomicBoolean processedSome, AtomicBoolean processed, String dir) throws IOException {
        Tracer.log((String)("'" + directory + "' seems to be the right alternative"));
        if (outputSets.contains(entry.getKey())) {
            Tracer.log((String)("'" + directory + "' is an output location, files are not collected"));
        } else {
            Tracer.log((String)("'" + directory + "' is input, collecting files..."));
            this.collectInputDirectory(onlySet, ignoreSet, dir);
            this.located.put(entry.getKey(), new DirectoryLocated(dir));
            processed.set(true);
            processedSome.set(true);
        }
    }

    private void collectInputDirectory(Set<Predicate<Path>> onlySet, Set<Predicate<Path>> ignoreSet, String dir) throws IOException {
        this.getAllRegularFiles(dir).peek(s -> Tracer.push((String)"File", (String)("'" + s + "' was found"))).peek(s -> Tracer.push((String)"Only", (String)"Checking predicates")).filter(path -> this.pathIsMatchingOnlySet(onlySet, (Path)path)).peek(s -> Tracer.pop()).peek(s -> Tracer.push((String)"Ignore", (String)"Checking predicates")).filter(path -> this.pathIsNotIgnored(ignoreSet, (Path)path)).peek(s -> Tracer.pop()).peek(s -> Tracer.pop()).forEach(path -> this.sources.add(new Source(this, dir, (Path)path)));
    }

    private Stream<Path> getAllRegularFiles(String dir) throws IOException {
        return Files.find(Paths.get(dir, new String[0]), Integer.MAX_VALUE, (filePath, fileAttr) -> fileAttr.isRegularFile(), new FileVisitOption[0]);
    }

    private boolean pathIsNotIgnored(Set<Predicate<Path>> ignoreSet, Path path) {
        if (ignoreSet == null || ignoreSet.isEmpty()) {
            Tracer.log((String)"There are no 'ignore' predicates");
            return true;
        }
        if (ignoreSet.stream().peek(p -> Tracer.log((String)("Checking 'ignore' predicate " + p))).noneMatch(predicate -> predicate.test(path))) {
            Tracer.log((String)"None of the  predicates matched");
            return true;
        }
        Tracer.append((String)", predicate matched, file is skipped");
        Tracer.pop();
        Tracer.pop();
        return false;
    }

    private boolean pathIsMatchingOnlySet(Set<Predicate<Path>> onlySet, Path path) {
        if (onlySet == null || onlySet.isEmpty()) {
            Tracer.log((String)"There are no 'only' predicates");
            return true;
        }
        if (onlySet.stream().peek(p -> Tracer.log((String)("Checking 'only' predicate " + p))).anyMatch(predicate -> predicate.test(path))) {
            Tracer.append((String)", predicate matched");
            return true;
        }
        Tracer.log((String)"No 'only' predicate match, file is skipped.");
        Tracer.pop();
        Tracer.pop();
        return false;
    }

    public void addNewSource(Source source) {
        this.newSources.add(source);
    }
}

