/*
 * Decompiled with CFR 0.152.
 */
package javax0.geci.templated;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax0.geci.annotations.Geci;
import javax0.geci.annotations.Generated;
import javax0.geci.api.GeneratorBuilder;
import javax0.geci.api.Segment;
import javax0.geci.api.Source;
import javax0.geci.core.annotations.AnnotationBuilder;
import javax0.geci.templated.Context;
import javax0.geci.templated.Triplet;
import javax0.geci.tools.AbstractJavaGenerator;
import javax0.geci.tools.CompoundParams;
import javax0.geci.tools.GeciReflectionTools;
import javax0.geci.tools.TemplateLoader;
import javax0.geci.tools.reflection.Selector;

@AnnotationBuilder
@Geci(value={"repeated values='preprocess,processField,processMethod,processClass,processMemberClass,processMethods,processClasses,processFields,postprocess,preprocessClass,postprocessClass'"})
public class Templated
extends AbstractJavaGenerator {
    private static final Consumer NOOP = a -> {};
    private static final BiConsumer BiNOOP = (s, a) -> {};
    private static final BiFunction<Context, String, String> BiFuNOOP = (ctx, s) -> s;
    private static final Templates EMPTY = new Templates();
    private final Config config = new Config();
    private static final Set<String> implementedKeys = new HashSet<String>(Arrays.asList("classFilter", "fieldFilter", "memberClassFilter", "methodFilter", "postprocess", "postprocessClass", "preprocess", "preprocessClass", "processClass", "processClasses", "processField", "processFields", "processMemberClass", "processMethod", "processMethods", "selector", "id"));

    public boolean activeIn(int phase) {
        this.phase = phase;
        return phase < 2;
    }

    public int phases() {
        return 2;
    }

    public final void process(Source source, Class<?> klass, CompoundParams global) throws Exception {
        try (Segment segment = source.open(global.id());){
            if (this.phase == 0) {
                this.preprocess(source, klass, global, segment);
                ArrayList<Field> selectedFields = new ArrayList<Field>();
                Field[] fields = this.config.declaredOnly ? GeciReflectionTools.getDeclaredFieldsSorted(klass) : GeciReflectionTools.getAllFieldsSorted(klass);
                this.processFieldsLooping(source, klass, global, segment, fields, selectedFields);
                ArrayList<Method> selectedMethods = new ArrayList<Method>();
                Method[] methods = this.config.declaredOnly ? GeciReflectionTools.getDeclaredMethodsSorted(klass) : GeciReflectionTools.getAllMethodsSorted(klass);
                this.processMethodsLooping(source, klass, global, segment, methods, selectedMethods);
                ArrayList<Class> selectedClasses = new ArrayList<Class>();
                Class[] classes = this.config.declaredOnly ? GeciReflectionTools.getDeclaredClassesSorted(klass) : GeciReflectionTools.getAllClassesSorted(klass);
                this.processMemberClassesLooping(source, klass, global, segment, classes, selectedClasses);
                this.processFields(source, klass, global, selectedFields, segment);
                this.processMethods(source, klass, global, selectedMethods, segment);
                this.processClasses(source, klass, global, selectedClasses, segment);
            } else {
                Config local = this.localConfig(global);
                Selector selector = Selector.compile((String)local.classFilter);
                ArrayList selectedClasses = this.classes.stream().filter(arg_0 -> ((Selector)selector).match(arg_0)).sorted(Comparator.comparing(Class::getName)).collect(Collectors.toCollection(ArrayList::new));
                this.preprocessClass(source, klass, selectedClasses, global, segment);
                for (Class listedKlass : selectedClasses) {
                    this.processClass(source, klass, listedKlass, global, segment);
                }
                this.postprocessClass(source, klass, selectedClasses, global, segment);
                this.postprocess(source, klass, global, segment);
            }
        }
    }

    private void processMethodsLooping(Source source, Class<?> klass, CompoundParams global, Segment segment, Method[] methods, List<Method> selectedMethods) throws Exception {
        for (Method method : methods) {
            CompoundParams params = new CompoundParams(new CompoundParams[]{GeciReflectionTools.getParameters((AnnotatedElement)method, (String)this.mnemonic()), global});
            Config local = this.localConfig(params);
            if (!Selector.compile((String)local.methodFilter).match((Object)method)) continue;
            selectedMethods.add(method);
            this.process(source, klass, params, method, segment);
        }
    }

    private void processFieldsLooping(Source source, Class<?> klass, CompoundParams global, Segment segment, Field[] fields, List<Field> selectedFields) {
        for (Field field : fields) {
            CompoundParams params = new CompoundParams(new CompoundParams[]{GeciReflectionTools.getParameters((AnnotatedElement)field, (String)this.mnemonic()), global});
            Config local = this.localConfig(params);
            if (!Selector.compile((String)local.fieldFilter).match((Object)field)) continue;
            selectedFields.add(field);
            this.process(source, klass, params, field, segment);
        }
    }

    private void processMemberClassesLooping(Source source, Class<?> klass, CompoundParams global, Segment segment, Class[] classes, List<Class> selectedClasses) {
        for (Class memberClass : classes) {
            CompoundParams params = new CompoundParams(new CompoundParams[]{GeciReflectionTools.getParameters((AnnotatedElement)memberClass, (String)this.mnemonic()), global});
            Config local = this.localConfig(params);
            if (!Selector.compile((String)local.memberClassFilter).match((Object)memberClass)) continue;
            selectedClasses.add(memberClass);
            this.process(source, klass, params, memberClass, segment);
        }
    }

    private void preprocessClass(Source source, Class<?> klass, List<Class<?>> selectedClasses, CompoundParams global, Segment segment) {
        Config local = this.localConfig(global);
        this.setTripletInContext(source, klass, segment);
        this.config.preprocessClassParams.accept(this.config.ctx);
        segment.write(this.config.preprocessClassResolv.apply(this.config.ctx, this.getTemplateContent(local.preprocessClass, this.templates((Config)local).preprocessClass)), new Object[0]);
    }

    public void processClass(Source source, Class<?> klass, Class<?> listedClass, CompoundParams global, Segment segment) {
        Config local = this.localConfig(global);
        Templated.setParams(segment, "class.", "SimpleName", listedClass.getSimpleName(), "Name", listedClass.getName(), "CanonicalName", listedClass.getCanonicalName(), "Package", listedClass.getPackageName(), "TypeName", listedClass.getTypeName(), "GenericString", listedClass.toGenericString());
        this.setTripletInContext(source, klass, segment);
        this.config.processClassParams.accept(this.config.ctx, listedClass);
        segment.write(this.config.processClassesResolv.apply(this.config.ctx, this.getTemplateContent(local.processClass, this.templates((Config)local).processClass)), new Object[0]);
    }

    private void postprocessClass(Source source, Class<?> klass, List<Class<?>> classes, CompoundParams global, Segment segment) {
        Config local = this.localConfig(global);
        segment.param(new String[]{"classes.n", "" + classes.size()});
        int i = 0;
        for (Class<?> selectedClass : classes) {
            Templated.setParams(segment, "class." + i + ".", "SimpleName", selectedClass.getSimpleName(), "Name", selectedClass.getName(), "CanonicalName", selectedClass.getCanonicalName(), "Package", selectedClass.getPackageName(), "TypeName", selectedClass.getTypeName(), "GenericString", selectedClass.toGenericString());
            ++i;
            Templated.setParams(segment, "class." + selectedClass.getName() + ".", "SimpleName", selectedClass.getSimpleName(), "Name", selectedClass.getName(), "CanonicalName", selectedClass.getCanonicalName(), "Package", selectedClass.getPackageName(), "TypeName", selectedClass.getTypeName(), "GenericString", selectedClass.toGenericString());
        }
        this.setTripletInContext(source, klass, segment);
        this.config.postprocessClassParams.accept(this.config.ctx);
        segment.write(this.config.postprocessClassResolv.apply(this.config.ctx, this.getTemplateContent(local.postprocessClass, this.templates((Config)local).postprocessClass)), new Object[0]);
    }

    public void preprocess(Source source, Class<?> klass, CompoundParams global, Segment segment) {
        Config local = this.localConfig(global);
        Templated.setParams(segment, "this.", "SimpleName", klass.getSimpleName(), "Name", klass.getName(), "CanonicalName", klass.getCanonicalName(), "Package", klass.getPackageName(), "TypeName", klass.getTypeName(), "GenericString", klass.toGenericString());
        this.setTripletInContext(source, klass, segment);
        this.config.preprocessParams.accept(this.config.ctx);
        for (String key : global.keySet()) {
            segment.param(new String[]{key, global.get(key)});
            segment.param(new String[]{"global." + key, global.get(key)});
        }
        segment.write(this.config.preprocessResolv.apply(this.config.ctx, this.getTemplateContent(local.preprocess, this.templates((Config)local).preprocess)), new Object[0]);
    }

    public void process(Source source, Class<?> klass, CompoundParams params, Field field, Segment segment) {
        Config local = this.localConfig(params);
        Class<?> fieldType = field.getType();
        Templated.setParams(segment, "field.", "name", field.getName(), "genericString", field.toGenericString(), "classSimpleName", fieldType.getSimpleName(), "className", fieldType.getName(), "classCanonicalName", fieldType.getCanonicalName(), "classPackage", fieldType.getPackageName(), "classTypeName", fieldType.getTypeName(), "classGenericString", fieldType.toGenericString());
        this.setTripletInContext(source, klass, segment);
        this.config.processFieldParams.accept(this.config.ctx, field);
        for (String key : params.keySet()) {
            segment.param(new String[]{key, params.get(key)});
        }
        segment.write(this.config.processFieldResolv.apply(this.config.ctx, this.getTemplateContent(local.processField, this.templates((Config)local).processField)), new Object[0]);
        for (String key : segment.paramKeySet()) {
            if (!key.startsWith("field.")) continue;
            segment.param(new String[]{key, null});
        }
    }

    public void process(Source source, Class<?> klass, CompoundParams params, Class memberClass, Segment segment) {
        Config local = this.localConfig(params);
        Templated.setParams(segment, "memberClass.", "SimpleName", memberClass.getSimpleName(), "Name", memberClass.getName(), "CanonicalName", memberClass.getCanonicalName(), "Package", memberClass.getPackageName(), "TypeName", memberClass.getTypeName(), "GenericString", memberClass.toGenericString());
        this.setTripletInContext(source, klass, segment);
        this.config.processMemberClassParams.accept(this.config.ctx, memberClass);
        for (String key : params.keySet()) {
            segment.param(new String[]{key, params.get(key)});
        }
        segment.write(this.config.processMemberClassResolv.apply(this.config.ctx, this.getTemplateContent(local.processMemberClass, this.templates((Config)local).processMemberClass)), new Object[0]);
        for (String key : segment.paramKeySet()) {
            if (!key.startsWith("memberClass.")) continue;
            segment.param(new String[]{key, null});
        }
    }

    public void process(Source source, Class<?> klass, CompoundParams params, Method method, Segment segment) {
        Config local = this.localConfig(params);
        Class<?> returnType = method.getReturnType();
        Templated.setParams(segment, "method.", "name", method.getName(), "genericString", method.toGenericString(), "returnClassSimpleName", returnType.getSimpleName(), "returnClassName", returnType.getName(), "returnClassCanonicalName", returnType.getCanonicalName(), "returnClassPackage", returnType.getPackageName(), "returnClassTypeName", returnType.getTypeName(), "returnClassGenericString", returnType.toGenericString());
        this.setTripletInContext(source, klass, segment);
        this.config.processMethodParams.accept(this.config.ctx, method);
        for (String key : params.keySet()) {
            segment.param(new String[]{key, params.get(key)});
        }
        segment.write(this.config.processMethodResolv.apply(this.config.ctx, this.getTemplateContent(local.processMethod, this.templates((Config)local).processMethod)), new Object[0]);
        for (String key : segment.paramKeySet()) {
            if (!key.startsWith("method.")) continue;
            segment.param(new String[]{key, null});
        }
    }

    private String getTemplateContent(String localTemplateName, String globalTemplateName) {
        if (localTemplateName != null) {
            return TemplateLoader.getTemplateContent((String)localTemplateName);
        }
        return TemplateLoader.getTemplateContent((String)globalTemplateName);
    }

    private Templates templates(Config local) {
        if (this.config.templatesMap.containsKey(local.selector)) {
            return this.config.templatesMap.get(local.selector);
        }
        return EMPTY;
    }

    public void processFields(Source source, Class<?> klass, CompoundParams global, List<Field> fields, Segment segment) {
        Config local = this.localConfig(global);
        segment.param(new String[]{"fields.n", "" + fields.size()});
        int i = 0;
        for (Field field : fields) {
            Class<?> fieldType = field.getType();
            String name = field.getName();
            Templated.setParams(segment, "field." + i + ".", "GenericString", field.toGenericString(), "ClassSimpleName", fieldType.getSimpleName(), "ClassName", fieldType.getName(), "ClassCanonicalName", fieldType.getCanonicalName(), "ClassPackage", fieldType.getPackageName(), "ClassTypeName", fieldType.getTypeName(), "ClassGenericString", fieldType.toGenericString());
            ++i;
            Templated.setParams(segment, "field." + name + ".", "GenericString", field.toGenericString(), "ClassSimpleName", fieldType.getSimpleName(), "ClassName", fieldType.getName(), "ClassCanonicalName", fieldType.getCanonicalName(), "ClassPackage", fieldType.getPackageName(), "ClassTypeName", fieldType.getTypeName(), "ClassGenericString", fieldType.toGenericString());
        }
        this.setTripletInContext(source, klass, segment);
        this.config.processFieldsParams.accept(this.config.ctx);
        segment.write(this.config.processFieldResolv.apply(this.config.ctx, this.getTemplateContent(local.processFields, this.templates((Config)local).processFields)), new Object[0]);
    }

    public void processMethods(Source source, Class<?> klass, CompoundParams global, List<Method> methods, Segment segment) {
        Config local = this.localConfig(global);
        segment.param(new String[]{"methods.n", "" + methods.size()});
        int i = 0;
        for (Method method : methods) {
            Class<?> returnType = method.getReturnType();
            String name = method.getName();
            Templated.setParams(segment, "method." + i + ".", "GenericString", method.toGenericString(), "ReturnClassSimpleName", returnType.getSimpleName(), "ReturnClassName", returnType.getName(), "ReturnClassCanonicalName", returnType.getCanonicalName(), "ReturnClassPackage", returnType.getPackageName(), "ReturnClassTypeName", returnType.getTypeName(), "ReturnClassGenericString", returnType.toGenericString());
            ++i;
            Templated.setParams(segment, "method." + name + ".", "GenericString", method.toGenericString(), "ReturnClassSimpleName", returnType.getSimpleName(), "ReturnClassName", returnType.getName(), "ReturnClassCanonicalName", returnType.getCanonicalName(), "ReturnClassPackage", returnType.getPackageName(), "ReturnClassTypeName", returnType.getTypeName(), "ReturnClassGenericString", returnType.toGenericString());
        }
        this.setTripletInContext(source, klass, segment);
        this.config.processMethodsParams.accept(this.config.ctx);
        segment.write(this.config.processMethodsResolv.apply(this.config.ctx, this.getTemplateContent(local.processMethods, this.templates((Config)local).processMethods)), new Object[0]);
    }

    public void processClasses(Source source, Class<?> klass, CompoundParams global, List<Class> classes, Segment segment) {
        Config local = this.localConfig(global);
        segment.param(new String[]{"memberClasses.n", "" + classes.size()});
        int i = 0;
        for (Class memberClass : classes) {
            Templated.setParams(segment, "memberClass." + i + ".", "SimpleName", memberClass.getSimpleName(), "Name", memberClass.getName(), "CanonicalName", memberClass.getCanonicalName(), "Package", memberClass.getPackageName(), "TypeName", memberClass.getTypeName(), "GenericString", memberClass.toGenericString());
            ++i;
            Templated.setParams(segment, "memberClass." + memberClass.getName() + ".", "SimpleName", memberClass.getSimpleName(), "Name", memberClass.getName(), "CanonicalName", memberClass.getCanonicalName(), "Package", memberClass.getPackageName(), "TypeName", memberClass.getTypeName(), "GenericString", memberClass.toGenericString());
        }
        this.setTripletInContext(source, klass, segment);
        this.config.processClassesParams.accept(this.config.ctx);
        segment.write(this.config.processClassesResolv.apply(this.config.ctx, this.getTemplateContent(local.processClasses, this.templates((Config)local).processClasses)), new Object[0]);
    }

    public void postprocess(Source source, Class<?> klass, CompoundParams global, Segment segment) {
        Config local = this.localConfig(global);
        this.setTripletInContext(source, klass, segment);
        this.config.postprocessParams.accept(this.config.ctx);
        segment.write(this.config.postprocessResolv.apply(this.config.ctx, this.getTemplateContent(local.postprocess, this.templates((Config)local).postprocess)), new Object[0]);
    }

    private void setTripletInContext(Source source, Class<?> klass, Segment segment) {
        this.config.ctx.triplet(source, klass, segment);
    }

    private static void setParams(Segment segment, String prefix, String ... keyValuePairs) {
        if (keyValuePairs.length % 2 == 1) {
            throw new IllegalArgumentException("Parameters to Segment.param() should be in pair");
        }
        for (int i = 0; i < keyValuePairs.length; i += 2) {
            segment.param(new String[]{prefix + keyValuePairs[i], keyValuePairs[i + 1]});
        }
    }

    public String mnemonic() {
        return "templated";
    }

    public static Builder builder() {
        return new Templated().new Builder();
    }

    public Set<String> implementedKeys() {
        return implementedKeys;
    }

    private Config localConfig(CompoundParams params) {
        Config local = new Config();
        local.classFilter = params.get("classFilter", this.config.classFilter);
        local.ctx = this.config.ctx;
        local.declaredOnly = this.config.declaredOnly;
        local.fieldFilter = params.get("fieldFilter", this.config.fieldFilter);
        local.generatedAnnotation = this.config.generatedAnnotation;
        local.memberClassFilter = params.get("memberClassFilter", this.config.memberClassFilter);
        local.methodFilter = params.get("methodFilter", this.config.methodFilter);
        local.setPostprocess(params.get("postprocess", this.config.postprocess));
        local.setPostprocessClass(params.get("postprocessClass", this.config.postprocessClass));
        local.postprocessClassParams = this.config.postprocessClassParams;
        local.postprocessClassResolv = this.config.postprocessClassResolv;
        local.postprocessParams = this.config.postprocessParams;
        local.postprocessResolv = this.config.postprocessResolv;
        local.setPreprocess(params.get("preprocess", this.config.preprocess));
        local.setPreprocessClass(params.get("preprocessClass", this.config.preprocessClass));
        local.preprocessClassParams = this.config.preprocessClassParams;
        local.preprocessClassResolv = this.config.preprocessClassResolv;
        local.preprocessParams = this.config.preprocessParams;
        local.preprocessResolv = this.config.preprocessResolv;
        local.setProcessClass(params.get("processClass", this.config.processClass));
        local.processClassParams = this.config.processClassParams;
        local.processClassResolv = this.config.processClassResolv;
        local.setProcessClasses(params.get("processClasses", this.config.processClasses));
        local.processClassesParams = this.config.processClassesParams;
        local.processClassesResolv = this.config.processClassesResolv;
        local.setProcessField(params.get("processField", this.config.processField));
        local.processFieldParams = this.config.processFieldParams;
        local.processFieldResolv = this.config.processFieldResolv;
        local.setProcessFields(params.get("processFields", this.config.processFields));
        local.processFieldsParams = this.config.processFieldsParams;
        local.processFieldsResolv = this.config.processFieldsResolv;
        local.setProcessMemberClass(params.get("processMemberClass", this.config.processMemberClass));
        local.processMemberClassParams = this.config.processMemberClassParams;
        local.processMemberClassResolv = this.config.processMemberClassResolv;
        local.setProcessMethod(params.get("processMethod", this.config.processMethod));
        local.processMethodParams = this.config.processMethodParams;
        local.processMethodResolv = this.config.processMethodResolv;
        local.setProcessMethods(params.get("processMethods", this.config.processMethods));
        local.processMethodsParams = this.config.processMethodsParams;
        local.processMethodsResolv = this.config.processMethodsResolv;
        local.selector = params.get("selector", this.config.selector);
        return local;
    }

    public class Builder
    implements GeneratorBuilder {
        public Builder classFilter(String classFilter) {
            Templated.this.config.classFilter = classFilter;
            return this;
        }

        public Builder ctx(Context ctx) {
            Templated.this.config.ctx = ctx;
            return this;
        }

        public Builder declaredOnly(boolean declaredOnly) {
            Templated.this.config.declaredOnly = declaredOnly;
            return this;
        }

        public Builder fieldFilter(String fieldFilter) {
            Templated.this.config.fieldFilter = fieldFilter;
            return this;
        }

        public Builder generatedAnnotation(Class<? extends Annotation> generatedAnnotation) {
            Templated.this.config.generatedAnnotation = generatedAnnotation;
            return this;
        }

        public Builder memberClassFilter(String memberClassFilter) {
            Templated.this.config.memberClassFilter = memberClassFilter;
            return this;
        }

        public Builder methodFilter(String methodFilter) {
            Templated.this.config.methodFilter = methodFilter;
            return this;
        }

        public Builder postprocess(String postprocess) {
            Templated.this.config.setPostprocess(postprocess);
            return this;
        }

        public Builder postprocessClass(String postprocessClass) {
            Templated.this.config.setPostprocessClass(postprocessClass);
            return this;
        }

        public Builder postprocessClassParams(Consumer<Context> postprocessClassParams) {
            Templated.this.config.postprocessClassParams = postprocessClassParams;
            return this;
        }

        public Builder postprocessClassResolv(BiFunction<Context, String, String> postprocessClassResolv) {
            Templated.this.config.postprocessClassResolv = postprocessClassResolv;
            return this;
        }

        public Builder postprocessParams(Consumer<Context> postprocessParams) {
            Templated.this.config.postprocessParams = postprocessParams;
            return this;
        }

        public Builder postprocessResolv(BiFunction<Context, String, String> postprocessResolv) {
            Templated.this.config.postprocessResolv = postprocessResolv;
            return this;
        }

        public Builder preprocess(String preprocess) {
            Templated.this.config.setPreprocess(preprocess);
            return this;
        }

        public Builder preprocessClass(String preprocessClass) {
            Templated.this.config.setPreprocessClass(preprocessClass);
            return this;
        }

        public Builder preprocessClassParams(Consumer<Context> preprocessClassParams) {
            Templated.this.config.preprocessClassParams = preprocessClassParams;
            return this;
        }

        public Builder preprocessClassResolv(BiFunction<Context, String, String> preprocessClassResolv) {
            Templated.this.config.preprocessClassResolv = preprocessClassResolv;
            return this;
        }

        public Builder preprocessParams(Consumer<Context> preprocessParams) {
            Templated.this.config.preprocessParams = preprocessParams;
            return this;
        }

        public Builder preprocessResolv(BiFunction<Context, String, String> preprocessResolv) {
            Templated.this.config.preprocessResolv = preprocessResolv;
            return this;
        }

        public Builder processClass(String processClass) {
            Templated.this.config.setProcessClass(processClass);
            return this;
        }

        public Builder processClassParams(BiConsumer<Context, Class> processClassParams) {
            Templated.this.config.processClassParams = processClassParams;
            return this;
        }

        public Builder processClassResolv(BiFunction<Context, String, String> processClassResolv) {
            Templated.this.config.processClassResolv = processClassResolv;
            return this;
        }

        public Builder processClasses(String processClasses) {
            Templated.this.config.setProcessClasses(processClasses);
            return this;
        }

        public Builder processClassesParams(Consumer<Context> processClassesParams) {
            Templated.this.config.processClassesParams = processClassesParams;
            return this;
        }

        public Builder processClassesResolv(BiFunction<Context, String, String> processClassesResolv) {
            Templated.this.config.processClassesResolv = processClassesResolv;
            return this;
        }

        public Builder processField(String processField) {
            Templated.this.config.setProcessField(processField);
            return this;
        }

        public Builder processFieldParams(BiConsumer<Context, Field> processFieldParams) {
            Templated.this.config.processFieldParams = processFieldParams;
            return this;
        }

        public Builder processFieldResolv(BiFunction<Context, String, String> processFieldResolv) {
            Templated.this.config.processFieldResolv = processFieldResolv;
            return this;
        }

        public Builder processFields(String processFields) {
            Templated.this.config.setProcessFields(processFields);
            return this;
        }

        public Builder processFieldsParams(Consumer<Context> processFieldsParams) {
            Templated.this.config.processFieldsParams = processFieldsParams;
            return this;
        }

        public Builder processFieldsResolv(BiFunction<Context, String, String> processFieldsResolv) {
            Templated.this.config.processFieldsResolv = processFieldsResolv;
            return this;
        }

        public Builder processMemberClass(String processMemberClass) {
            Templated.this.config.setProcessMemberClass(processMemberClass);
            return this;
        }

        public Builder processMemberClassParams(BiConsumer<Context, Class> processMemberClassParams) {
            Templated.this.config.processMemberClassParams = processMemberClassParams;
            return this;
        }

        public Builder processMemberClassResolv(BiFunction<Context, String, String> processMemberClassResolv) {
            Templated.this.config.processMemberClassResolv = processMemberClassResolv;
            return this;
        }

        public Builder processMethod(String processMethod) {
            Templated.this.config.setProcessMethod(processMethod);
            return this;
        }

        public Builder processMethodParams(BiConsumer<Context, Method> processMethodParams) {
            Templated.this.config.processMethodParams = processMethodParams;
            return this;
        }

        public Builder processMethodResolv(BiFunction<Context, String, String> processMethodResolv) {
            Templated.this.config.processMethodResolv = processMethodResolv;
            return this;
        }

        public Builder processMethods(String processMethods) {
            Templated.this.config.setProcessMethods(processMethods);
            return this;
        }

        public Builder processMethodsParams(Consumer<Context> processMethodsParams) {
            Templated.this.config.processMethodsParams = processMethodsParams;
            return this;
        }

        public Builder processMethodsResolv(BiFunction<Context, String, String> processMethodsResolv) {
            Templated.this.config.processMethodsResolv = processMethodsResolv;
            return this;
        }

        public Builder selector(String selector) {
            Templated.this.config.selector = selector;
            return this;
        }

        public Templated build() {
            return Templated.this;
        }
    }

    private static class Templates {
        private String preprocess = null;
        private String processField = null;
        private String processMethod = null;
        private String processClass = null;
        private String processMemberClass = null;
        private String processMethods = null;
        private String processClasses = null;
        private String processFields = null;
        private String postprocess = null;
        private String preprocessClass = null;
        private String postprocessClass = null;

        private Templates() {
        }
    }

    private static class Config {
        private Class<? extends Annotation> generatedAnnotation = Generated.class;
        private Context ctx = new Triplet();
        private String fieldFilter = "true";
        private String methodFilter = "true";
        private String classFilter = "true";
        private String memberClassFilter = "true";
        private boolean declaredOnly = true;
        private String selector = "";
        private final Map<String, Templates> templatesMap = new HashMap<String, Templates>();
        private String preprocess = null;
        private String processField = null;
        private String processMethod = null;
        private String processClass = null;
        private String processMemberClass = null;
        private String processMethods = null;
        private String processClasses = null;
        private String processFields = null;
        private String postprocess = null;
        private String preprocessClass = null;
        private String postprocessClass = null;
        private Consumer<Context> preprocessParams = NOOP;
        private BiConsumer<Context, Field> processFieldParams = BiNOOP;
        private BiConsumer<Context, Method> processMethodParams = BiNOOP;
        private BiConsumer<Context, Class> processClassParams = BiNOOP;
        private BiConsumer<Context, Class> processMemberClassParams = BiNOOP;
        private Consumer<Context> processMethodsParams = NOOP;
        private Consumer<Context> processClassesParams = NOOP;
        private Consumer<Context> processFieldsParams = NOOP;
        private Consumer<Context> postprocessParams = NOOP;
        private Consumer<Context> preprocessClassParams = NOOP;
        private Consumer<Context> postprocessClassParams = NOOP;
        private BiFunction<Context, String, String> preprocessResolv = BiFuNOOP;
        private BiFunction<Context, String, String> processFieldResolv = BiFuNOOP;
        private BiFunction<Context, String, String> processMethodResolv = BiFuNOOP;
        private BiFunction<Context, String, String> processClassResolv = BiFuNOOP;
        private BiFunction<Context, String, String> processMemberClassResolv = BiFuNOOP;
        private BiFunction<Context, String, String> processMethodsResolv = BiFuNOOP;
        private BiFunction<Context, String, String> processClassesResolv = BiFuNOOP;
        private BiFunction<Context, String, String> processFieldsResolv = BiFuNOOP;
        private BiFunction<Context, String, String> postprocessResolv = BiFuNOOP;
        private BiFunction<Context, String, String> preprocessClassResolv = BiFuNOOP;
        private BiFunction<Context, String, String> postprocessClassResolv = BiFuNOOP;

        private Config() {
        }

        private Templates templates() {
            if (!this.templatesMap.containsKey(this.selector)) {
                this.templatesMap.put(this.selector, new Templates());
            }
            return this.templatesMap.get(this.selector);
        }

        private void setPreprocess(String template) {
            this.templates().preprocess = template;
        }

        private void setProcessField(String template) {
            this.templates().processField = template;
        }

        private void setProcessMethod(String template) {
            this.templates().processMethod = template;
        }

        private void setProcessClass(String template) {
            this.templates().processClass = template;
        }

        private void setProcessMemberClass(String template) {
            this.templates().processMemberClass = template;
        }

        private void setProcessMethods(String template) {
            this.templates().processMethods = template;
        }

        private void setProcessClasses(String template) {
            this.templates().processClasses = template;
        }

        private void setProcessFields(String template) {
            this.templates().processFields = template;
        }

        private void setPostprocess(String template) {
            this.templates().postprocess = template;
        }

        private void setPreprocessClass(String template) {
            this.templates().preprocessClass = template;
        }

        private void setPostprocessClass(String template) {
            this.templates().postprocessClass = template;
        }
    }
}

