/*
 * Decompiled with CFR 0.152.
 */
package javax0.geci.repeated;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax0.geci.api.GeciException;
import javax0.geci.api.GeneratorBuilder;
import javax0.geci.api.Segment;
import javax0.geci.api.Source;
import javax0.geci.core.annotations.AnnotationBuilder;
import javax0.geci.templated.Context;
import javax0.geci.templated.Triplet;
import javax0.geci.tools.AbstractJavaGenerator;
import javax0.geci.tools.CompoundParams;
import javax0.geci.tools.TemplateLoader;
import javax0.geci.tools.Tracer;

@AnnotationBuilder
public class Repeated
extends AbstractJavaGenerator {
    private String configuredMnemonic = "repeated";
    private final Config config = new Config();
    private static final Set<String> implementedKeys = new HashSet<String>(Arrays.asList("end", "matchLine", "start", "templateEnd", "templateStart", "values", "id"));

    public void process(Source source, Class<?> klass, CompoundParams global) throws Exception {
        Config local = this.localConfig(global);
        Pattern startPattern = Pattern.compile(local.start);
        Pattern matchLinePattern = Pattern.compile(local.matchLine);
        Pattern endPattern = Pattern.compile(local.end);
        Pattern templateStartPattern = Pattern.compile(local.templateStart);
        Pattern templateEndPattern = Pattern.compile(local.templateEnd);
        try (Tracer pos = Tracer.push((String)"Config", null);){
            Tracer.log((String)"startPattern", (String)("" + startPattern));
            Tracer.log((String)"matchLinePattern", (String)("" + matchLinePattern));
            Tracer.log((String)"endPattern", (String)("" + endPattern));
            Tracer.log((String)"templateStartPattern", (String)("" + templateStartPattern));
            Tracer.log((String)"templateEndPattern", (String)("" + templateEndPattern));
        }
        boolean switchOn = false;
        boolean templateOn = false;
        ArrayList<String> loopVars = new ArrayList<String>();
        StringBuilder parsed = new StringBuilder();
        String selector = "";
        int templateTabbing = 0;
        try (Tracer x = Tracer.push((String)"TemplateSearch", (String)"searching...");){
            for (String line : source.getLines()) {
                if (templateOn) {
                    Tracer.push((String)"TemplateLine", (String)line.substring(line.length() > templateTabbing ? templateTabbing : 0));
                } else if (switchOn) {
                    Tracer.push((String)"ValueLine", (String)line.substring(line.length() > templateTabbing ? templateTabbing : 0));
                } else {
                    Tracer.push((String)"Line", (String)line);
                }
                if (!templateOn && !switchOn) {
                    if (startPattern.matcher(line).matches()) {
                        Tracer.prepend((String)"[START VALUES]");
                        switchOn = true;
                        continue;
                    }
                    Matcher templateStartMatcher = templateStartPattern.matcher(line);
                    if (templateStartMatcher.matches()) {
                        Tracer.prepend((String)"[START TEMPLATE]");
                        templateOn = true;
                        selector = templateStartMatcher.group(1);
                        templateTabbing = Repeated.countSpacesAtStart(line);
                        Tracer.log((String)("TAB=" + templateTabbing + " SELECTOR=" + selector));
                        continue;
                    }
                }
                if (switchOn && endPattern.matcher(line).matches()) {
                    Tracer.prepend((String)"[STOP]");
                    switchOn = false;
                    Tracer.pop();
                    Tracer.pop();
                    continue;
                }
                if (!switchOn && templateOn && templateEndPattern.matcher(line).matches()) {
                    Tracer.prepend((String)"[STOP]");
                    templateOn = false;
                    this.deleteTrailingNewLine(parsed);
                    this.config.templatesMap.put(selector, TemplateLoader.quote((String)parsed.toString()));
                    parsed.delete(0, parsed.length());
                    Tracer.pop();
                    Tracer.pop();
                    continue;
                }
                if (templateOn) {
                    if (line.length() > templateTabbing) {
                        parsed.append(line.substring(templateTabbing));
                    }
                    parsed.append("\n");
                    Tracer.pop();
                    continue;
                }
                if (switchOn) {
                    Matcher matcher = matchLinePattern.matcher(line);
                    if (matcher.find()) {
                        Tracer.log((String)"Line contains a value");
                        if (matcher.groupCount() != 1) {
                            Tracer.log((String)"Pattern did not return the value... GECI EXCEPTION is thrown");
                            throw new GeciException("matchLine does not contain any group between ( and )", new Object[0]);
                        }
                        String value = matcher.group(1);
                        Tracer.log((String)("value=" + value));
                        loopVars.add(value);
                    } else {
                        Tracer.log((String)"There is no value on the line");
                    }
                }
                Tracer.pop();
            }
        }
        if (local.values != null) {
            Tracer.log((String)("Adding configured values [" + local.values + "]"));
            loopVars.addAll(Arrays.asList(local.values.split(",")));
        }
        if (local.valuesSupplier != null) {
            Tracer.log((String)"Adding values from configured values supplier");
            loopVars.addAll((Collection)local.valuesSupplier.apply(klass));
        }
        Tracer.log((String)("final list of values: [" + String.join((CharSequence)",", loopVars) + "]"));
        for (String key : this.config.templatesMap.keySet()) {
            Tracer pos = Tracer.push((String)"Segment", (String)key);
            try {
                String segmentKey;
                if (key.isEmpty()) {
                    Tracer.log((String)("This is the ID segment named '" + global.id() + "'"));
                    segmentKey = global.id();
                } else {
                    segmentKey = key;
                }
                Segment segment = source.open(segmentKey);
                try {
                    if (segment == null) {
                        throw new GeciException("Segment " + segmentKey + " does not exist", new Object[0]);
                    }
                    String template = this.config.templatesMap.get(key);
                    if (template != null) {
                        Tracer.log((String)"Template", null, (String)template);
                        this.config.ctx.triplet(source, klass, segment);
                        BiFunction<Context, String, String> resolver = this.config.resolverMap.get(key);
                        BiConsumer<Context, String> define = this.config.defineMap.get(key);
                        String templateContent = TemplateLoader.getTemplateContent((String)template);
                        Tracer.log((String)"TemplateContent", null, (String)templateContent);
                        String resolvedTemplate = resolver == null ? templateContent : resolver.apply(this.config.ctx, templateContent);
                        for (String loopVar : loopVars) {
                            segment.param(new String[]{"value", loopVar});
                            if (define != null) {
                                define.accept(this.config.ctx, loopVar);
                            }
                            Tracer segmentParamsPos = Tracer.push((String)"SegmentParams", null);
                            try {
                                segment.traceParams();
                                segment.write(resolvedTemplate, new Object[0]);
                            }
                            finally {
                                if (segmentParamsPos == null) continue;
                                segmentParamsPos.close();
                            }
                        }
                        segment.traceLines();
                        continue;
                    }
                    Tracer.log((String)("Template " + key + " does not exist"));
                }
                finally {
                    if (segment == null) continue;
                    segment.close();
                }
            }
            finally {
                if (pos == null) continue;
                pos.close();
            }
        }
    }

    private void deleteTrailingNewLine(StringBuilder parsed) {
        if (parsed.length() > 0 && parsed.charAt(parsed.length() - 1) == '\n') {
            parsed.deleteCharAt(parsed.length() - 1);
            if (parsed.length() > 0 && parsed.charAt(parsed.length() - 1) == '\r') {
                parsed.deleteCharAt(parsed.length() - 1);
            }
        }
    }

    private static int countSpacesAtStart(String line) {
        for (int i = 0; i < line.length(); ++i) {
            if (line.charAt(i) == ' ') continue;
            return i;
        }
        return 0;
    }

    public String mnemonic() {
        return this.configuredMnemonic;
    }

    public static Builder builder() {
        return new Repeated().new Builder();
    }

    public Set<String> implementedKeys() {
        return implementedKeys;
    }

    private Config localConfig(CompoundParams params) {
        Config local = new Config();
        local.ctx = this.config.ctx;
        local.setDefine(this.config.define);
        local.end = params.get("end", this.config.end);
        local.matchLine = params.get("matchLine", this.config.matchLine);
        local.setResolver(this.config.resolver);
        local.selector = this.config.selector;
        local.start = params.get("start", this.config.start);
        local.setTemplate(this.config.template);
        local.templateEnd = params.get("templateEnd", this.config.templateEnd);
        local.templateStart = params.get("templateStart", this.config.templateStart);
        local.values = params.get("values", this.config.values);
        local.valuesSupplier = this.config.valuesSupplier;
        return local;
    }

    public class Builder
    implements GeneratorBuilder {
        public Builder ctx(Context ctx) {
            Repeated.this.config.ctx = ctx;
            return this;
        }

        public Builder define(BiConsumer<Context, String> define) {
            Repeated.this.config.setDefine(define);
            return this;
        }

        public Builder end(String end) {
            Repeated.this.config.end = end;
            return this;
        }

        public Builder matchLine(String matchLine) {
            Repeated.this.config.matchLine = matchLine;
            return this;
        }

        public Builder resolver(BiFunction<Context, String, String> resolver) {
            Repeated.this.config.setResolver(resolver);
            return this;
        }

        public Builder selector(CharSequence selector) {
            Repeated.this.config.selector = selector;
            return this;
        }

        public Builder start(String start) {
            Repeated.this.config.start = start;
            return this;
        }

        public Builder template(CharSequence template) {
            Repeated.this.config.setTemplate(template);
            return this;
        }

        public Builder templateEnd(String templateEnd) {
            Repeated.this.config.templateEnd = templateEnd;
            return this;
        }

        public Builder templateStart(String templateStart) {
            Repeated.this.config.templateStart = templateStart;
            return this;
        }

        public Builder values(String values) {
            Repeated.this.config.values = values;
            return this;
        }

        public Builder valuesSupplier(Function<Class, List<String>> valuesSupplier) {
            Repeated.this.config.valuesSupplier = valuesSupplier;
            return this;
        }

        public Builder mnemonic(String mnemonic) {
            Repeated.this.configuredMnemonic = mnemonic;
            return this;
        }

        public Repeated build() {
            return Repeated.this;
        }
    }

    private static class Config {
        private String start = ".*//\\s*START\\s*";
        private String matchLine = "(.*)";
        private String end = ".*//\\s*END\\s*";
        private String templateStart = "\\s*/\\*\\s*TEMPLATE\\s+(\\w*)\\s*";
        private String templateEnd = "\\s*\\*/\\s*";
        private String values = null;
        private Function<Class, List<String>> valuesSupplier = null;
        private CharSequence selector = "";
        private final CharSequence template = "";
        private Context ctx = new Triplet();
        private final Map<String, String> templatesMap = new HashMap<String, String>();
        private BiFunction<Context, String, String> resolver;
        private final Map<String, BiFunction<Context, String, String>> resolverMap = new HashMap<String, BiFunction<Context, String, String>>();
        private BiConsumer<Context, String> define;
        private final Map<String, BiConsumer<Context, String>> defineMap = new HashMap<String, BiConsumer<Context, String>>();

        private Config() {
        }

        private void setTemplate(CharSequence template) {
            if (this.templatesMap.containsKey(this.selector.toString())) {
                throw new GeciException("Selector '" + this.selector + "' already has a template", new Object[0]);
            }
            this.templatesMap.put(this.selector.toString(), template.toString());
        }

        private void setResolver(BiFunction<Context, String, String> resolver) {
            if (this.resolverMap.containsKey(this.selector.toString())) {
                throw new GeciException("Selector '" + this.selector + "' already has a resolver", new Object[0]);
            }
            this.resolverMap.put(this.selector.toString(), resolver);
        }

        private void setDefine(BiConsumer<Context, String> define) {
            if (this.defineMap.containsKey(this.selector.toString())) {
                throw new GeciException("Selector '" + this.selector + "' already has a define", new Object[0]);
            }
            this.defineMap.put(this.selector.toString(), define);
        }
    }
}

