/*
 * Decompiled with CFR 0.152.
 */
package javax0.geci.record;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax0.geci.api.GeciException;
import javax0.geci.api.GeneratorBuilder;
import javax0.geci.api.Segment;
import javax0.geci.api.Source;
import javax0.geci.core.annotations.AnnotationBuilder;
import javax0.geci.lexeger.JavaLexed;
import javax0.geci.lexeger.Lex;
import javax0.geci.lexeger.LexpressionBuilder;
import javax0.geci.tools.AbstractFilteredFieldsGenerator;
import javax0.geci.tools.CaseTools;
import javax0.geci.tools.CompoundParams;
import javax0.geci.tools.GeciReflectionTools;
import javax0.geci.tools.reflection.Selector;

@AnnotationBuilder
public class Record
extends AbstractFilteredFieldsGenerator {
    private static final Selector<Field> NON_STATIC = Selector.compile((String)"! static ");
    private static Selector<Field> NON_FINAL__NON_STATIC = Selector.compile((String)"!final & ! static ");
    private static final Selector<Method> VOID = Selector.compile((String)"void");
    private static final Selector<Class<?>> NOT_FINAL = Selector.compile((String)"!final");
    private final Config config = new Config();
    private static final Set<String> implementedKeys = new HashSet<String>(Arrays.asList("filter", "id"));

    public void process(Source source, Class<?> klass, CompoundParams global, Field[] fields, Segment segment) {
        String argumentDeclaration;
        List<Field> sortedFields;
        String validator;
        this.classAssertions(klass);
        try (JavaLexed javaLexed = new JavaLexed(source);){
            validator = this.getValidatorMethodName(klass);
            this.makeClassFinal(klass, javaLexed);
            this.makeFieldsFinal(fields, javaLexed);
            sortedFields = this.getFieldsSorted(fields, javaLexed);
            argumentDeclaration = this.calculateArgsDeclaration(sortedFields);
            this.fixValidatorArguments(javaLexed, validator, argumentDeclaration);
        }
        this.generateConstructor(klass, segment, sortedFields, validator, argumentDeclaration);
        this.generateGetters(segment, sortedFields);
        this.generateHashCode(segment, sortedFields);
        this.generateEquals(segment, sortedFields, klass);
    }

    private void generateGetters(Segment segment, List<Field> sortedFields) {
        for (Field f : sortedFields) {
            segment.write_r("public " + GeciReflectionTools.getGenericTypeName((Type)f.getGenericType()) + " get" + CaseTools.ucase((String)f.getName()) + "() {", new Object[0]);
            segment.write("return " + f.getName() + ";", new Object[0]);
            segment.write_l("}", new Object[0]).newline();
        }
    }

    private void classAssertions(Class<?> klass) {
        if (!klass.getSuperclass().equals(Object.class)) {
            throw new GeciException("Class " + klass.getName() + " cannot be record because it has a superclass", new Object[0]);
        }
        if ((klass.getModifiers() & 0x400) != 0) {
            throw new GeciException("Class " + klass.getName() + " cannot be record because it is abstract", new Object[0]);
        }
    }

    private String getValidatorMethodName(Class<?> klass) {
        return this.getValidatorMethod(klass).map(Method::getName).orElse(null);
    }

    private void fixValidatorArguments(JavaLexed javaLexed, String validatorMethodName, String argumentDeclaration) {
        javaLexed.find(LexpressionBuilder.list((BiFunction[])new BiFunction[]{LexpressionBuilder.match((String)("void " + validatorMethodName + "(")), LexpressionBuilder.anyTill((String)")"), LexpressionBuilder.match((String)")")})).fromStart().replaceWith(new List[]{Lex.of((String)("void " + validatorMethodName + "(" + argumentDeclaration + ")"))});
    }

    private Optional<Method> getValidatorMethod(Class<?> klass) {
        Method[] methods = klass.getDeclaredMethods();
        Method validatorMethod = null;
        for (Method method : methods) {
            if (!method.getName().equalsIgnoreCase(klass.getSimpleName()) || !VOID.match((Object)method)) continue;
            if (validatorMethod != null) {
                throw new GeciException("There are more than one methods mimicking the validator constructor of the record class " + klass.getName(), new Object[0]);
            }
            validatorMethod = method;
        }
        return Optional.ofNullable(validatorMethod);
    }

    private void generateConstructor(Class<?> klass, Segment segment, List<Field> sortedFields, String validatorMethod, String argumentDeclaration) {
        segment.write_r("public " + klass.getSimpleName() + "(" + argumentDeclaration + ") {", new Object[0]);
        if (validatorMethod != null) {
            segment.write(validatorMethod + "(" + sortedFields.stream().map(Field::getName).collect(Collectors.joining(", ")) + ");", new Object[0]);
        }
        for (Field field : sortedFields) {
            segment.write("this." + field.getName() + " = " + field.getName() + ";", new Object[0]);
        }
        segment.write_l("}", new Object[0]).newline();
    }

    private String calculateArgsDeclaration(List<Field> sortedFields) {
        return sortedFields.stream().map(f -> "final " + GeciReflectionTools.getGenericTypeName((Type)f.getGenericType()) + " " + f.getName()).collect(Collectors.joining(", "));
    }

    private List<Field> getFieldsSorted(Field[] fields, JavaLexed javaLexed) {
        ArrayList<Field> sortedFields = new ArrayList<Field>();
        ArrayList<Integer> fieldStart = new ArrayList<Integer>();
        for (Field field : fields) {
            int i;
            if (!NON_STATIC.match((Object)field)) continue;
            int start = this.getDeclarationStartOfField(javaLexed, field);
            for (i = 0; i < sortedFields.size() && start > (Integer)fieldStart.get(i); ++i) {
            }
            fieldStart.add(i, start);
            sortedFields.add(i, field);
        }
        return sortedFields;
    }

    private int getDeclarationStartOfField(JavaLexed javaLexed, Field field) {
        return javaLexed.find((BiFunction)LexpressionBuilder.list((BiFunction[])new BiFunction[]{LexpressionBuilder.zeroOrMore((BiFunction)LexpressionBuilder.modifier((int)-17)), LexpressionBuilder.type(), LexpressionBuilder.identifier((String)field.getName())})).fromStart().result().start;
    }

    private void makeFieldsFinal(Field[] fields, JavaLexed javaLexed) {
        for (Field field : fields) {
            if (!NON_FINAL__NON_STATIC.match((Object)field)) continue;
            javaLexed.find(LexpressionBuilder.list((BiFunction[])new BiFunction[]{LexpressionBuilder.zeroOrMore((LexpressionBuilder.GroupNameWrapper)LexpressionBuilder.group((String)"modifiers"), (BiFunction)LexpressionBuilder.modifier((int)-17)), LexpressionBuilder.type((LexpressionBuilder.GroupNameWrapper)LexpressionBuilder.group((String)"fieldType")), LexpressionBuilder.identifier((String)field.getName())})).fromStart().replaceWith(new List[]{Lex.of((String)"final "), javaLexed.group("modifiers"), Lex.of((String)" "), javaLexed.group("fieldType"), Lex.of((String)(" " + field.getName()))});
        }
    }

    private void makeClassFinal(Class<?> klass, JavaLexed javaLexed) {
        if (NOT_FINAL.match(klass)) {
            javaLexed.find(LexpressionBuilder.list((String[])new String[]{"class", klass.getSimpleName()})).fromStart().replaceWith(new List[]{Lex.of((String)("final class " + klass.getSimpleName()))});
        }
    }

    private void generateHashCode(Segment segment, List<Field> fields) {
        segment.write("@Override", new Object[0]);
        segment.write_r("public int hashCode() {", new Object[0]);
        segment.write("return java.util.Objects.hash(%s);", new Object[]{fields.stream().map(Field::getName).collect(Collectors.joining(", "))});
        segment.write_l("}", new Object[0]).newline();
    }

    private void generateEquals(Segment segment, List<Field> fields, Class<?> klass) {
        segment.write("@Override", new Object[0]).write_r("public boolean equals(Object o) {", new Object[0]).write("if (this == o) return true;", new Object[0]).write("if (o == null || getClass() != o.getClass()) return false;", new Object[0]).write("%s that = (%s) o;", new Object[]{klass.getSimpleName(), klass.getSimpleName()}).write("return " + fields.stream().map(Field::getName).map(fn -> "java.util.Objects.equals(that." + fn + ", " + fn + ")").collect(Collectors.joining(" && ")) + ";", new Object[0]).write_l("}", new Object[0]);
    }

    public String mnemonic() {
        return "record";
    }

    public static Builder builder() {
        return new Record().new Builder();
    }

    public Set<String> implementedKeys() {
        return implementedKeys;
    }

    private Config localConfig(CompoundParams params) {
        Config local = new Config();
        local.filter = params.get("filter", this.config.filter);
        return local;
    }

    public class Builder
    implements GeneratorBuilder {
        public Builder filter(String filter) {
            Record.this.config.filter = filter;
            return this;
        }

        public Record build() {
            return Record.this;
        }
    }

    private static class Config {
        private String filter;

        private Config() {
        }
    }
}

