/*
 * Decompiled with CFR 0.152.
 */
package javax0.geci.mapper;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax0.geci.annotations.Generated;
import javax0.geci.api.GeciException;
import javax0.geci.api.GeneratorBuilder;
import javax0.geci.api.Segment;
import javax0.geci.api.Source;
import javax0.geci.core.annotations.AnnotationBuilder;
import javax0.geci.tools.AbstractJavaGenerator;
import javax0.geci.tools.CompoundParams;
import javax0.geci.tools.GeciReflectionTools;
import javax0.geci.tools.reflection.Selector;

@AnnotationBuilder
public class Mapper
extends AbstractJavaGenerator {
    private String configuredMnemonic = "mapper";
    private final Config config = new Config();
    private static final Set<String> implementedKeys = new HashSet<String>(Arrays.asList("factory", "filter", "id"));

    public void process(Source source, Class<?> klass, CompoundParams global) throws Exception {
        String gid = global.get("id");
        try (Segment segment = source.open(gid);){
            if (segment == null) {
                throw new GeciException("There is no segment '" + gid + "'.", new Object[0]);
            }
            String factory = this.localConfig((CompoundParams)global).factory;
            segment.param(new String[]{"mnemonic", this.mnemonic(), "generatedBy", this.config.generatedAnnotation.getCanonicalName(), "class", klass.getSimpleName(), "factory", factory == null ? "new " + klass.getSimpleName() + "()" : factory, "Map", "java.util.Map", "HashMap", "java.util.HashMap"});
            this.generateToMap(segment, source, klass, global);
            this.generateFromMap(segment, source, klass, global);
        }
    }

    private void generateToMap(Segment segment, Source source, Class<?> klass, CompoundParams global) throws Exception {
        Field[] fields = GeciReflectionTools.getAllFieldsSorted(klass);
        segment.write_r(this.getResourceString("tomap.template"), new Object[0]);
        for (Field field : fields) {
            CompoundParams params = GeciReflectionTools.getParameters((AnnotatedElement)field, (String)this.mnemonic());
            Config local = this.localConfig(new CompoundParams(new CompoundParams[]{params, global}));
            if (!Selector.compile((String)local.filter).match((Object)field)) continue;
            String name = field.getName();
            if (this.hasToMap(field.getType())) {
                segment.write("map.put(\"%s\", %s == null ? null : %s.toMap0(cache));", new Object[]{this.field2MapKey(name), name, name});
                continue;
            }
            segment.write("map.put(\"%s\",%s);", new Object[]{this.field2MapKey(name), name});
        }
        segment.write("return map;", new Object[0])._l("}", new Object[0]);
    }

    private String getResourceString(String resource) throws IOException {
        return new String(((Object)((Object)this)).getClass().getResourceAsStream(resource).readAllBytes(), StandardCharsets.UTF_8).replaceAll("\r", "");
    }

    private String field2MapKey(String name) {
        return this.config.field2MapKeyMapper.apply(name);
    }

    private boolean hasToMap(Class<?> type) {
        try {
            type.getDeclaredMethod("toMap", new Class[0]);
            type.getDeclaredMethod("toMap0", Map.class);
            return true;
        }
        catch (NoSuchMethodException ignored) {
            return false;
        }
    }

    private boolean hasFromMap(Class<?> type) {
        try {
            type.getDeclaredMethod("fromMap", Map.class);
            type.getDeclaredMethod("fromMap0", Map.class, Map.class);
            return true;
        }
        catch (NoSuchMethodException ignored) {
            return false;
        }
    }

    private void generateFromMap(Segment segment, Source source, Class<?> klass, CompoundParams global) throws IOException {
        Field[] fields = GeciReflectionTools.getAllFieldsSorted(klass);
        segment.write_r(this.getResourceString("frommap.template"), new Object[0]);
        for (Field field : fields) {
            if (Modifier.isFinal(field.getModifiers())) continue;
            CompoundParams params = GeciReflectionTools.getParameters((AnnotatedElement)field, (String)this.mnemonic());
            Config local = this.localConfig(new CompoundParams(new CompoundParams[]{params, global}));
            if (!Selector.compile((String)local.filter).match((Object)field)) continue;
            String name = field.getName();
            if (this.hasFromMap(field.getType())) {
                segment.write("it.%s = %s.fromMap0(({{Map}}<String,Object>)map.get(\"%s\"),cache);", new Object[]{name, field.getType().getCanonicalName(), this.field2MapKey(name)});
                continue;
            }
            segment.write("it.%s = (%s)map.get(\"%s\");", new Object[]{name, field.getType().getCanonicalName(), this.field2MapKey(name)});
        }
        segment.write("return it;", new Object[0])._l("}", new Object[0]);
    }

    public String mnemonic() {
        return this.configuredMnemonic;
    }

    public static Builder builder() {
        return new Mapper().new Builder();
    }

    public Set<String> implementedKeys() {
        return implementedKeys;
    }

    private Config localConfig(CompoundParams params) {
        Config local = new Config();
        local.factory = params.get("factory", this.config.factory);
        local.field2MapKeyMapper = this.config.field2MapKeyMapper;
        local.filter = params.get("filter", this.config.filter);
        local.generatedAnnotation = this.config.generatedAnnotation;
        return local;
    }

    public class Builder
    implements GeneratorBuilder {
        public Builder factory(String factory) {
            Mapper.this.config.factory = factory;
            return this;
        }

        public Builder field2MapKeyMapper(Function<String, String> field2MapKeyMapper) {
            Mapper.this.config.field2MapKeyMapper = field2MapKeyMapper;
            return this;
        }

        public Builder filter(String filter) {
            Mapper.this.config.filter = filter;
            return this;
        }

        public Builder generatedAnnotation(Class<? extends Annotation> generatedAnnotation) {
            Mapper.this.config.generatedAnnotation = generatedAnnotation;
            return this;
        }

        public Builder mnemonic(String mnemonic) {
            Mapper.this.configuredMnemonic = mnemonic;
            return this;
        }

        public Mapper build() {
            return Mapper.this;
        }
    }

    public static class Config {
        private String filter = "!transient & !static";
        private Class<? extends Annotation> generatedAnnotation = Generated.class;
        private Function<String, String> field2MapKeyMapper = s -> s;
        private String factory = null;
    }
}

