/*
 * Decompiled with CFR 0.152.
 */
package javax0.geci.jdocify;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax0.geci.api.GeciException;
import javax0.geci.api.GeneratorBuilder;
import javax0.geci.api.Source;
import javax0.geci.core.annotations.AnnotationBuilder;
import javax0.geci.javacomparator.LexicalElement;
import javax0.geci.lexeger.JavaLexed;
import javax0.geci.tools.AbstractJavaGenerator;
import javax0.geci.tools.CompoundParams;
import javax0.geci.tools.GeciReflectionTools;

@AnnotationBuilder
public class Jdocify
extends AbstractJavaGenerator {
    final Map<String, String> defines = new HashMap<String, String>();
    final int CODE_LENGTH = "{@code".length();
    private static final String HTML_COMMENT_START = "<!--";
    private static final int HTML_COMMENT_START_LEN = "<!--".length();
    private static final String HTML_COMMENT_END = "-->";
    private static final int HTML_COMMENT_END_LEN = "-->".length();
    private static final String VARIABLE_REGEX = "[A-Z_][A-Z0-9_]*";
    private static final Pattern VARIABLE_PATTERN = Pattern.compile("[A-Z_][A-Z0-9_]*");
    private static final Pattern DEFINE_PATTERN = Pattern.compile("DEFINE\\s+([A-Z_][A-Z0-9_]*)\\s*=(.*)");
    private static final String COMMENT_CODE_START = "<!--CODE";
    private static final String REF_END = "<!--/-->";
    private static final int REF_END_LEN = "<!--/-->".length();
    private String configuredMnemonic = "jdocify";
    private final Config config = new Config();
    private static final Set<String> implementedKeys = new HashSet<String>(Arrays.asList("id"));

    protected boolean processAllClasses() {
        return this.config.processAllClasses;
    }

    private boolean modifyDefinesInComment(StringBuilder comment) {
        State state = new State();
        state.pos = 0;
        state.comment = comment;
        while ((state.commentStart = state.comment.indexOf(HTML_COMMENT_START, state.pos)) > -1) {
            state.commentEnd = state.comment.indexOf(HTML_COMMENT_END, state.commentStart);
            this.findCommentEnd(state);
            String variable = state.comment.substring(state.commentStart + HTML_COMMENT_START_LEN, state.commentEnd);
            if (VARIABLE_PATTERN.matcher(variable).matches()) {
                if (this.defines.containsKey(variable)) {
                    state.contentStart = state.commentEnd + HTML_COMMENT_END_LEN;
                    state.contentEnd = state.comment.indexOf(REF_END, state.contentStart);
                    state.newContent = this.defines.get(variable);
                    if (this.contentNeedsReplacement(state)) {
                        this.replaceOldContentWithNew(state);
                    }
                    state.pos = state.contentEnd + REF_END_LEN;
                    continue;
                }
                throw new GeciException("The variable '" + variable + "' was referenced in JavaDoc HTML comment, but was not DEFINEd", new Object[0]);
            }
            state.pos = state.commentEnd + HTML_COMMENT_END_LEN;
        }
        return state.changed;
    }

    private boolean modifyCodesInComment(StringBuilder comment, Class<?> klass) {
        State state = new State();
        state.comment = comment;
        state.changed = false;
        state.pos = 0;
        state.lenCODEStart = COMMENT_CODE_START.length();
        state.lenCODEEnd = HTML_COMMENT_END.length();
        while ((state.commentStart = state.comment.indexOf(COMMENT_CODE_START, state.pos)) > -1) {
            this.findCommentEnd(state);
            this.assertCodeAndCommentSyntax(state);
            this.getFieldNameAndValue(klass, state);
            this.getTemplate(state);
            this.getCurrentContentPositions(state);
            this.getNewContent(state);
            if (this.contentNeedsReplacement(state)) {
                this.replaceOldContentWithNew(state);
            }
            state.pos = state.contentEnd + 1;
        }
        return state.changed;
    }

    private void findCommentEnd(State state) {
        state.commentEnd = state.comment.indexOf(HTML_COMMENT_END, state.commentStart);
    }

    private boolean contentNeedsReplacement(State state) {
        return !this.areEqual(state.comment.substring(state.contentStart, state.contentEnd), state.newContent);
    }

    private void replaceOldContentWithNew(State state) {
        state.comment.delete(state.contentStart, state.contentEnd).insert(state.contentStart, state.newContent);
        state.changed = true;
    }

    private void getCurrentContentPositions(State state) {
        state.contentStart = this.findPosition(state.comment, state.commentEnd + state.lenCODEEnd + this.CODE_LENGTH, state.comment.length(), Jdocify::separatorCharacter);
        Jdocify.asserts(state.contentStart == state.comment.length(), "{@code is not finished before the end of the comment.");
        state.contentEnd = this.findCodeEnd(state.comment, state.contentStart, state.comment.length());
        Jdocify.asserts(state.contentEnd == state.comment.length(), "{@code is not closed in a JavaDoc comment following a <!--CODE ...-->");
    }

    private void getTemplate(State state) {
        state.templateStart = this.findPosition(state.comment, state.fieldNameEnd, state.commentEnd, Jdocify::separatorCharacter);
        state.template = state.templateStart < state.commentEnd ? state.comment.substring(state.templateStart, state.commentEnd) : state.fieldName;
    }

    private void assertCodeAndCommentSyntax(State state) {
        Jdocify.asserts(state.commentEnd == -1, "There is no --> after the <!--CODE");
        Jdocify.asserts(state.commentEnd + state.lenCODEEnd + this.CODE_LENGTH >= state.comment.length(), "There is no {@code ... following the <!--CODE ...-->");
    }

    private void getFieldNameAndValue(Class<?> klass, State state) {
        state.fieldNameStart = this.findPosition(state.comment, state.commentStart + state.lenCODEStart, state.commentEnd, Jdocify::separatorCharacter);
        state.fieldNameEnd = this.findPosition(state.comment, state.fieldNameStart + 1, state.commentEnd, ch -> !Jdocify.separatorCharacter(ch.charValue()));
        state.fieldName = state.comment.substring(state.fieldNameStart, state.fieldNameEnd);
        state.fieldValue = Jdocify.fetchFieldValue(klass, state.fieldName);
        Jdocify.asserts(state.fieldValue == null, "There is a <!--CODE" + state.fieldName + "--> reference, but the field cannot be found, is not static or not final.");
    }

    private static void asserts(boolean flag, String message) {
        if (flag) {
            throw new GeciException(message, new Object[0]);
        }
    }

    private void getNewContent(State state) {
        String separator = state.contentStart > 0 && !Character.isWhitespace(state.comment.charAt(state.contentStart - 1)) ? " " : "";
        state.newContent = separator + state.template.replace(state.fieldName, state.fieldValue);
        Jdocify.asserts(!this.isBalanced(state.newContent), "The value to be inserted after {@code is not balanced, has different number of { and } characters. The actual value is: '" + state.newContent + "'");
    }

    private boolean areEqual(String code, String replacement) {
        int ci = 0;
        int ri = 0;
        while (ci < code.length() && ri < replacement.length()) {
            if (code.substring(ci).startsWith("\n * ")) {
                if (!Character.isWhitespace(replacement.charAt(ri))) {
                    return false;
                }
                ++ri;
                ci += 4;
                continue;
            }
            if (Character.isWhitespace(code.charAt(ci)) && Character.isWhitespace(replacement.charAt(ri))) {
                ++ri;
                ++ci;
                continue;
            }
            if (code.charAt(ci) == replacement.charAt(ri)) {
                ++ci;
                ++ri;
                continue;
            }
            return false;
        }
        return ci == code.length() && ri == replacement.length();
    }

    private int findPosition(StringBuilder comment, int start, int commentEnd, Predicate<Character> isSepa) {
        int pos;
        for (pos = start; pos < commentEnd && isSepa.test(Character.valueOf(comment.charAt(pos))); ++pos) {
        }
        return pos;
    }

    private boolean isBalanced(String newContent) {
        int open = 0;
        int close = 0;
        for (char ch : newContent.toCharArray()) {
            if (ch == '{') {
                ++open;
            }
            if (ch != '}') continue;
            ++close;
        }
        return open == close;
    }

    private int findCodeEnd(StringBuilder comment, int start, int commentEnd) {
        int codeEnd;
        int braceCounter = 0;
        for (codeEnd = start; codeEnd < commentEnd && (braceCounter > 0 || comment.charAt(codeEnd) != '}'); ++codeEnd) {
            if (comment.charAt(codeEnd) == '}') {
                --braceCounter;
            }
            if (comment.charAt(codeEnd) != '{') continue;
            ++braceCounter;
        }
        return codeEnd;
    }

    private static String fetchFieldValue(Class<?> klass, String fieldName) {
        try {
            Field field = GeciReflectionTools.getField(klass, (String)fieldName);
            int modifiers = field.getModifiers();
            if (Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers)) {
                field.setAccessible(true);
                return "" + field.get(null);
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static boolean separatorCharacter(char ch) {
        return Character.isWhitespace(ch) || ch == '*';
    }

    private void define(String lexeme) {
        Matcher m = DEFINE_PATTERN.matcher(lexeme.substring(2));
        if (m.matches()) {
            this.defines.put(m.group(1), m.group(2));
        }
    }

    public void process(Source source, Class<?> klass, CompoundParams global) {
        this.defines.clear();
        try (JavaLexed lexed = new JavaLexed(source);){
            for (LexicalElement lex : lexed.lexicalElements()) {
                if (lex.getType() != LexicalElement.Type.COMMENT) continue;
                if (lex.getLexeme().startsWith("//")) {
                    this.define(lex.getLexeme());
                    continue;
                }
                StringBuilder comment = new StringBuilder(lex.getLexeme());
                boolean code = this.modifyCodesInComment(comment, klass);
                boolean def = this.modifyDefinesInComment(comment);
                if (!code && !def) continue;
                lex.setLexeme(comment.toString());
            }
        }
    }

    public String mnemonic() {
        return this.configuredMnemonic;
    }

    public static Builder builder() {
        return new Jdocify().new Builder();
    }

    public Set<String> implementedKeys() {
        return implementedKeys;
    }

    private Config localConfig(CompoundParams params) {
        Config local = new Config();
        local.processAllClasses = this.config.processAllClasses;
        return local;
    }

    public class Builder
    implements GeneratorBuilder {
        public Builder processAllClasses(boolean processAllClasses) {
            Jdocify.this.config.processAllClasses = processAllClasses;
            return this;
        }

        public Builder mnemonic(String mnemonic) {
            Jdocify.this.configuredMnemonic = mnemonic;
            return this;
        }

        public Jdocify build() {
            return Jdocify.this;
        }
    }

    private static class State {
        int pos;
        int lenCODEStart;
        int lenCODEEnd;
        int commentStart;
        int fieldNameStart;
        int fieldNameEnd;
        int templateStart;
        int contentStart;
        int contentEnd;
        int commentEnd;
        String template;
        String fieldName;
        String fieldValue;
        String newContent;
        boolean changed;
        StringBuilder comment;

        private State() {
        }
    }

    private static class Config {
        private boolean processAllClasses = false;

        private Config() {
        }
    }
}

