/*
 * Decompiled with CFR 0.152.
 */
package javax0.geci.iterate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax0.geci.api.GeciException;
import javax0.geci.api.GeneratorBuilder;
import javax0.geci.api.Segment;
import javax0.geci.api.Source;
import javax0.geci.core.annotations.AnnotationBuilder;
import javax0.geci.templated.Context;
import javax0.geci.templated.Triplet;
import javax0.geci.tools.AbstractJavaGenerator;
import javax0.geci.tools.CompoundParams;
import javax0.geci.tools.Untabber;

@AnnotationBuilder
@javax0.geci.core.annotations.Iterate
public class Iterate
extends AbstractJavaGenerator {
    private static final Pattern editorFold = Pattern.compile("\\s*//\\s*<\\s*editor-fold.*?\\sid\\s*=\\s*\"(.*?)\".*");
    private String configuredMnemonic = "iterate";
    private final Config config = new Config();
    private static final Set<String> implementedKeys = new HashSet<String>(Arrays.asList("editorFoldLine", "escapeLine", "loopLine", "sep1", "sep1Line", "sep2", "sep2Line", "skipLine", "templateEndLine", "templateLine", "id"));

    private List<Template> collectTemplates(Source source, Config local) {
        ArrayList<Template> templates = new ArrayList<Template>();
        Pattern templateLine = Pattern.compile(local.templateLine);
        Pattern templateEndLine = Pattern.compile(local.templateEndLine);
        Pattern loopLine = Pattern.compile(local.loopLine);
        Pattern editorFoldLine = Pattern.compile(local.editorFoldLine);
        Pattern sep1Line = Pattern.compile(local.sep1Line);
        Pattern sep2Line = Pattern.compile(local.sep2Line);
        Pattern escapeLine = Pattern.compile(local.escapeLine);
        Pattern skipLine = Pattern.compile(local.skipLine);
        Template template = null;
        Template danglet = null;
        int lineIndex = 0;
        boolean escape = false;
        boolean skip = false;
        for (String line : source.getLines()) {
            Matcher editorFoldMatcher;
            ++lineIndex;
            if (template != null) {
                if (skip) {
                    skip = false;
                    continue;
                }
                if (!escape) {
                    if (this.isLoopLine(source, loopLine, template, line, local) || this.isEditorFoldIdLine(editorFoldLine, template, line)) continue;
                    if (this.isTemplateEndLine(templates, templateEndLine, template, line)) {
                        danglet = this.getDanglingTemplate(template);
                        template = null;
                        continue;
                    }
                    if (this.isSep1(template, sep1Line, line) || this.isSep2(template, sep2Line, line)) continue;
                    if (escapeLine.matcher(line).matches()) {
                        escape = true;
                        continue;
                    }
                    if (skipLine.matcher(line).matches()) {
                        skip = true;
                        continue;
                    }
                }
                escape = false;
                template.lines.add(line);
                continue;
            }
            if (templateLine.matcher(line).matches()) {
                template = new Template();
                template.startLine = lineIndex;
                continue;
            }
            if (danglet == null || !(editorFoldMatcher = editorFold.matcher(line)).matches()) continue;
            danglet.editorFold = editorFoldMatcher.group(1);
            danglet = null;
        }
        return templates;
    }

    private Template getDanglingTemplate(Template template) {
        Template danglet = template.editorFold == null ? template : null;
        return danglet;
    }

    private boolean isSep1(Template template, Pattern sep1Line, String line) {
        Matcher sep1LineMatcher = sep1Line.matcher(line);
        if (sep1LineMatcher.matches()) {
            template.sep1 = Pattern.quote(sep1LineMatcher.group(1));
            return true;
        }
        return false;
    }

    private boolean isSep2(Template template, Pattern sep2Line, String line) {
        Matcher sep2LineMatcher = sep2Line.matcher(line);
        if (sep2LineMatcher.matches()) {
            template.sep2 = Pattern.quote(sep2LineMatcher.group(1));
            return true;
        }
        return false;
    }

    private boolean isTemplateEndLine(ArrayList<Template> templates, Pattern templateEndLine, Template template, String line) {
        if (templateEndLine.matcher(line).matches()) {
            template.lines = Untabber.untab(template.lines);
            templates.add(template);
            return true;
        }
        return false;
    }

    private boolean isEditorFoldIdLine(Pattern editorFoldLine, Template template, String line) {
        Matcher editorFoldLineMatcher = editorFoldLine.matcher(line);
        if (editorFoldLineMatcher.matches()) {
            template.editorFold = editorFoldLineMatcher.group(1);
            return true;
        }
        return false;
    }

    private boolean isLoopLine(Source source, Pattern loopLine, Template template, String line, Config local) {
        Matcher loopMatcher = loopLine.matcher(line);
        if (loopMatcher.matches()) {
            this.collectValues(template, loopMatcher.group(1), source, local);
            return true;
        }
        return false;
    }

    private void collectValues(Template template, String loopString, Source source, Config local) {
        String sep1 = template.sep1 != null ? template.sep1 : Pattern.quote(local.sep1);
        String sep2 = template.sep2 != null ? template.sep2 : Pattern.quote(local.sep2);
        int eqIndex = loopString.indexOf(61);
        if (eqIndex == -1) {
            throw new GeciException("LOOP line cannot be parsed in template that starts at\n" + Iterate.errorLocation(template, source), new Object[0]);
        }
        String keysCsv = loopString.substring(0, eqIndex).trim();
        String[] keys = keysCsv.split(sep1);
        String[] valuesCsvs = loopString.substring(eqIndex + 1).trim().split(sep2);
        if (template.values == null) {
            template.values = new ArrayList<Map<String, String>>();
        }
        for (String valuesCsv : valuesCsvs) {
            String[] values = valuesCsv.split(sep1);
            if (values.length != keys.length) {
                throw new GeciException("Template has different number of keys and values as in\nkeys:'" + keysCsv + "' values:'" + valuesCsv + "\n" + Iterate.errorLocation(template, source), new Object[0]);
            }
            HashMap<String, String> map = new HashMap<String, String>();
            for (int i = 0; i < keys.length; ++i) {
                map.put(keys[i], values[i]);
            }
            template.values.add(map);
        }
    }

    private static String errorLocation(Template template, Source source) {
        return source.getAbsoluteFile() + ":" + template.startLine;
    }

    public void process(Source source, Class<?> klass, CompoundParams global) throws Exception {
        Config local = this.localConfig(global);
        List<Template> templates = this.collectTemplates(source, local);
        Triplet ctx = new Triplet();
        for (Template template : templates) {
            if (template.editorFold == null) {
                throw new GeciException("Template staring on the line " + source.getAbsoluteFile() + ":" + template.startLine + " does not have an editor fold specified.", new Object[0]);
            }
            Segment segment = source.open(template.editorFold);
            try {
                if (segment == null) {
                    throw new GeciException("Segment " + template.editorFold + " does not exist", new Object[0]);
                }
                for (Map<String, String> map : template.values) {
                    for (Map.Entry<String, String> entry : map.entrySet()) {
                        segment.param(new String[]{entry.getKey(), entry.getValue()});
                    }
                    if (local.define != null) {
                        ctx.triplet(source, klass, segment);
                        local.define.accept(ctx);
                    }
                    for (String s : template.lines) {
                        segment.write(s, new Object[0]);
                    }
                }
            }
            finally {
                if (segment == null) continue;
                segment.close();
            }
        }
    }

    public String mnemonic() {
        return this.configuredMnemonic;
    }

    public static Builder builder() {
        return new Iterate().new Builder();
    }

    public Set<String> implementedKeys() {
        return implementedKeys;
    }

    private Config localConfig(CompoundParams params) {
        Config local = new Config();
        local.define = this.config.define;
        local.editorFoldLine = params.get("editorFoldLine", this.config.editorFoldLine);
        local.escapeLine = params.get("escapeLine", this.config.escapeLine);
        local.loopLine = params.get("loopLine", this.config.loopLine);
        local.sep1 = params.get("sep1", this.config.sep1);
        local.sep1Line = params.get("sep1Line", this.config.sep1Line);
        local.sep2 = params.get("sep2", this.config.sep2);
        local.sep2Line = params.get("sep2Line", this.config.sep2Line);
        local.skipLine = params.get("skipLine", this.config.skipLine);
        local.templateEndLine = params.get("templateEndLine", this.config.templateEndLine);
        local.templateLine = params.get("templateLine", this.config.templateLine);
        return local;
    }

    public class Builder
    implements GeneratorBuilder {
        public Builder define(Consumer<Context> define) {
            Iterate.this.config.define = define;
            return this;
        }

        public Builder editorFoldLine(String editorFoldLine) {
            Iterate.this.config.editorFoldLine = editorFoldLine;
            return this;
        }

        public Builder escapeLine(String escapeLine) {
            Iterate.this.config.escapeLine = escapeLine;
            return this;
        }

        public Builder loopLine(String loopLine) {
            Iterate.this.config.loopLine = loopLine;
            return this;
        }

        public Builder sep1(String sep1) {
            Iterate.this.config.sep1 = sep1;
            return this;
        }

        public Builder sep1Line(String sep1Line) {
            Iterate.this.config.sep1Line = sep1Line;
            return this;
        }

        public Builder sep2(String sep2) {
            Iterate.this.config.sep2 = sep2;
            return this;
        }

        public Builder sep2Line(String sep2Line) {
            Iterate.this.config.sep2Line = sep2Line;
            return this;
        }

        public Builder skipLine(String skipLine) {
            Iterate.this.config.skipLine = skipLine;
            return this;
        }

        public Builder templateEndLine(String templateEndLine) {
            Iterate.this.config.templateEndLine = templateEndLine;
            return this;
        }

        public Builder templateLine(String templateLine) {
            Iterate.this.config.templateLine = templateLine;
            return this;
        }

        public Builder mnemonic(String mnemonic) {
            Iterate.this.configuredMnemonic = mnemonic;
            return this;
        }

        public Iterate build() {
            return Iterate.this;
        }
    }

    private static class Template {
        private String sep1 = null;
        private String sep2 = null;
        private int startLine;
        private String editorFold = null;
        private List<String> lines = new ArrayList<String>();
        private List<Map<String, String>> values;

        private Template() {
        }
    }

    private static class Config {
        private String templateLine = "\\s*(?:/\\*\\s*)?TEMPLATE\\s*";
        private String loopLine = "\\s*LOOP\\s+(.*)";
        private String editorFoldLine = "\\s*EDITOR-FOLD-ID\\s+(\\w[\\w\\d]*)\\s*";
        private String templateEndLine = "\\s*\\*/\\s*";
        private String sep1 = ",";
        private String sep2 = "|";
        private String sep1Line = "\\s*SEP1\\s+([^\\s]*)\\s*";
        private String sep2Line = "\\s*SEP2\\s+([^\\s]*)\\s*";
        private String escapeLine = "\\s*(?://)?\\s*ESCAPE\\s*";
        private String skipLine = "\\s*(?://)?\\s*SKIP\\s*";
        private Consumer<Context> define = null;

        private Config() {
        }
    }
}

