/*
 * Decompiled with CFR 0.152.
 */
package javax0.geci.fluent.tree;

import java.util.List;
import java.util.stream.Collectors;
import javax0.geci.fluent.tree.Node;
import javax0.geci.fluent.tree.Terminal;

public final class Tree
extends Node {
    private final List<Node> list;

    public Tree(int modifier, List<Node> tree) {
        super(modifier);
        this.list = tree;
    }

    public List<Node> getList() {
        return this.list;
    }

    @Override
    public Node clone(int modifier) {
        Tree tree = new Tree(modifier, this.list);
        tree.setName(this.getName());
        return tree;
    }

    public Node clone(int modifier, List<Node> newList) {
        Tree tree = new Tree(modifier, newList);
        tree.setName(this.getName());
        return tree;
    }

    @Override
    public String toString() {
        if (this.getModifier() == 8 || this.getModifier() == 16) {
            return "(" + this.list.stream().map(Node::toString).collect(Collectors.joining("|")) + ")";
        }
        if (this.list.size() == 1) {
            return this.list.stream().map(Node::toString).collect(Collectors.joining(" ")) + super.toString();
        }
        return "(" + this.list.stream().map(Node::toString).collect(Collectors.joining(" ")) + ")" + super.toString();
    }

    @Override
    public int compareTo(Node node) {
        if (node instanceof Terminal) {
            return 1;
        }
        Tree tree = (Tree)node;
        if (tree.getList().size() > this.getList().size()) {
            return 1;
        }
        if (tree.getList().size() < this.getList().size()) {
            return -1;
        }
        for (int i = 0; i < this.getList().size(); ++i) {
            int res = this.getList().get(i).compareTo(tree.getList().get(i));
            if (res == 0) continue;
            return res;
        }
        return 0;
    }
}

