/*
 * Decompiled with CFR 0.152.
 */
package javax0.geci.fluent.syntax;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax0.geci.api.GeciException;
import javax0.geci.fluent.tree.FluentNodeCreator;
import javax0.geci.fluent.tree.Node;
import javax0.geci.fluent.tree.Terminal;
import javax0.geci.fluent.tree.Tree;
import javax0.geci.tools.syntax.Lexeme;
import javax0.geci.tools.syntax.Lexer;

public class Syntax {
    private final Lexer lexer;
    private final FluentNodeCreator nodeCreator;

    public Syntax(Lexer lexer, FluentNodeCreator nodeCreator) {
        this.lexer = lexer;
        this.nodeCreator = nodeCreator;
    }

    private static boolean isOneOrMore(List<Node> nodes) {
        if (nodes.size() != 2) {
            return false;
        }
        if (nodes.get(0).getModifier() != 1 || nodes.get(1).getModifier() != 4) {
            return false;
        }
        if (nodes.get(0).getClass() != nodes.get(1).getClass()) {
            return false;
        }
        if (nodes.get(0) instanceof Terminal) {
            Terminal t0 = (Terminal)nodes.get(0);
            Terminal t1 = (Terminal)nodes.get(1);
            return t0.getMethod().equals(t1.getMethod());
        }
        Tree t0 = (Tree)nodes.get(0);
        Tree t1 = (Tree)nodes.get(1);
        return t0.getList() == t1.getList();
    }

    @SafeVarargs
    private static <T> List<T> listOf(T ... ts) {
        return new ArrayList<T>(Arrays.asList(ts));
    }

    public List<Node> expression() {
        List<Node> nodes = this.subExpression();
        if (this.lexer.peek().type != Lexeme.Type.EOF) {
            throw new GeciException("Extra characters at the end: '" + this.lexer.rest() + "'", new Object[0]);
        }
        return nodes;
    }

    public List<Node> subExpression() {
        ArrayList<Node> nodes = new ArrayList<Node>(this.alternate());
        while (this.lexer.peek().type == Lexeme.Type.SPACE) {
            this.lexer.get();
            nodes.addAll(this.alternate());
        }
        return nodes;
    }

    public List<Node> alternate() {
        List<Node> first = this.simple();
        if (this.lexer.peek().type != Lexeme.Type.SYMBOL || !this.lexer.peek().string.equals("|")) {
            return first;
        }
        ArrayList<Node> nodes = new ArrayList<Node>();
        nodes.add(this.box(first));
        while (this.lexer.peek().type == Lexeme.Type.SYMBOL && this.lexer.peek().string.equals("|")) {
            this.lexer.get();
            nodes.add(this.box(this.simple()));
        }
        if (nodes.size() == 1) {
            return nodes;
        }
        return Syntax.listOf(this.nodeCreator.oneOfNode(nodes));
    }

    public List<Node> simple() {
        List<Node> nodes = this.terminal();
        Lexeme lexeme = this.lexer.peek();
        if (lexeme.type == Lexeme.Type.SYMBOL) {
            String modifierCharacter;
            Node node = this.box(nodes);
            switch (modifierCharacter = lexeme.string) {
                case "*": {
                    this.lexer.get();
                    if (Syntax.isOneOrMore(nodes)) {
                        return Syntax.listOf(this.box(nodes.get(0), 4));
                    }
                    return Syntax.listOf(this.box(node, 4));
                }
                case "?": {
                    this.lexer.get();
                    if (Syntax.isOneOrMore(nodes)) {
                        return Syntax.listOf(this.box(nodes.get(0), 4));
                    }
                    return Syntax.listOf(this.box(node, 2));
                }
                case "+": {
                    this.lexer.get();
                    if (Syntax.isOneOrMore(nodes)) {
                        return nodes;
                    }
                    if (node.getModifier() == 2) {
                        return Syntax.listOf(node.clone(4));
                    }
                    if (node.getModifier() == 4) {
                        return nodes;
                    }
                    return Syntax.listOf(node, this.box(node, 4));
                }
            }
        }
        return nodes;
    }

    public List<Node> terminal() {
        if (this.lexer.peek().type == Lexeme.Type.WORD) {
            return Syntax.listOf(this.nodeCreator.oneNode(this.lexer.get().string));
        }
        if (this.lexer.peek().type == Lexeme.Type.SYMBOL && this.lexer.peek().string.equals("(")) {
            this.lexer.get();
            List<Node> nodes = this.subExpression();
            if (this.lexer.peek().type != Lexeme.Type.SYMBOL || !this.lexer.peek().string.equals(")")) {
                throw new GeciException("Fluent expression syntax error after ( ... ) missing closing parenthesis at '" + this.lexer.rest() + "'", new Object[0]);
            }
            this.lexer.get();
            return nodes;
        }
        throw new GeciException("Fluent expression syntax error at '" + this.lexer.rest() + "'", new Object[0]);
    }

    private Node box(List<Node> nodes) {
        Node node = nodes.size() == 1 ? nodes.get(0) : this.nodeCreator.oneNode(nodes);
        return node;
    }

    private Node box(Node node, int modifier) {
        if (node.getModifier() == 8 || node.getModifier() == 16) {
            return this.nodeCreator.oneNode(Syntax.listOf(node)).clone(modifier);
        }
        if (node.getModifier() == 4) {
            return node;
        }
        return node.clone(modifier);
    }
}

