/*
 * Decompiled with CFR 0.152.
 */
package javax0.geci.fluent.internal;

import java.util.HashSet;
import java.util.List;
import javax0.geci.api.GeciException;
import javax0.geci.fluent.internal.MethodCollection;
import javax0.geci.fluent.tree.Node;
import javax0.geci.fluent.tree.Terminal;
import javax0.geci.fluent.tree.Tree;

public class NodeTypeCalculator {
    private final MethodCollection methods;

    public static NodeTypeCalculator from(MethodCollection methods) {
        return new NodeTypeCalculator(methods);
    }

    public NodeTypeCalculator(MethodCollection methods) {
        this.methods = methods;
    }

    String getReturnType(Node lastNode) {
        if (lastNode instanceof Terminal) {
            return this.getReturnType((Terminal)lastNode);
        }
        return this.getReturnType((Tree)lastNode);
    }

    private String getReturnType(Terminal lastNode) {
        if (lastNode.getModifier() == 1) {
            this.methods.exitNode(lastNode.getMethod());
            return this.methods.get(lastNode.getMethod()).getGenericReturnType().getTypeName();
        }
        if (lastNode.getModifier() == 8) {
            throw new GeciException("Inconsistent fluent tree. The last node is ONE_OF terminal.", new Object[0]);
        }
        if (lastNode.getModifier() == 4) {
            throw new GeciException("The last call can not be zeroOrMore(\"" + lastNode.getMethod() + "\") in the fluent structure.", new Object[0]);
        }
        if (lastNode.getModifier() == 2) {
            throw new GeciException("The last call can not be optional(\"" + lastNode.getMethod() + "\") in the fluent structure.", new Object[0]);
        }
        throw new GeciException("Inconsistent fluent tree, last method modifier is " + lastNode.getModifier(), new Object[0]);
    }

    private String getReturnType(Tree lastNode) {
        if (lastNode.getModifier() == 1) {
            List<Node> list = lastNode.getList();
            return this.getReturnType(list.get(list.size() - 1));
        }
        if (lastNode.getModifier() == 8 || lastNode.getModifier() == 16) {
            HashSet<String> returnTypes = new HashSet<String>();
            String returnType = "";
            List<Node> list = lastNode.getList();
            for (Node node : list) {
                returnType = this.getReturnType(node);
                returnTypes.add(returnType);
            }
            if (returnTypes.size() != 1) {
                if (returnTypes.size() == 0) {
                    throw new GeciException("The structure has no return type", new Object[0]);
                }
                throw new GeciException("The structure has several return types:\n" + String.join((CharSequence)"\n", returnTypes), new Object[0]);
            }
            return returnType;
        }
        if (lastNode.getModifier() == 4) {
            throw new GeciException("The last call can not be zeroOrMore(substructure) in the fluent structure.", new Object[0]);
        }
        if (lastNode.getModifier() == 2) {
            throw new GeciException("The last call can not be optional(substructure) in the fluent structure.", new Object[0]);
        }
        throw new GeciException("Inconsistent fluent tree, last node structure modifier is " + lastNode.getModifier(), new Object[0]);
    }
}

