/*
 * Decompiled with CFR 0.152.
 */
package javax0.geci.fluent.internal;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax0.geci.api.GeciException;

public class MethodCollection {
    private final Class<?> klass;
    private final Set<Method> methodSet;
    private final Map<String, MethodData> methodMap;
    private final Map<String, String> typeMapping = new HashMap<String, String>();
    private final Map<String, Boolean> isMultiple = new HashMap<String, Boolean>();
    private final boolean wrapperIfIsNeeded;

    public MethodCollection(Class<?> klass) {
        this.klass = klass;
        this.methodSet = this.collectMethods();
        this.wrapperIfIsNeeded = this.needsWrapperInterface();
        Set<String> types = this.allArgumentTypes();
        this.collectDuplicates(types);
        this.buildTypeMapping(types);
        this.methodMap = this.collect();
    }

    private static Stream<String> extractTypes(Type type) {
        return Arrays.stream(type.getTypeName().split("[,<>]"));
    }

    private static String simple(String type) {
        return type.replaceAll("^(\\w+\\.)*", "");
    }

    private static MethodData methodData(Method method) {
        MethodData md = new MethodData();
        md.method = method;
        return md;
    }

    public boolean needWrapperInterface() {
        return this.wrapperIfIsNeeded;
    }

    public Set<String> methodSignatures() {
        return this.methodMap.entrySet().stream().filter(e -> ((MethodData)e.getValue()).referenced).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public Method get(String name) {
        MethodData md = this.get0(name);
        if (md == null) {
            return null;
        }
        md.referenced = true;
        return md.method;
    }

    public Boolean isExitNode(String name) {
        MethodData md = this.get0(name);
        if (md == null) {
            return null;
        }
        return md.isExitNodeMethod;
    }

    public void include(String method) {
        this.clude(method, true);
    }

    public void exclude(String method) {
        this.clude(method, false);
    }

    private void clude(String method, boolean b) {
        MethodData md = this.get0(method);
        if (md == null) {
            throw new GeciException("Method '" + method + "' does not exist, can not be exlcuded from the fluent interface.", new Object[0]);
        }
        md.isFluent = b;
    }

    public Boolean isFluentNode(String name) {
        MethodData md = this.get0(name);
        if (md == null) {
            return null;
        }
        return md.isFluent;
    }

    public void exitNode(String name) {
        MethodData md = this.get0(name);
        if (md == null) {
            throw new IllegalArgumentException("The method " + name + " is signalled as exit node, but it is not defined.");
        }
        md.isExitNodeMethod = true;
    }

    private MethodData get0(String name) {
        if (name.contains("(")) {
            String key = this.normalize(name);
            return this.methodMap.get(key);
        }
        MethodData methodData = null;
        String start = name + "(";
        boolean found = false;
        for (String signature : this.methodMap.keySet()) {
            if (!signature.startsWith(start)) continue;
            if (found) {
                throw new GeciException("The method name '" + name + "' is ambiguous.", new Object[0]);
            }
            methodData = this.methodMap.get(signature);
            found = true;
        }
        return methodData;
    }

    private String normalize(String s) {
        String norming = s;
        for (String type : this.typeMapping.keySet()) {
            norming = norming.replace(type, this.typeMapping.get(type));
        }
        return norming;
    }

    private String signature(Method method) {
        String arglist = Arrays.stream(method.getGenericParameterTypes()).map(t -> this.normalize(t.getTypeName())).collect(Collectors.joining(","));
        String exceptionlist = Arrays.stream(method.getGenericExceptionTypes()).map(t -> this.normalize(t.getTypeName())).collect(Collectors.joining(","));
        return method.getName() + "(" + arglist + ")" + (String)(exceptionlist.length() == 0 ? "" : " throws " + exceptionlist);
    }

    private Set<Method> collectMethods() {
        HashSet set = Arrays.stream(this.klass.getMethods()).filter(this::isNeeded).collect(Collectors.toCollection(HashSet::new));
        if (this.klass != Object.class) {
            set.addAll(Arrays.stream(this.klass.getDeclaredMethods()).filter(this::isNeeded).collect(Collectors.toSet()));
        }
        return set;
    }

    private boolean needsWrapperInterface() {
        return Arrays.stream(this.klass.getMethods()).filter(this::isNeeded).map(Method::getParameterTypes).flatMap(Arrays::stream).anyMatch(parameterClass -> parameterClass == this.klass);
    }

    private boolean isNeeded(Method method) {
        return (method.getModifiers() & 8) == 0 && (method.getDeclaringClass() != Object.class || this.klass == Object.class);
    }

    private Set<String> allArgumentTypes() {
        return this.methodSet.stream().map(Method::getGenericParameterTypes).flatMap(Arrays::stream).flatMap(MethodCollection::extractTypes).collect(Collectors.toSet());
    }

    private void collectDuplicates(Set<String> types) {
        this.isMultiple.clear();
        types.forEach(type -> {
            String s = MethodCollection.simple(type);
            this.isMultiple.put(s, this.isMultiple.containsKey(s));
        });
    }

    private void buildTypeMapping(Set<String> types) {
        this.typeMapping.clear();
        this.typeMapping.putAll(types.stream().collect(Collectors.toMap(Function.identity(), type -> this.isMultiple.get(MethodCollection.simple(type)) != false ? type : MethodCollection.simple(type))));
    }

    private Map<String, MethodData> collect() {
        return this.methodSet.stream().collect(Collectors.toMap(this::signature, MethodCollection::methodData));
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("{\n");
        for (String key : new TreeSet<String>(this.methodMap.keySet())) {
            s.append("  \"").append(key).append("\" -> ").append(this.methodMap.get((Object)key).method.getName()).append("\n");
        }
        s.append("}");
        return s.toString();
    }

    private static class MethodData {
        Method method;
        boolean isExitNodeMethod = false;
        boolean isFluent = true;
        boolean referenced = false;

        private MethodData() {
        }
    }
}

