/*
 * Decompiled with CFR 0.152.
 */
package javax0.geci.fluent.internal;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax0.geci.fluent.internal.MethodCollection;

public class InterfaceSet {
    static final String WRAPPER_INTERFACE_NAME = "WrapperInterface";
    private final Set<String> interfaceSet = new HashSet<String>();
    private boolean lastWhen;

    private InterfaceSet(boolean needsWrapperInterface) {
        if (needsWrapperInterface) {
            this.interfaceSet.add(WRAPPER_INTERFACE_NAME);
        }
    }

    public static InterfaceSet builderFor(MethodCollection methods) {
        return new InterfaceSet(methods.needWrapperInterface());
    }

    public InterfaceSet set(Set<String> interfaces) {
        this.interfaceSet.addAll(interfaces);
        return this;
    }

    public InterfaceSet set(String ... interfaces) {
        this.interfaceSet.addAll(Arrays.stream(interfaces).filter(Objects::nonNull).collect(Collectors.toSet()));
        return this;
    }

    public InterfaceSet when(boolean flag) {
        this.lastWhen = flag;
        return this;
    }

    public InterfaceSet then(String ... interfaces) {
        if (this.lastWhen) {
            this.set(interfaces);
        }
        return this;
    }

    public String buildList() {
        if (this.interfaceSet.isEmpty()) {
            return "";
        }
        return " extends " + String.join((CharSequence)",", this.interfaceSet);
    }
}

