/*
 * Decompiled with CFR 0.152.
 */
package javax0.geci.fluent.internal;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax0.geci.api.GeciException;
import javax0.geci.fluent.FluentBuilder;
import javax0.geci.fluent.internal.MethodCollection;
import javax0.geci.fluent.syntax.Syntax;
import javax0.geci.fluent.tree.FluentNodeCreator;
import javax0.geci.fluent.tree.Node;
import javax0.geci.fluent.tree.Terminal;
import javax0.geci.fluent.tree.Tree;
import javax0.geci.tools.GeciReflectionTools;
import javax0.geci.tools.syntax.Lexer;

public class FluentBuilderImpl
implements FluentBuilder,
FluentNodeCreator {
    private final Class<?> klass;
    private final List<Node> nodes = new ArrayList<Node>();
    private final MethodCollection methods;
    private Method cloner = null;
    private String startMethod = null;
    private String interfaces = null;
    private String lastType = null;
    private String lastName = null;

    public FluentBuilderImpl(Class<?> klass) {
        this.methods = new MethodCollection(klass);
        this.klass = klass;
    }

    private FluentBuilderImpl(FluentBuilderImpl that) {
        this.lastName = that.lastName;
        this.klass = that.klass;
        this.nodes.addAll(that.nodes);
        this.methods = that.methods;
        this.cloner = that.cloner;
        this.startMethod = that.startMethod;
        this.interfaces = that.interfaces;
        this.lastType = that.lastType;
    }

    private static Class<?> classOf(FluentBuilder builder) {
        return ((FluentBuilderImpl)builder).klass;
    }

    private static List<Node> nodesOf(FluentBuilder builder) {
        return ((FluentBuilderImpl)builder).nodes;
    }

    private static Tree flatten(Tree tree) {
        if (tree.getModifier() == 8) {
            ArrayList<Node> flat = new ArrayList<Node>();
            for (Node node : tree.getList()) {
                if (node instanceof Tree) {
                    flat.add(FluentBuilderImpl.flatten((Tree)node));
                    continue;
                }
                flat.add(node);
            }
            AtomicBoolean terminalsOnly = new AtomicBoolean(true);
            tree.getList().clear();
            flat.forEach(t -> {
                if (t.getModifier() == 16) {
                    tree.getList().addAll(((Tree)t).getList());
                } else {
                    tree.getList().add((Node)t);
                    if (t instanceof Tree) {
                        terminalsOnly.set(false);
                    }
                }
            });
            if (terminalsOnly.get() && tree.getModifier() != 16) {
                return (Tree)tree.clone(16);
            }
            return tree;
        }
        return tree;
    }

    private static void deduplicate(Tree tree) {
        for (Node node : tree.getList()) {
            if (!(node instanceof Tree)) continue;
            FluentBuilderImpl.deduplicate((Tree)node);
        }
        if (tree.getModifier() == 16 || tree.getModifier() == 8) {
            TreeSet<Node> set = new TreeSet<Node>(tree.getList());
            tree.getList().clear();
            tree.getList().addAll(set);
        }
    }

    private static Node pull(Node node) {
        if (node.getModifier() == 1 && node instanceof Tree && ((Tree)node).getList().size() == 1) {
            return FluentBuilderImpl.pull(((Tree)node).getList().get(0));
        }
        if (node instanceof Tree) {
            Tree tree = (Tree)node;
            ArrayList<Node> pulled = new ArrayList<Node>();
            for (Node n : tree.getList()) {
                pulled.add(FluentBuilderImpl.pull(n));
            }
            tree.getList().clear();
            tree.getList().addAll(pulled);
            return tree;
        }
        return node;
    }

    private static List<Node> flatten(List<Node> nodes, int modifier) {
        ArrayList<Node> pulled = new ArrayList<Node>();
        nodes.forEach(node -> pulled.add(FluentBuilderImpl.pull(node)));
        ArrayList flat = new ArrayList();
        pulled.forEach(node -> {
            if (node instanceof Tree) {
                flat.add(FluentBuilderImpl.flatten((Tree)node));
            } else {
                flat.add(node);
            }
        });
        ArrayList<Node> result = new ArrayList<Node>();
        if (modifier == 1) {
            for (Node node2 : flat) {
                Tree tree;
                if (node2 instanceof Terminal) {
                    result.add(node2);
                    continue;
                }
                if (node2.getModifier() == 1) {
                    tree = (Tree)node2;
                    result.addAll(FluentBuilderImpl.flatten(tree.getList(), 1));
                    continue;
                }
                tree = (Tree)node2;
                result.add(tree.clone(node2.getModifier(), FluentBuilderImpl.flatten(tree.getList(), tree.getModifier())));
            }
        } else {
            for (Node node3 : flat) {
                if (node3 instanceof Terminal) {
                    result.add(node3);
                    continue;
                }
                Tree tree = (Tree)node3;
                result.add(tree.clone(tree.getModifier(), FluentBuilderImpl.flatten(tree.getList(), tree.getModifier())));
            }
        }
        return result;
    }

    public String getInterfaces() {
        return this.interfaces;
    }

    public String getLastType() {
        return this.lastType;
    }

    public String getStartMethod() {
        return this.startMethod;
    }

    public Class<?> getKlass() {
        return this.klass;
    }

    public MethodCollection getMethods() {
        return this.methods;
    }

    public Method getCloner() {
        return this.cloner;
    }

    public List<Node> getNodes() {
        return this.nodes;
    }

    @Override
    public FluentBuilder start(String method) {
        FluentBuilderImpl next = this.copy();
        next.startMethod = method;
        return next;
    }

    @Override
    public FluentBuilder cloner(String method) {
        this.assertThatMethodExistsInTheClass(method);
        Method clonerMethod = this.methods.get(method);
        if (clonerMethod.getGenericExceptionTypes().length > 0) {
            throw new GeciException("The cloner method should not have parameters", new Object[0]);
        }
        if (clonerMethod.getReturnType() != this.klass) {
            throw new GeciException("The cloner method should return the type of the class it is in.", new Object[0]);
        }
        FluentBuilderImpl next = this.copy();
        next.cloner = clonerMethod;
        return next;
    }

    public Tree get() {
        return this.newTree(1, this.nodes);
    }

    private FluentBuilderImpl copy() {
        return new FluentBuilderImpl(this);
    }

    private void assertClass(FluentBuilder ... subs) {
        for (FluentBuilder sub : subs) {
            if (!(sub instanceof FluentBuilderImpl)) {
                throw new GeciException("FluentBuilderImpl can not handle other FluentBuilder implementations", new Object[0]);
            }
            if (FluentBuilderImpl.classOf(sub) == this.klass) continue;
            throw new GeciException("Cannot compose fluent API from different classes.", new Object[0]);
        }
    }

    private void assertThatMethodExistsInTheClass(String ... methodArr) {
        for (String method : methodArr) {
            if (this.methods.get(method) != null) continue;
            throw new GeciException("Method '" + method + "' is not found in class " + this.klass, new Object[0]);
        }
    }

    @Override
    public FluentBuilder implement(String interfaces) {
        FluentBuilderImpl next = this.copy();
        next.interfaces = interfaces;
        this.referenceTheMethodsIn(interfaces);
        return next;
    }

    private void referenceTheMethodsIn(String interfaces) {
        List interfaceNames = Arrays.stream(interfaces.split(",")).map(String::trim).collect(Collectors.toList());
        for (String interfaceName : interfaceNames) {
            Class intrface = this.getInterfaceClass(interfaceName);
            if (!intrface.isInterface()) {
                throw new GeciException(interfaceName + " is not an interface", new Object[0]);
            }
            for (Method method : intrface.getMethods()) {
                this.exclude(method.getName());
                this.methods.get(method.getName());
            }
        }
    }

    private Class getInterfaceClass(String interfaceName) {
        try {
            return GeciReflectionTools.classForName((String)interfaceName);
        }
        catch (ClassNotFoundException e1) {
            throw new GeciException(interfaceName + " interface can not be found", new Object[0]);
        }
    }

    @Override
    public FluentBuilder fluentType(String type) {
        FluentBuilderImpl next = this.copy();
        next.lastType = type;
        return next;
    }

    @Override
    public FluentBuilder exclude(String method) {
        this.methods.exclude(method);
        return this;
    }

    @Override
    public FluentBuilder include(String method) {
        this.methods.get(method);
        this.methods.include(method);
        return this;
    }

    private Terminal newTerminal(int modifiers, String method) {
        Terminal terminal = new Terminal(modifiers, method);
        if (this.lastName != null) {
            terminal.setName(this.lastName);
        }
        this.lastName = null;
        return terminal;
    }

    @Override
    public Node optionalNode(String method) {
        this.assertThatMethodExistsInTheClass(method);
        return this.newTerminal(2, method);
    }

    private <T> FluentBuilder buildWith(Function<T, Node> buildNode, T method) {
        FluentBuilderImpl next = this.copy();
        next.nodes.add(buildNode.apply(method));
        return next;
    }

    @Override
    public FluentBuilder optional(String method) {
        return this.buildWith(this::optionalNode, method);
    }

    private Node optionalNode(FluentBuilder sub) {
        return this.newTree(2, FluentBuilderImpl.nodesOf(sub));
    }

    @Override
    public FluentBuilder optional(FluentBuilder sub) {
        this.assertClass(sub);
        return this.buildWith(this::optionalNode, sub);
    }

    @Override
    public FluentBuilder oneOrMore(String method) {
        this.assertThatMethodExistsInTheClass(method);
        FluentBuilderImpl next = this.copy();
        next.nodes.add(this.oneNode(method));
        next.nodes.add(this.zeroOrMoreNode(method));
        return next;
    }

    private Tree newTree(int modifiers, List<Node> nodes) {
        Tree tree = new Tree(modifiers, nodes);
        if (this.lastName != null) {
            tree.setName(this.lastName);
        }
        this.lastName = null;
        return tree;
    }

    @Override
    public FluentBuilder oneOrMore(FluentBuilder sub) {
        this.assertClass(sub);
        FluentBuilderImpl next = this.copy();
        next.nodes.add(this.oneNode(sub));
        next.nodes.add(this.zeroOrMoreNode(sub));
        return next;
    }

    @Override
    public Node zeroOrMoreNode(String method) {
        this.assertThatMethodExistsInTheClass(method);
        return this.newTerminal(4, method);
    }

    @Override
    public FluentBuilder zeroOrMore(String method) {
        return this.buildWith(this::zeroOrMoreNode, method);
    }

    private Node zeroOrMoreNode(FluentBuilder sub) {
        return this.newTree(4, FluentBuilderImpl.nodesOf(sub));
    }

    @Override
    public FluentBuilder zeroOrMore(FluentBuilder sub) {
        this.assertClass(sub);
        return this.buildWith(this::zeroOrMoreNode, sub);
    }

    @Override
    public Node oneOfNode(String ... methods) {
        this.assertThatMethodExistsInTheClass(methods);
        return this.newTree(16, Arrays.stream(methods).map(method -> this.newTerminal(1, (String)method)).collect(Collectors.toList()));
    }

    @Override
    public FluentBuilder oneOf(String ... methods) {
        return this.buildWith(this::oneOfNode, methods);
    }

    @Override
    public Node oneOfNode(List<Node> subs) {
        return this.newTree(8, subs);
    }

    private Node oneOfNode(FluentBuilder ... subs) {
        return this.newTree(8, Arrays.stream(subs).map(sub -> this.newTree(1, FluentBuilderImpl.nodesOf(sub))).collect(Collectors.toList()));
    }

    @Override
    public FluentBuilder oneOf(FluentBuilder ... subs) {
        this.assertClass(subs);
        return this.buildWith(this::oneOfNode, subs);
    }

    @Override
    public FluentBuilder syntax(String syntaxDef) {
        Syntax syntaxAnalyzer = new Syntax(new Lexer(syntaxDef), this);
        FluentBuilderImpl next = this.copy();
        next.nodes.addAll(syntaxAnalyzer.expression());
        return next;
    }

    @Override
    public Node oneNode(String method) {
        this.assertThatMethodExistsInTheClass(method);
        return this.newTerminal(1, method);
    }

    @Override
    public FluentBuilder one(String method) {
        return this.buildWith(this::oneNode, method);
    }

    @Override
    public Node oneNode(List<Node> sub) {
        return new Tree(1, sub);
    }

    private Node oneNode(FluentBuilder sub) {
        List<Node> nodes = FluentBuilderImpl.nodesOf(sub);
        if (nodes.size() == 1) {
            return nodes.get(0);
        }
        return this.newTree(1, FluentBuilderImpl.nodesOf(sub));
    }

    @Override
    public FluentBuilder one(FluentBuilder sub) {
        return this.buildWith(this::oneNode, sub);
    }

    @Override
    public FluentBuilder name(String interfaceName) {
        if (interfaceName == null || interfaceName.length() == 0) {
            return this;
        }
        FluentBuilderImpl next = this.copy();
        next.lastName = interfaceName;
        return next;
    }

    @Override
    public void optimize() {
        List<Node> flat = FluentBuilderImpl.flatten(this.nodes, 1);
        this.nodes.clear();
        this.nodes.addAll(flat);
        for (Node node : this.nodes) {
            if (!(node instanceof Tree)) continue;
            FluentBuilderImpl.deduplicate((Tree)node);
        }
    }

    public String toString() {
        return this.nodes.stream().map(Node::toString).collect(Collectors.joining(" "));
    }
}

