/*
 * Decompiled with CFR 0.152.
 */
package javax0.geci.fluent.internal;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax0.geci.api.GeciException;
import javax0.geci.fluent.internal.FluentBuilderImpl;
import javax0.geci.fluent.internal.FluentMethodTool;
import javax0.geci.fluent.internal.InterfaceNameFactory;
import javax0.geci.fluent.internal.InterfaceSet;
import javax0.geci.fluent.internal.MethodCollection;
import javax0.geci.fluent.internal.NodeTypeCalculator;
import javax0.geci.fluent.tree.Node;
import javax0.geci.fluent.tree.Terminal;
import javax0.geci.fluent.tree.Tree;
import javax0.geci.log.Logger;
import javax0.geci.log.LoggerFactory;
import javax0.geci.tools.GeciReflectionTools;
import javax0.geci.tools.JavaSource;
import javax0.geci.tools.MethodTool;

public class ClassBuilder {
    private final InterfaceNameFactory ifNameFactory;
    private final MethodCollection methods;
    private final FluentBuilderImpl fluent;
    private String interfaceName;
    private static final Logger LOG = LoggerFactory.getLogger();

    public ClassBuilder(FluentBuilderImpl fluent) {
        this.ifNameFactory = new InterfaceNameFactory();
        this.fluent = fluent;
        this.methods = fluent.getMethods();
    }

    private ClassBuilder(ClassBuilder that) {
        this.ifNameFactory = that.ifNameFactory;
        this.methods = that.methods;
        this.fluent = that.fluent;
        this.interfaceName = that.interfaceName;
    }

    public String build() throws Exception {
        LOG.debug("Class building started for the class %s", new Object[]{this.fluent.getKlass().getSimpleName()});
        List<Node> list = this.fluent.getNodes();
        if (list.size() == 0) {
            throw new GeciException("There are no actual calls in the fluent structure.", new Object[0]);
        }
        LOG.debug("There are %d nodes on the top level", new Object[]{list.size()});
        Tree tree = new Tree(1, list);
        String exitType = NodeTypeCalculator.from(this.methods).getReturnType(this.getLastNode(list));
        String lastInterface = GeciReflectionTools.normalizeTypeName((String)exitType);
        LOG.debug("The last type is %s", new Object[]{lastInterface});
        String interfaces = this.build(tree, lastInterface);
        JavaSource.Builder code = JavaSource.builder();
        this.writeStartMethod(code);
        this.writeWrapperInterface(code);
        this.writeWrapperClass(code);
        code.write(interfaces, new Object[0]);
        return code.toString();
    }

    private Node getLastNode(List<Node> list) {
        return list.get(list.size() - 1);
    }

    private void writeStartMethod(JavaSource.Builder code) throws Exception {
        String lastType;
        String startMethod = this.fluent.getStartMethod() == null ? "start" : this.fluent.getStartMethod();
        LOG.debug("Creating start method %s()", new Object[]{startMethod});
        if (this.fluent.getLastType() != null) {
            lastType = this.fluent.getLastType();
            code.write("public interface %s extends %s {}", new Object[]{lastType, this.interfaceName});
        } else {
            lastType = this.ifNameFactory.getLastName();
        }
        try (JavaSource.MethodBody mtBl = code.method(startMethod).modifiers("public static").returnType(lastType).noArgs();){
            mtBl.returnStatement("new Wrapper()", new Object[0]);
        }
    }

    private void writeWrapperInterface(JavaSource.Builder code) throws Exception {
        JavaSource.Ukeg ignored;
        if (this.methods.needWrapperInterface() && (ignored = code.open("public interface WrapperInterface", new Object[0])) != null) {
            ignored.close();
        }
    }

    private void writeWrapperClass(JavaSource.Builder code) throws Exception {
        try (JavaSource.Ukeg klBl = code.open("public static class Wrapper implements %s", new Object[]{this.setJoin(this.ifNameFactory.getAllNames(), this.fluent.getLastType(), this.fluent.getInterfaces())});){
            JavaSource.Ukeg coBl;
            klBl.statement("private final %s that", new Object[]{this.fluent.getKlass().getCanonicalName()});
            if (this.fluent.getCloner() != null) {
                coBl = klBl.open("public Wrapper(%s that)", new Object[]{this.fluent.getKlass().getCanonicalName()});
                try {
                    coBl.statement("this.that = that", new Object[0]);
                }
                finally {
                    if (coBl != null) {
                        coBl.close();
                    }
                }
            }
            coBl = klBl.open("public Wrapper()", new Object[0]);
            try {
                coBl.statement("this.that = new %s()", new Object[]{this.fluent.getKlass().getCanonicalName()});
            }
            finally {
                if (coBl != null) {
                    coBl.close();
                }
            }
            this.writeWrapperMethods(code);
        }
    }

    private void writeWrapperMethods(JavaSource.Builder code) throws Exception {
        for (String signature : this.methods.methodSignatures()) {
            Method method = this.methods.get(signature);
            if (this.fluent.getCloner() != null && this.fluent.getCloner().equals(method)) continue;
            boolean notFluent = this.methods.isExitNode(signature) != false || this.methods.isFluentNode(signature) == false;
            String actualReturnType = notFluent ? null : "Wrapper";
            String signatureString = FluentMethodTool.from(this.fluent.getKlass()).asPublic().forThe(method).withType(actualReturnType).signature();
            JavaSource.MethodBody methodBody = (JavaSource.MethodBody)code.open(signatureString, new Object[0]);
            try {
                if (notFluent) {
                    this.writeNonFluentMethodWrapper(method, methodBody);
                    continue;
                }
                this.writeWrapperMethodBody(method, methodBody);
            }
            finally {
                if (methodBody == null) continue;
                methodBody.close();
            }
        }
    }

    private void writeWrapperMethodBody(Method method, JavaSource.MethodBody mtBl) {
        String callString = FluentMethodTool.from(this.fluent.getKlass()).forThe(method).call();
        if (this.fluent.getCloner() != null) {
            mtBl.statement("var next = new Wrapper(that.%s)", new Object[]{MethodTool.with((Method)this.fluent.getCloner()).call()}).statement("next.that.%s", new Object[]{callString}).returnStatement("next", new Object[0]);
        } else {
            mtBl.statement("that.%s", new Object[]{callString}).returnStatement("this", new Object[0]);
        }
    }

    private void writeNonFluentMethodWrapper(Method method, JavaSource.MethodBody mtBl) {
        String callString = FluentMethodTool.from(this.fluent.getKlass()).forThe(method).call();
        if (method.getReturnType() == Void.TYPE) {
            mtBl.statement("that.%s", new Object[]{callString});
        } else {
            mtBl.returnStatement("that.%s", new Object[]{callString});
        }
    }

    private String build(Node node, String nextInterface) {
        if (node instanceof Terminal) {
            return this.build((Terminal)node, nextInterface);
        }
        return this.build((Tree)node, nextInterface);
    }

    private String build(Terminal terminal, String nextInterface) {
        this.interfaceName = this.ifNameFactory.getNewName(terminal);
        JavaSource code = new JavaSource();
        String list = InterfaceSet.builderFor(this.methods).when((terminal.getModifier() & 6) != 0).then(nextInterface, this.fluent.getInterfaces()).buildList();
        try (JavaSource ifcB = code.open("public interface %s%s ", new Object[]{this.interfaceName, list});){
            ifcB.statement(FluentMethodTool.from(this.fluent.getKlass()).forThe(this.methods.get(terminal.getMethod())).withType((terminal.getModifier() & 4) != 0 ? this.interfaceName : nextInterface).asInterface().signature(), new Object[0]);
        }
        return code.toString();
    }

    private String build(Tree tree, String nextInterface) {
        int modifier = tree.getModifier();
        switch (modifier) {
            case 1: {
                return this.buildOnce(tree, nextInterface);
            }
            case 2: {
                return this.buildOptional(tree, nextInterface);
            }
            case 4: {
                return this.buildZeroOrMore(tree, nextInterface);
            }
            case 8: {
                return this.buildOneOf(tree, nextInterface);
            }
            case 16: {
                return this.buildOneTerminalOf(tree, nextInterface);
            }
        }
        throw new GeciException("Internal error tree " + tree.toString() + " modifier is " + modifier, new Object[0]);
    }

    private String buildOneTerminalOf(Tree tree, String nextInterface) {
        this.interfaceName = this.ifNameFactory.getNewName(tree);
        JavaSource code = new JavaSource();
        try (JavaSource ifcB = code.open("public interface %s", new Object[]{this.interfaceName});){
            for (Node node : tree.getList()) {
                if (node instanceof Tree) {
                    throw new GeciException("Internal error, ON_TERMINAL_OF contains a non-terminal sub.", new Object[0]);
                }
                Terminal terminal = (Terminal)node;
                ifcB.statement(FluentMethodTool.from(this.fluent.getKlass()).forThe(this.methods.get(terminal.getMethod())).withType(nextInterface).asInterface().signature(), new Object[0]);
            }
        }
        return code.toString();
    }

    private String buildOneOf(Tree tree, String nextInterface) {
        List<Node> list = tree.getList();
        JavaSource code = new JavaSource();
        HashSet<String> alternativeInterfaces = new HashSet<String>();
        for (Node node : list) {
            ClassBuilder builder = new ClassBuilder(this);
            code.write(builder.build(node, nextInterface), new Object[0]);
            alternativeInterfaces.add(builder.interfaceName);
        }
        this.interfaceName = this.ifNameFactory.getNewName(tree);
        String ifs = InterfaceSet.builderFor(this.methods).set(this.fluent.getInterfaces()).set(alternativeInterfaces).buildList();
        JavaSource ignored = code.open("public interface %s%s", new Object[]{this.interfaceName, ifs});
        if (ignored != null) {
            ignored.close();
        }
        return code.toString();
    }

    private String setJoin(Set<String> set, String ... other) {
        if (other != null && other.length > 0) {
            HashSet<String> local = new HashSet<String>(set);
            local.addAll(Arrays.stream(other).filter(Objects::nonNull).collect(Collectors.toSet()));
            return String.join((CharSequence)",", local);
        }
        return String.join((CharSequence)",", set);
    }

    private String buildZeroOrMore(Tree tree, String nextInterface) {
        List<Node> list = tree.getList();
        JavaSource code = new JavaSource();
        this.interfaceName = this.ifNameFactory.getNewName(tree);
        ClassBuilder lastBuilder = this.buildNodeList(this.interfaceName, list, code);
        String ifs = InterfaceSet.builderFor(this.methods).set(nextInterface, lastBuilder.interfaceName, this.fluent.getInterfaces()).buildList();
        code.write("public interface %s%s {}", new Object[]{this.interfaceName, ifs});
        return code.toString();
    }

    private String buildOptional(Tree tree, String nextInterface) {
        List<Node> list = tree.getList();
        JavaSource code = new JavaSource();
        this.interfaceName = this.ifNameFactory.getNewName(tree);
        ClassBuilder lastBuilder = this.buildNodeList(nextInterface, list, code);
        String ifs = InterfaceSet.builderFor(this.methods).set(nextInterface, lastBuilder.interfaceName, this.fluent.getInterfaces()).buildList();
        code.write("public interface %s%s {}", new Object[]{this.interfaceName, ifs});
        return code.toString();
    }

    private String buildOnce(Tree tree, String nextInterface) {
        List<Node> list = tree.getList();
        JavaSource code = new JavaSource();
        ClassBuilder lastBuilder = this.buildNodeList(nextInterface, list, code);
        this.interfaceName = lastBuilder.interfaceName;
        return code.toString();
    }

    private ClassBuilder buildNodeList(String nextInterface, List<Node> list, JavaSource code) {
        String actualNextInterface = nextInterface;
        for (int i = list.size() - 1; i >= 0; --i) {
            Node node = list.get(i);
            ClassBuilder builder = new ClassBuilder(this);
            code.write(builder.build(node, actualNextInterface), new Object[0]);
            if (i == 0) {
                return builder;
            }
            actualNextInterface = builder.interfaceName;
        }
        throw new GeciException("Internal error", new Object[0]);
    }
}

