/*
 * Decompiled with CFR 0.152.
 */
package javax0.geci.fluent;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax0.geci.api.GeciException;
import javax0.geci.api.Segment;
import javax0.geci.api.Source;
import javax0.geci.core.annotations.AnnotationBuilder;
import javax0.geci.fluent.FluentBuilder;
import javax0.geci.fluent.internal.ClassBuilder;
import javax0.geci.fluent.internal.FluentBuilderImpl;
import javax0.geci.fluent.tree.Tree;
import javax0.geci.log.Logger;
import javax0.geci.log.LoggerFactory;
import javax0.geci.tools.AbstractJavaGenerator;
import javax0.geci.tools.CompoundParams;
import javax0.geci.tools.GeciReflectionTools;

@AnnotationBuilder
public class Fluent
extends AbstractJavaGenerator {
    private static final Logger LOG = LoggerFactory.getLogger();

    public void process(Source source, Class<?> klass, CompoundParams global) throws Exception {
        String syntax = global.get("syntax");
        String definedBy = global.get("definedBy");
        if (syntax.length() > 0 && definedBy.length() > 0) {
            throw new GeciException("Both 'syntax' and 'definedBy' cannot be specified.", new Object[0]);
        }
        try {
            FluentBuilderImpl builder;
            if (definedBy.length() > 0) {
                Method definingMethod = this.getDefiningMethod(definedBy, klass);
                definingMethod.setAccessible(true);
                builder = (FluentBuilderImpl)definingMethod.invoke(null, new Object[0]);
            } else if (syntax.length() > 0) {
                builder = (FluentBuilderImpl)FluentBuilder.from(klass).syntax(syntax);
            } else {
                throw new GeciException("Either 'syntax' or 'definedBy' has to be used to define fluent API.", new Object[0]);
            }
            builder.optimize();
            LOG.debug("Node structure before optimization.", new Object[0]);
            LOG.debug("" + new Tree(1, builder.getNodes()), new Object[0]);
            LOG.debug("Node structure after optimization.", new Object[0]);
            LOG.debug("" + new Tree(1, builder.getNodes()), new Object[0]);
            String generatedCode = new ClassBuilder(builder).build();
            try (Segment segment = source.open(global.get("id"));){
                segment.write(generatedCode, new Object[0]);
            }
        }
        catch (InvocationTargetException ite) {
            throw (Exception)ite.getCause();
        }
    }

    private Method getDefiningMethod(String s, Class<?> forClass) {
        Method method;
        Class klass;
        int sepSize;
        int sepPos;
        if (s.contains("::")) {
            sepPos = s.indexOf("::");
            sepSize = 2;
        } else if (s.contains("#")) {
            sepPos = s.indexOf("#");
            sepSize = 1;
        } else if (s.contains(".")) {
            sepPos = s.lastIndexOf(".");
            sepSize = 1;
        } else {
            throw new GeciException("Fluent structure definedBy has to have 'className::methodName' format for class '" + forClass + "'", new Object[0]);
        }
        String className = s.substring(0, sepPos);
        String methodName = s.substring(sepPos + sepSize);
        try {
            klass = GeciReflectionTools.classForName((String)className);
        }
        catch (ClassNotFoundException e) {
            throw new GeciException("definedBy class '" + className + "' can not be found", new Object[0]);
        }
        try {
            method = klass.getMethod(methodName, new Class[0]);
            method.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new GeciException("definedBy method '" + methodName + "' can not be found in the class '" + className + "'", new Object[0]);
        }
        if ((method.getModifiers() & 8) == 0) {
            throw new GeciException("definedBy method '" + methodName + "' from the class '" + className + "' should be static", new Object[0]);
        }
        if (!FluentBuilder.class.isAssignableFrom(method.getReturnType())) {
            throw new GeciException("definedBy method '" + methodName + "' from the class '" + className + "' should return type " + FluentBuilderImpl.class.getName(), new Object[0]);
        }
        return method;
    }

    public String mnemonic() {
        return "fluent";
    }
}

