/*
 * Decompiled with CFR 0.152.
 */
package javax0.geci.factory;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import javax0.geci.annotations.Generated;
import javax0.geci.api.Segment;
import javax0.geci.api.Source;
import javax0.geci.tools.AbstractFilteredFieldsGenerator;
import javax0.geci.tools.CompoundParams;
import javax0.geci.tools.GeciReflectionTools;

public class Factory
extends AbstractFilteredFieldsGenerator {
    private Class<? extends Annotation> generatedAnnotation = Generated.class;
    private String filter = "private & !static & !final";
    private String builderName = "Builder";
    private String builderFactoryMethod = "builder";
    private String buildMethod = "build";

    public String mnemonic() {
        return "builder";
    }

    public void preprocess(Source source, Class<?> klass, CompoundParams global, Segment segment) {
        String bn = global.get("builderName", this.builderName);
        String bfm = global.get("builderFactoryMethod", this.builderFactoryMethod);
        this.writeGenerated(segment, this.generatedAnnotation);
        segment.write_r("public static %s.%s %s() {", new Object[]{klass.getSimpleName(), bn, bfm}).write("return new %s().new %s();", new Object[]{klass.getSimpleName(), bn}).write_l("}", new Object[0]).newline().write_r("public class %s {", new Object[]{bn});
    }

    public void process(Source source, Class<?> klass, CompoundParams params, Field field, Segment segment) throws Exception {
        String bn = params.get("builderName", this.builderName);
        String name = field.getName();
        String type = GeciReflectionTools.normalizeTypeName((String)field.getType().getName());
        this.writeGenerated(segment, this.generatedAnnotation);
        segment.write_r("public %s %s(%s %s){", new Object[]{bn, name, type, name}).write("%s.this.%s = %s;", new Object[]{klass.getSimpleName(), name, name}).write("return this;", new Object[0]).write_l("}", new Object[0]).newline();
    }

    public void postprocess(Source source, Class<?> klass, CompoundParams global, Segment segment) {
        String bm = global.get("buildMethod", this.buildMethod);
        this.writeGenerated(segment, this.generatedAnnotation);
        segment.write_r("public %s %s() {", new Object[]{klass.getSimpleName(), bm}).write("return %s.this;", new Object[]{klass.getSimpleName()}).write_l("}", new Object[0]);
        segment.write_l("}", new Object[0]);
    }

    protected String defaultFilterExpression() {
        return this.filter;
    }

    public static BuilderBuilder builder() {
        return new Factory().new BuilderBuilder();
    }

    public class BuilderBuilder {
        public BuilderBuilder buildMethod(String x) {
            Factory.this.buildMethod = x;
            return this;
        }

        public BuilderBuilder builderFactoryMethod(String x) {
            Factory.this.builderFactoryMethod = x;
            return this;
        }

        public BuilderBuilder builderName(String x) {
            Factory.this.builderName = x;
            return this;
        }

        public BuilderBuilder filter(String x) {
            Factory.this.filter = x;
            return this;
        }

        public BuilderBuilder generatedAnnotation(Class x) {
            Factory.this.generatedAnnotation = x;
            return this;
        }

        public Factory build() {
            return Factory.this;
        }
    }
}

