/*
 * Decompiled with CFR 0.152.
 */
package javax0.geci.equals;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax0.geci.annotations.Generated;
import javax0.geci.api.GeneratorBuilder;
import javax0.geci.api.Segment;
import javax0.geci.api.Source;
import javax0.geci.core.annotations.AnnotationBuilder;
import javax0.geci.tools.AbstractFilteredFieldsGenerator;
import javax0.geci.tools.CompoundParams;
import javax0.geci.tools.GeciAnnotationTools;
import javax0.geci.tools.GeciReflectionTools;
import javax0.geci.tools.reflection.Selector;

@AnnotationBuilder
public class Equals
extends AbstractFilteredFieldsGenerator {
    private boolean generateEquals;
    private Segment equalsSegment;
    private Field lastField;
    private CompoundParams lastParams;
    private final Config config = new Config();
    private static final Set<String> implementedKeys = new HashSet<String>(Arrays.asList("filter", "hashFilter", "notNull", "subclass", "useObjects", "useSuper", "id"));

    public String mnemonic() {
        return "equals";
    }

    public void preprocess(Source source, Class<?> klass, CompoundParams global) {
        this.equalsSegment = source.temporary();
        this.generateEqualsHeader(this.equalsSegment, klass, global);
        this.lastField = null;
    }

    public void process(Source source, Class<?> klass, CompoundParams params, Field field) {
        this.generateEqualsForField(this.equalsSegment, params, field);
    }

    public void postprocess(Source source, Class<?> klass, CompoundParams global) throws IOException {
        if (this.lastField != null) {
            this.generateEqualsForField(this.equalsSegment, this.lastParams, this.lastField, this::retLast);
        }
        this.generateEqualsTail(this.equalsSegment);
        try (Segment segment = source.open(global.id());){
            if (this.generateEquals) {
                segment.write(this.equalsSegment);
            }
        }
    }

    private void generateEqualsHeader(Segment segment, Class<?> klass, CompoundParams global) {
        Method equalsMethod = this.getMethodOrNull(klass, "equals", Object.class);
        boolean subclassingAllowed = global.is("subclass", this.config.subclass);
        boolean usingSuper = global.is("useSuper", this.config.useSuper);
        this.generateEquals = equalsMethod == null || GeciAnnotationTools.isGenerated((AnnotatedElement)equalsMethod);
        this.writeGenerated(segment, this.config.generatedAnnotation);
        segment.write("@Override", new Object[0]).write_r("public %sboolean equals(Object o) {", new Object[]{subclassingAllowed ? "final " : ""}).write("if (this == o) return true;", new Object[0]);
        try {
            if (usingSuper && !GeciReflectionTools.getMethod(klass.getSuperclass(), (String)"equals", (Class[])new Class[]{Object.class}).getDeclaringClass().equals(Object.class)) {
                segment.write("if (!super.equals(o)) return false;", new Object[0]);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (subclassingAllowed) {
            segment.write("if (!(o instanceof %s)) return false;", new Object[]{klass.getSimpleName()});
        } else {
            segment.write("if (o == null || getClass() != o.getClass()) return false;", new Object[0]);
        }
        segment.newline().write("%s that = (%s) o;", new Object[]{klass.getSimpleName(), klass.getSimpleName()});
    }

    private void generateEqualsTail(Segment segment) {
        segment.write_l("}", new Object[0]).newline();
    }

    private void generateEqualsForField(Segment segment, CompoundParams params, Field field) {
        if (this.lastField != null) {
            this.generateEqualsForField(segment, this.lastParams, this.lastField, this::ret);
        }
        this.lastParams = params;
        this.lastField = field;
    }

    private void generateEqualsForField(Segment segment, CompoundParams params, Field field, Function<String, String> convert) {
        boolean primitive = field.getType().isPrimitive();
        String name = field.getName();
        if (primitive) {
            if (field.getType().equals(Float.TYPE)) {
                segment.write(convert.apply("Float.compare(that." + name + ", " + name + ") == 0"), new Object[0]);
            } else if (field.getType().equals(Double.TYPE)) {
                segment.write(convert.apply("Double.compare(that." + name + ", " + name + ") == 0"), new Object[0]);
            } else {
                segment.write(convert.apply(name + " == that." + name), new Object[0]);
            }
        } else if (params.is("useObjects", this.config.useObjects)) {
            segment.write(convert.apply("java.util.Objects.equals(" + name + ", that." + name + ")"), new Object[0]);
        } else if (params.is("notNull")) {
            segment.write(convert.apply(name + ".equals(that." + name + ")"), new Object[0]);
        } else {
            segment.write(convert.apply(name + " != null ? !!" + name + ".equals(that." + name + ") : that." + name + " == null"), new Object[0]);
        }
    }

    private String retLast(String condition) {
        String modCondition = condition.replace("!!", "");
        return "return " + modCondition + ";";
    }

    private String ret(String condition) {
        Object notCondition = condition.contains("==") ? condition.replace("==", "!=").replace("!!", "!") : "!" + condition;
        return "if (" + (String)notCondition + ") return false;";
    }

    private Method getMethodOrNull(Class<?> klass, String name, Class<?> ... args) {
        try {
            return klass.getDeclaredMethod(name, args);
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }

    public void process(Source source, Class<?> klass, CompoundParams global, Field[] fields) throws Exception {
        String gid = global.get("id");
        try (Segment segment = source.open(gid);){
            boolean generateHashCode;
            Method hashCodeMethod = this.getMethodOrNull(klass, "hashCode", new Class[0]);
            boolean bl = generateHashCode = hashCodeMethod == null || GeciAnnotationTools.isGenerated((AnnotatedElement)hashCodeMethod);
            if (generateHashCode) {
                this.writeGenerated(segment, this.config.generatedAnnotation);
                segment.write("@Override", new Object[0]);
                segment.write_r("public int hashCode() {", new Object[0]);
                Field[] hashFields = (Field[])Arrays.stream(fields).filter(field -> {
                    CompoundParams params = new CompoundParams(new CompoundParams[]{GeciReflectionTools.getParameters((AnnotatedElement)field, (String)this.mnemonic()), global});
                    String hashFilter = params.get("hashFilter", params.get("filter", this.config.hashFilter));
                    return Selector.compile((String)hashFilter).match(field);
                }).toArray(Field[]::new);
                boolean usingSuper = this.shouldUseSuper(klass, global);
                if (global.is("useObjects", this.config.useObjects)) {
                    this.generateHashCodeBodyUsingObjects(segment, hashFields, usingSuper);
                } else {
                    this.generateHashCodeBody(segment, global, hashFields, usingSuper);
                }
                segment.write_l("}", new Object[0]);
            }
        }
    }

    private void generateHashCodeBody(Segment segment, CompoundParams global, Field[] fields, boolean usingSuper) {
        if (usingSuper) {
            segment.write("int result = super.hashCode();", new Object[0]);
        } else {
            segment.write("int result = 0;", new Object[0]);
        }
        if (this.thereIsAtLeastOneDoubleField(fields)) {
            segment.write("long temp;", new Object[0]);
        }
        segment.newline();
        for (Field field : fields) {
            CompoundParams local = GeciReflectionTools.getParameters((AnnotatedElement)field, (String)this.mnemonic());
            CompoundParams params = new CompoundParams(new CompoundParams[]{local, global});
            boolean primitive = field.getType().isPrimitive();
            String name = field.getName();
            if (primitive) {
                if (field.getType().equals(Boolean.TYPE)) {
                    segment.write("result = 31 * result + (%s ? 1 : 0);", new Object[]{name});
                    continue;
                }
                if (field.getType().equals(Long.TYPE)) {
                    segment.write("result = 31 * result + (int) (%s ^ (%s >>> 32));", new Object[]{name, name});
                    continue;
                }
                if (field.getType().equals(Float.TYPE)) {
                    segment.write("result = 31 * result + (%s != +0.0f ? Float.floatToIntBits(%s) : 0);", new Object[]{name, name});
                    continue;
                }
                if (field.getType().equals(Double.TYPE)) {
                    segment.write("temp = Double.doubleToLongBits(%s);", new Object[]{name});
                    segment.write("result = 31 * result + (int) (temp ^ (temp >>> 32));", new Object[0]);
                    continue;
                }
                segment.write("result = 31 * result + (int) %s;", new Object[]{name});
                continue;
            }
            if (params.is("notNull")) {
                segment.write("result = 31 * result + %s.hashCode();", new Object[]{name});
                continue;
            }
            segment.write("result = 31 * result + (%s != null ? %s.hashCode() : 0);", new Object[]{name, name});
        }
        segment.write("return result;", new Object[0]);
    }

    private boolean shouldUseSuper(Class<?> klass, CompoundParams global) {
        boolean usingSuper = global.is("useSuper", this.config.useSuper);
        if (usingSuper) {
            try {
                Class<?> superWithHash = GeciReflectionTools.getMethod(klass.getSuperclass(), (String)"hashCode", (Class[])new Class[0]).getDeclaringClass();
                Class<?> superWithEquals = GeciReflectionTools.getMethod(klass.getSuperclass(), (String)"equals", (Class[])new Class[]{Object.class}).getDeclaringClass();
                return superWithEquals == superWithHash && superWithEquals != Object.class;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean thereIsAtLeastOneDoubleField(Field[] fields) {
        return Arrays.stream(fields).map(Field::getType).anyMatch(c -> c.equals(Double.TYPE));
    }

    private void generateHashCodeBodyUsingObjects(Segment segment, Field[] fields, boolean usingSuper) {
        String andSuperHash = usingSuper ? ", super.hashCode()" : "";
        segment.write("return java.util.Objects.hash(%s" + andSuperHash + ");", new Object[]{Arrays.stream(fields).map(Field::getName).collect(Collectors.joining(", "))});
    }

    protected String defaultFilterExpression() {
        return "!static";
    }

    public static Builder builder() {
        return new Equals().new Builder();
    }

    public Set<String> implementedKeys() {
        return implementedKeys;
    }

    private Config localConfig(CompoundParams params) {
        Config local = new Config();
        local.filter = params.get("filter", this.config.filter);
        local.generatedAnnotation = this.config.generatedAnnotation;
        local.hashFilter = params.get("hashFilter", this.config.hashFilter);
        local.notNull = params.get("notNull", this.config.notNull);
        local.subclass = params.get("subclass", this.config.subclass);
        local.useObjects = params.get("useObjects", this.config.useObjects);
        local.useSuper = params.get("useSuper", this.config.useSuper);
        return local;
    }

    public class Builder
    implements GeneratorBuilder {
        public Builder filter(String filter) {
            Equals.this.config.filter = filter;
            return this;
        }

        public Builder generatedAnnotation(Class<? extends Annotation> generatedAnnotation) {
            Equals.this.config.generatedAnnotation = generatedAnnotation;
            return this;
        }

        public Builder hashFilter(String hashFilter) {
            Equals.this.config.hashFilter = hashFilter;
            return this;
        }

        public Builder notNull(String notNull) {
            Equals.this.config.notNull = notNull;
            return this;
        }

        public Builder subclass(String subclass) {
            Equals.this.config.subclass = subclass;
            return this;
        }

        public Builder useObjects(String useObjects) {
            Equals.this.config.useObjects = useObjects;
            return this;
        }

        public Builder useSuper(String useSuper) {
            Equals.this.config.useSuper = useSuper;
            return this;
        }

        public Equals build() {
            return Equals.this;
        }
    }

    private static class Config {
        private Class<? extends Annotation> generatedAnnotation = Generated.class;
        private String filter;
        private String subclass = "no";
        private String useObjects = "no";
        private String notNull = "true";
        private String hashFilter = "true";
        private String useSuper = "no";

        private Config() {
        }
    }
}

