/*
 * Decompiled with CFR 0.152.
 */
package javax0.geci.delegator;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax0.geci.annotations.Generated;
import javax0.geci.api.GeneratorBuilder;
import javax0.geci.api.Segment;
import javax0.geci.api.Source;
import javax0.geci.core.annotations.AnnotationBuilder;
import javax0.geci.tools.AbstractFilteredFieldsGenerator;
import javax0.geci.tools.CompoundParams;
import javax0.geci.tools.GeciReflectionTools;
import javax0.geci.tools.MethodTool;
import javax0.geci.tools.reflection.Selector;

@AnnotationBuilder
public class Delegator
extends AbstractFilteredFieldsGenerator {
    private static final boolean NO_ABSTRACT = true;
    private String configuredMnemonic = "delegator";
    private final Config config = new Config();
    private static final Set<String> implementedKeys = new HashSet<String>(Arrays.asList("filter", "methods", "id"));

    public void process(Source source, Class<?> klass, CompoundParams params, Field field, Segment segment) {
        String name = field.getName();
        Config local = this.localConfig(params);
        List methods = Arrays.stream(GeciReflectionTools.getDeclaredMethodsSorted(field.getType())).filter(arg_0 -> ((Selector)Selector.compile((String)local.methods)).match(arg_0)).collect(Collectors.toList());
        for (Method method : methods) {
            if (this.manuallyCoded(klass, method)) continue;
            this.writeGenerated(segment, this.config.generatedAnnotation);
            segment.write_r(MethodTool.with((Method)method).signature(true) + " {", new Object[0]).write((Delegator.isVoid(method) ? "" : "return ") + name + "." + MethodTool.with((Method)method).call() + ";", new Object[0]).write_l("}", new Object[0]).newline();
        }
    }

    private static boolean isVoid(Method method) {
        return "void".equals(method.getReturnType().getName());
    }

    private boolean manuallyCoded(Class<?> klass, Method method) {
        try {
            Method localMethod = klass.getDeclaredMethod(method.getName(), method.getParameterTypes());
            return localMethod.getDeclaredAnnotation(this.config.generatedAnnotation) == null;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    protected String defaultFilterExpression() {
        return this.config.filter;
    }

    public String mnemonic() {
        return this.configuredMnemonic;
    }

    public static Builder builder() {
        return new Delegator().new Builder();
    }

    public Set<String> implementedKeys() {
        return implementedKeys;
    }

    private Config localConfig(CompoundParams params) {
        Config local = new Config();
        local.filter = params.get("filter", this.config.filter);
        local.generatedAnnotation = this.config.generatedAnnotation;
        local.methods = params.get("methods", this.config.methods);
        return local;
    }

    public class Builder
    implements GeneratorBuilder {
        public Builder filter(String filter) {
            Delegator.this.config.filter = filter;
            return this;
        }

        public Builder generatedAnnotation(Class<? extends Annotation> generatedAnnotation) {
            Delegator.this.config.generatedAnnotation = generatedAnnotation;
            return this;
        }

        public Builder methods(String methods) {
            Delegator.this.config.methods = methods;
            return this;
        }

        public Builder mnemonic(String mnemonic) {
            Delegator.this.configuredMnemonic = mnemonic;
            return this;
        }

        public Delegator build() {
            return Delegator.this;
        }
    }

    private static class Config {
        private Class<? extends Annotation> generatedAnnotation = Generated.class;
        private String filter = "!static";
        private String methods = "public & !static";

        private Config() {
        }
    }
}

