/*
 * Decompiled with CFR 0.152.
 */
package javax0.geci.config;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax0.geci.api.GeciException;
import javax0.geci.api.GeneratorBuilder;
import javax0.geci.api.Segment;
import javax0.geci.api.Source;
import javax0.geci.core.annotations.AnnotationBuilder;
import javax0.geci.tools.AbstractJavaGenerator;
import javax0.geci.tools.CaseTools;
import javax0.geci.tools.CompoundParams;
import javax0.geci.tools.GeciReflectionTools;
import javax0.geci.tools.reflection.Selector;

@AnnotationBuilder
public class ConfigBuilder
extends AbstractJavaGenerator {
    private final Config config = new Config();
    private static final Set<String> implementedKeys = new HashSet<String>(Arrays.asList("buildMethod", "builderFactoryMethod", "builderName", "configAccess", "configurableMnemonic", "filter", "generateImplementedKeys", "localConfigMethod", "id"));

    public void process(Source source, Class<?> klass, CompoundParams global) throws Exception {
        Class<?> configClass;
        try {
            configClass = Class.forName(klass.getName() + "$Config");
        }
        catch (ClassNotFoundException cnfe) {
            throw new GeciException("There is no class 'Config' in " + klass.getName(), (Throwable)cnfe);
        }
        try (Segment segment = source.open(global.id());){
            List<Field> allDeclaredFields = Arrays.asList(GeciReflectionTools.getDeclaredFieldsSorted(configClass));
            List<Field> fields = this.configurableFields(global, allDeclaredFields);
            Config local = this.localConfig(global);
            segment.param(new String[]{"klass", klass.getSimpleName(), "access", local.configAccess, "build", local.buildMethod, "builder", local.builderFactoryMethod, "Builder", local.builderName, "localConfig", local.localConfigMethod});
            this.generateMnemonic(segment, local, klass);
            this.generateConfigField(segment);
            this.generateBuilderFactoryMethod(segment, klass);
            if (javax0.geci.api.CompoundParams.toBoolean((String)local.generateImplementedKeys)) {
                this.generateConfigKeySet(segment, fields);
            }
            this.startBuilderClass(segment, klass);
            allDeclaredFields.forEach(field -> this.generateBuilderMethod(segment, klass, configClass, (Field)field));
            this.generateMnemonicConfiguration(segment, local);
            this.finishBuilderClass(segment);
            if (local.localConfigMethod.length() > 0) {
                this.generateLocalConfigMethod(segment, allDeclaredFields, fields, configClass);
            }
        }
    }

    private void generateMnemonicConfiguration(Segment segment, Config local) {
        if (this.mnemonicIsConfigurable(local)) {
            segment.write_r("public {{Builder}} mnemonic(String mnemonic) {", new Object[0]).write("configuredMnemonic = mnemonic;", new Object[0]).write("return this;", new Object[0]).write_l("}", new Object[0]).newline();
        }
    }

    private void generateMnemonic(Segment segment, Config local, Class klass) {
        if (this.mnemonicIsConfigurable(local)) {
            segment.write("private String configuredMnemonic = \"%s\";", new Object[]{local.configurableMnemonic}).newline();
            try {
                klass.getSuperclass().getMethod("mnemonic", new Class[0]);
                segment.write("@Override", new Object[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            segment.write_r("public String mnemonic(){", new Object[0]).write("return configuredMnemonic;", new Object[0]).write_l("}", new Object[0]).newline();
        }
    }

    private boolean mnemonicIsConfigurable(Config local) {
        return local.configurableMnemonic != null && local.configurableMnemonic.length() > 0;
    }

    private void generateConfigField(Segment segment) {
        segment.write("{{access}} final Config config = new Config();", new Object[0]);
    }

    private void generateConfigKeySet(Segment segment, List<Field> fields) {
        segment.write_r("private static final java.util.Set<String> implementedKeys = new java.util.HashSet<>(java.util.Arrays.asList(", new Object[0]);
        fields.forEach(field -> {
            String name = field.getName();
            segment.write("\"%s\",", new Object[]{name});
        });
        segment.write("\"id\"", new Object[0]).write_l("));", new Object[0]).newline();
        segment.write("@Override", new Object[0]).write_r("public java.util.Set<String> implementedKeys() {", new Object[0]).write("return implementedKeys;", new Object[0]).write_l("}", new Object[0]);
    }

    private void generateLocalConfigMethod(Segment segment, List<Field> allDeclaredFields, List<Field> fields, Class<?> configClass) {
        segment.write_r("private Config {{localConfig}}(CompoundParams params){", new Object[0]).write("final var local = new Config();", new Object[0]);
        for (Field field : allDeclaredFields) {
            String name = field.getName();
            String setterName = "set" + CaseTools.ucase((String)name);
            segment.param(new String[]{"name", name, "setterName", setterName});
            boolean hasSetter = ConfigBuilder.doesTheFieldHaveSetter(configClass, field, setterName);
            if (fields.contains(field)) {
                if (hasSetter) {
                    segment.write("local.{{setterName}}(params.get(\"{{name}}\", config.{{name}}));", new Object[0]);
                    continue;
                }
                segment.write("local.{{name}} = params.get(\"{{name}}\", config.{{name}});", new Object[0]);
                continue;
            }
            if (hasSetter) {
                segment.write("local.{{setterName}}(config.{{name}});", new Object[0]);
                continue;
            }
            if (Modifier.isFinal(field.getModifiers())) continue;
            segment.write("local.{{name}} = config.{{name}};", new Object[0]);
        }
        segment.write("return local;", new Object[0]).write_l("}", new Object[0]);
    }

    private void finishBuilderClass(Segment segment) {
        segment.write_r("public {{klass}} {{build}}() {", new Object[0]).write("return {{klass}}.this;", new Object[0]).write_l("}", new Object[0]);
        segment.write_l("}", new Object[0]);
    }

    private void generateBuilderMethod(Segment segment, Class<?> klass, Class<?> configClass, Field field) {
        String name = field.getName();
        String type = GeciReflectionTools.getGenericTypeName((Type)field.getGenericType());
        String setterName = "set" + CaseTools.ucase((String)name);
        segment.param(new String[]{"name", name, "setter", setterName, "type", type});
        boolean hasSetter = ConfigBuilder.doesTheFieldHaveSetter(configClass, field, setterName);
        if (!Modifier.isFinal(field.getModifiers()) || hasSetter) {
            segment.write_r("public {{Builder}} {{name}}({{type}} {{name}}) {", new Object[0]);
            if (hasSetter) {
                segment.write("config.{{setter}}({{name}});", new Object[0]);
            } else {
                segment.write("config.{{name}} = {{name}};", new Object[0]);
            }
            segment.write("return this;", new Object[0]).write_l("}", new Object[0]).newline();
        }
    }

    private static boolean doesTheFieldHaveSetter(Class<?> configClass, Field field, String setterName) {
        try {
            GeciReflectionTools.getMethod(configClass, (String)setterName, (Class[])new Class[]{field.getType()});
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    private void startBuilderClass(Segment segment, Class klass) {
        try {
            Class<?> superBuilder = Class.forName(klass.getSuperclass().getName() + "$Builder");
            segment.write_r("public class {{Builder}} extends %s implements javax0.geci.api.GeneratorBuilder {", new Object[]{superBuilder.getCanonicalName()});
        }
        catch (ClassNotFoundException cnfe) {
            segment.write_r("public class {{Builder}} implements javax0.geci.api.GeneratorBuilder {", new Object[0]);
        }
    }

    private void generateBuilderFactoryMethod(Segment segment, Class klass) {
        if (!Modifier.isAbstract(klass.getModifiers())) {
            segment.write_r("public static {{klass}}.{{Builder}} {{builder}}() {", new Object[0]).write("return new {{klass}}().new {{Builder}}();", new Object[0]).write_l("}", new Object[0]).newline();
        }
    }

    private List<Field> configurableFields(CompoundParams params, List<Field> allDeclaredFields) {
        return allDeclaredFields.stream().filter(field -> {
            Config local = this.localConfig(new CompoundParams(new CompoundParams[]{GeciReflectionTools.getParameters((AnnotatedElement)field, (String)this.mnemonic()), params}));
            return Selector.compile((String)local.filter).match(field) && !Modifier.isFinal(field.getModifiers()) && field.getType().equals(String.class);
        }).collect(Collectors.toList());
    }

    public String mnemonic() {
        return "configBuilder";
    }

    public static Builder builder() {
        return new ConfigBuilder().new Builder();
    }

    public Set<String> implementedKeys() {
        return implementedKeys;
    }

    private Config localConfig(CompoundParams params) {
        Config local = new Config();
        local.buildMethod = params.get("buildMethod", this.config.buildMethod);
        local.builderFactoryMethod = params.get("builderFactoryMethod", this.config.builderFactoryMethod);
        local.builderName = params.get("builderName", this.config.builderName);
        local.configAccess = params.get("configAccess", this.config.configAccess);
        local.configurableMnemonic = params.get("configurableMnemonic", this.config.configurableMnemonic);
        local.filter = params.get("filter", this.config.filter);
        local.generateImplementedKeys = params.get("generateImplementedKeys", this.config.generateImplementedKeys);
        local.localConfigMethod = params.get("localConfigMethod", this.config.localConfigMethod);
        return local;
    }

    public class Builder
    implements GeneratorBuilder {
        public Builder buildMethod(String buildMethod) {
            ConfigBuilder.this.config.buildMethod = buildMethod;
            return this;
        }

        public Builder builderFactoryMethod(String builderFactoryMethod) {
            ConfigBuilder.this.config.builderFactoryMethod = builderFactoryMethod;
            return this;
        }

        public Builder builderName(String builderName) {
            ConfigBuilder.this.config.builderName = builderName;
            return this;
        }

        public Builder configAccess(String configAccess) {
            ConfigBuilder.this.config.configAccess = configAccess;
            return this;
        }

        public Builder configurableMnemonic(String configurableMnemonic) {
            ConfigBuilder.this.config.configurableMnemonic = configurableMnemonic;
            return this;
        }

        public Builder filter(String filter) {
            ConfigBuilder.this.config.filter = filter;
            return this;
        }

        public Builder generateImplementedKeys(String generateImplementedKeys) {
            ConfigBuilder.this.config.generateImplementedKeys = generateImplementedKeys;
            return this;
        }

        public Builder localConfigMethod(String localConfigMethod) {
            ConfigBuilder.this.config.localConfigMethod = localConfigMethod;
            return this;
        }

        public ConfigBuilder build() {
            return ConfigBuilder.this;
        }
    }

    private static class Config {
        private String filter = "private & !static";
        private String builderName = "Builder";
        private String builderFactoryMethod = "builder";
        private String buildMethod = "build";
        private String configAccess = "private";
        private String generateImplementedKeys = "true";
        private String localConfigMethod = "localConfig";
        private String configurableMnemonic = "";

        private Config() {
        }
    }
}

