/*
 * Decompiled with CFR 0.152.
 */
package javax0.geci.cloner;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax0.geci.annotations.Generated;
import javax0.geci.api.GeneratorBuilder;
import javax0.geci.api.Logger;
import javax0.geci.api.Segment;
import javax0.geci.api.Source;
import javax0.geci.core.annotations.AnnotationBuilder;
import javax0.geci.tools.AbstractFilteredFieldsGenerator;
import javax0.geci.tools.CaseTools;
import javax0.geci.tools.CompoundParams;
import javax0.geci.tools.GeciReflectionTools;

@AnnotationBuilder
public class Cloner
extends AbstractFilteredFieldsGenerator {
    private String configuredMnemonic = "cloner";
    private final Config config = new Config();
    private static final Set<String> implementedKeys = new HashSet<String>(Arrays.asList("cloneMethod", "cloneMethodProtection", "cloneWith", "copyCallsSuper", "copyMethod", "copyMethodProtection", "filter", "superCopyMethod", "id"));

    public Cloner() {
        this.declaredOnly = false;
    }

    protected String defaultFilterExpression() {
        return this.config.filter;
    }

    public void preprocess(Source source, Class<?> klass, CompoundParams global, Segment segment) {
        Logger log = source.getLogger();
        Config local = this.localConfig(global);
        Field[] fields = (Field[])Arrays.stream(GeciReflectionTools.getAllFieldsSorted(klass)).filter(field -> !Modifier.isFinal(field.getModifiers())).filter(field -> !Modifier.isStatic(field.getModifiers())).toArray(Field[]::new);
        this.writeGenerated(segment, this.config.generatedAnnotation);
        String fullyQualified = GeciReflectionTools.getSimpleGenericClassName(klass);
        log.info("Creating %s %s %s()", new Object[]{local.cloneMethodProtection, fullyQualified, local.cloneMethod});
        segment.write_r("%s %s %s() {", new Object[]{local.cloneMethodProtection, fullyQualified, local.cloneMethod});
        segment.write("final var it = new %s();", new Object[]{klass.getSimpleName()}).write("%s(it);", new Object[]{local.copyMethod}).write("return it;", new Object[0]).write_l("}", new Object[0]);
        log.info("Creating %s void %s(%s it)", new Object[]{local.copyMethodProtection, local.copyMethod, fullyQualified});
        segment.write_r("%s void %s(%s it) {", new Object[]{local.copyMethodProtection, local.copyMethod, fullyQualified});
        if (javax0.geci.api.CompoundParams.toBoolean((String)local.copyCallsSuper)) {
            segment.write("super.%s(it);", new Object[]{local.getSuperCopyMethod()});
        }
        segment.newline();
        for (Field field2 : fields) {
            segment.write("it.%s = %s;", new Object[]{field2.getName(), field2.getName()});
        }
        segment.write_l("}", new Object[0]).newline();
    }

    public void process(Source source, Class<?> klass, CompoundParams params, Field field, Segment segment) {
        Config local = this.localConfig(params);
        String name = field.getName();
        String type = GeciReflectionTools.normalizeTypeName((String)field.getType().getName(), klass);
        String fullyQualified = GeciReflectionTools.getSimpleGenericClassName(klass);
        segment.write_r("%s with%s(%s %s) {", new Object[]{fullyQualified, CaseTools.ucase((String)name), type, name});
        if (javax0.geci.api.CompoundParams.toBoolean((String)local.cloneWith)) {
            segment.write("final var it = %s();", new Object[]{local.cloneMethod}).write("it.%s = %s;", new Object[]{name, name}).write("return it;", new Object[0]);
        } else {
            segment.write("this.%s = %s;", new Object[]{name, name}).write("return this;", new Object[0]);
        }
        segment.write_l("}", new Object[0]).newline();
    }

    public String mnemonic() {
        return this.configuredMnemonic;
    }

    public static Builder builder() {
        return new Cloner().new Builder();
    }

    public Set<String> implementedKeys() {
        return implementedKeys;
    }

    private Config localConfig(CompoundParams params) {
        Config local = new Config();
        local.cloneMethod = params.get("cloneMethod", this.config.cloneMethod);
        local.cloneMethodProtection = params.get("cloneMethodProtection", this.config.cloneMethodProtection);
        local.cloneWith = params.get("cloneWith", this.config.cloneWith);
        local.copyCallsSuper = params.get("copyCallsSuper", this.config.copyCallsSuper);
        local.copyMethod = params.get("copyMethod", this.config.copyMethod);
        local.copyMethodProtection = params.get("copyMethodProtection", this.config.copyMethodProtection);
        local.setDeclaredOnly(this.config.declaredOnly);
        local.filter = params.get("filter", this.config.filter);
        local.generatedAnnotation = this.config.generatedAnnotation;
        local.superCopyMethod = params.get("superCopyMethod", this.config.superCopyMethod);
        return local;
    }

    public class Builder
    implements GeneratorBuilder {
        public Builder cloneMethod(String cloneMethod) {
            Cloner.this.config.cloneMethod = cloneMethod;
            return this;
        }

        public Builder cloneMethodProtection(String cloneMethodProtection) {
            Cloner.this.config.cloneMethodProtection = cloneMethodProtection;
            return this;
        }

        public Builder cloneWith(String cloneWith) {
            Cloner.this.config.cloneWith = cloneWith;
            return this;
        }

        public Builder copyCallsSuper(String copyCallsSuper) {
            Cloner.this.config.copyCallsSuper = copyCallsSuper;
            return this;
        }

        public Builder copyMethod(String copyMethod) {
            Cloner.this.config.copyMethod = copyMethod;
            return this;
        }

        public Builder copyMethodProtection(String copyMethodProtection) {
            Cloner.this.config.copyMethodProtection = copyMethodProtection;
            return this;
        }

        public Builder declaredOnly(boolean declaredOnly) {
            Cloner.this.config.setDeclaredOnly(declaredOnly);
            return this;
        }

        public Builder filter(String filter) {
            Cloner.this.config.filter = filter;
            return this;
        }

        public Builder generatedAnnotation(Class<? extends Annotation> generatedAnnotation) {
            Cloner.this.config.generatedAnnotation = generatedAnnotation;
            return this;
        }

        public Builder superCopyMethod(String superCopyMethod) {
            Cloner.this.config.superCopyMethod = superCopyMethod;
            return this;
        }

        public Builder mnemonic(String mnemonic) {
            Cloner.this.configuredMnemonic = mnemonic;
            return this;
        }

        public Cloner build() {
            return Cloner.this;
        }
    }

    private class Config {
        private Class<? extends Annotation> generatedAnnotation = Generated.class;
        private String filter = "!static & !final";
        private String cloneMethod = "copy";
        private String cloneMethodProtection = "public";
        private String copyMethod = "copy";
        private String superCopyMethod = null;
        private String copyMethodProtection = "protected";
        private String cloneWith = "true";
        private String copyCallsSuper = "false";
        private final boolean declaredOnly = false;

        private Config() {
        }

        private void setDeclaredOnly(boolean b) {
            Cloner.this.declaredOnly = b;
        }

        private String getSuperCopyMethod() {
            return this.superCopyMethod != null && this.superCopyMethod.length() != 0 ? this.superCopyMethod : this.copyMethod;
        }
    }
}

