/*
 * Decompiled with CFR 0.152.
 */
package javax0.geci.builder;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax0.geci.annotations.Generated;
import javax0.geci.api.GeneratorBuilder;
import javax0.geci.api.Segment;
import javax0.geci.api.Source;
import javax0.geci.core.annotations.AnnotationBuilder;
import javax0.geci.tools.AbstractFilteredFieldsGenerator;
import javax0.geci.tools.CaseTools;
import javax0.geci.tools.CompoundParams;
import javax0.geci.tools.GeciReflectionTools;

@AnnotationBuilder
public class Builder
extends AbstractFilteredFieldsGenerator {
    private final Config config = new Config();
    private static final Set<String> implementedKeys = new HashSet<String>(Arrays.asList("aggregatorMethod", "argumentVariable", "buildMethod", "builderFactoryMethod", "builderName", "checkNullInAggregator", "factory", "filter", "setterPrefix", "id"));

    public String mnemonic() {
        return "builder";
    }

    public void preprocess(Source source, Class<?> klass, CompoundParams global, Segment segment) {
        Config local = this.localConfig(global);
        segment.param(new String[]{"class", klass.getSimpleName()});
        Object factory = local.factory != null && !local.factory.isEmpty() ? local.factory : "new " + klass.getSimpleName() + "()";
        this.writeGenerated(segment, this.config.generatedAnnotation);
        segment.write_r("public static %s.%s %s() {", new Object[]{klass.getSimpleName(), local.builderName, local.builderFactoryMethod}).write("return %s.new %s();", new Object[]{factory, local.builderName}).write_l("}", new Object[0]).newline();
        this.writeGenerated(segment, this.config.generatedAnnotation);
        segment.write_r("public class %s {", new Object[]{local.builderName});
    }

    public void process(Source source, Class<?> klass, CompoundParams params, Field field, Segment segment) {
        Config local = this.localConfig(params);
        String name = field.getName();
        String type = GeciReflectionTools.normalizeTypeName((String)field.getType().getName(), klass);
        segment.param(new String[]{"field", name, "type", type, "Builder", local.builderName, "x", local.argumentVariable});
        if (!Modifier.isFinal(field.getModifiers())) {
            this.generateSetter(klass, segment, name, local.setterPrefix);
        }
        if (local.aggregatorMethod != null && local.aggregatorMethod.length() > 0) {
            this.generateAggregators(klass, segment, field, local);
        }
    }

    private void generateAggregators(Class<?> klass, Segment segment, Field field, Config local) {
        HashSet<String> argumentTypesDone = new HashSet<String>();
        String name = field.getName();
        segment.param(new String[]{"aggregatorMethod", local.aggregatorMethod + CaseTools.ucase((String)name), "remoteAggregatorMethod", local.aggregatorMethod});
        for (Method method : GeciReflectionTools.getDeclaredMethodsSorted(field.getType())) {
            String argumentTypeName;
            if (!method.getName().equals(local.aggregatorMethod) || method.getParameterTypes().length != 1 || (argumentTypeName = this.calculateTypeName(klass, field, method.getParameterTypes()[0])) == null || argumentTypesDone.contains(argumentTypeName)) continue;
            argumentTypesDone.add(argumentTypeName);
            segment.param(new String[]{"argumentType", argumentTypeName});
            this.writeGenerated(segment, local.generatedAnnotation);
            segment.write_r("public {{Builder}} {{aggregatorMethod}}(final {{argumentType}} {{x}}) {", new Object[0]);
            if (javax0.geci.api.CompoundParams.toBoolean((String)local.checkNullInAggregator)) {
                segment.write_r("if( {{class}}.this.{{field}} == null ) {", new Object[0]).write("throw new IllegalArgumentException(\"Collection field {{field}} is null\");", new Object[0]).write_l("}", new Object[0]);
            }
            segment.write("{{class}}.this.{{field}}.{{remoteAggregatorMethod}}({{x}});", new Object[0]).write("return this;", new Object[0]).write_l("}", new Object[0]).newline();
        }
    }

    private String calculateTypeName(Class<?> klass, Field field, Class<?> type) {
        Class parType;
        Type[] parTypes;
        Type genType = field.getGenericType();
        if (genType instanceof ParameterizedType && (parTypes = ((ParameterizedType)genType).getActualTypeArguments()).length == 1 && parTypes[0] instanceof Class && type.isAssignableFrom(parType = (Class)parTypes[0])) {
            return GeciReflectionTools.normalizeTypeName((String)parType.getTypeName(), klass);
        }
        return GeciReflectionTools.normalizeTypeName((String)type.getName(), klass);
    }

    private void generateSetter(Class<?> klass, Segment segment, String name, String prefix) {
        this.writeGenerated(segment, this.config.generatedAnnotation);
        Object setterName = prefix != null && prefix.length() > 0 ? prefix + CaseTools.ucase((String)name) : name;
        segment.param(new String[]{"setter", setterName, "field", name});
        segment.write_r("public {{Builder}} {{setter}}(final {{type}} {{x}}) {", new Object[0]).write("{{class}}.this.{{field}} = {{x}};", new Object[0]).write("return this;", new Object[0]).write_l("}", new Object[0]).newline();
    }

    public void postprocess(Source source, Class<?> klass, CompoundParams global, Segment segment) {
        Config local = this.localConfig(global);
        this.writeGenerated(segment, this.config.generatedAnnotation);
        segment.write_r("public %s %s() {", new Object[]{klass.getSimpleName(), local.buildMethod}).write("return %s.this;", new Object[]{klass.getSimpleName()}).write_l("}", new Object[0]);
        segment.write_l("}", new Object[0]);
    }

    protected String defaultFilterExpression() {
        return this.config.filter;
    }

    public static ConfBuilder builder() {
        return new Builder().new ConfBuilder();
    }

    public Set<String> implementedKeys() {
        return implementedKeys;
    }

    private Config localConfig(CompoundParams params) {
        Config local = new Config();
        local.aggregatorMethod = params.get("aggregatorMethod", this.config.aggregatorMethod);
        local.argumentVariable = params.get("argumentVariable", this.config.argumentVariable);
        local.buildMethod = params.get("buildMethod", this.config.buildMethod);
        local.builderFactoryMethod = params.get("builderFactoryMethod", this.config.builderFactoryMethod);
        local.builderName = params.get("builderName", this.config.builderName);
        local.checkNullInAggregator = params.get("checkNullInAggregator", this.config.checkNullInAggregator);
        local.factory = params.get("factory", this.config.factory);
        local.filter = params.get("filter", this.config.filter);
        local.generatedAnnotation = this.config.generatedAnnotation;
        local.setterPrefix = params.get("setterPrefix", this.config.setterPrefix);
        return local;
    }

    public class ConfBuilder
    implements GeneratorBuilder {
        public ConfBuilder aggregatorMethod(String aggregatorMethod) {
            Builder.this.config.aggregatorMethod = aggregatorMethod;
            return this;
        }

        public ConfBuilder argumentVariable(String argumentVariable) {
            Builder.this.config.argumentVariable = argumentVariable;
            return this;
        }

        public ConfBuilder buildMethod(String buildMethod) {
            Builder.this.config.buildMethod = buildMethod;
            return this;
        }

        public ConfBuilder builderFactoryMethod(String builderFactoryMethod) {
            Builder.this.config.builderFactoryMethod = builderFactoryMethod;
            return this;
        }

        public ConfBuilder builderName(String builderName) {
            Builder.this.config.builderName = builderName;
            return this;
        }

        public ConfBuilder checkNullInAggregator(String checkNullInAggregator) {
            Builder.this.config.checkNullInAggregator = checkNullInAggregator;
            return this;
        }

        public ConfBuilder factory(String factory) {
            Builder.this.config.factory = factory;
            return this;
        }

        public ConfBuilder filter(String filter) {
            Builder.this.config.filter = filter;
            return this;
        }

        public ConfBuilder generatedAnnotation(Class<? extends Annotation> generatedAnnotation) {
            Builder.this.config.generatedAnnotation = generatedAnnotation;
            return this;
        }

        public ConfBuilder setterPrefix(String setterPrefix) {
            Builder.this.config.setterPrefix = setterPrefix;
            return this;
        }

        public Builder build() {
            return Builder.this;
        }
    }

    private static class Config {
        private Class<? extends Annotation> generatedAnnotation = Generated.class;
        private String filter = "private & !static & !final";
        private String builderName = "Builder";
        private String builderFactoryMethod = "builder";
        private String buildMethod = "build";
        private String aggregatorMethod = "add";
        private String checkNullInAggregator = "true";
        private String setterPrefix = "";
        private String factory = "";
        private String argumentVariable = "x";

        private Config() {
        }
    }
}

