/*
 * Decompiled with CFR 0.152.
 */
package javax0.geci.annotationbuilder;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax0.geci.api.GeciException;
import javax0.geci.api.Generator;
import javax0.geci.api.GeneratorBuilder;
import javax0.geci.api.Segment;
import javax0.geci.api.Source;
import javax0.geci.tools.AbstractJavaGenerator;
import javax0.geci.tools.CaseTools;
import javax0.geci.tools.CompoundParams;

@javax0.geci.core.annotations.AnnotationBuilder
public class AnnotationBuilder
extends AbstractJavaGenerator {
    private final Config config = new Config();
    private static final Set<String> implementedKeys = new HashSet<String>(Arrays.asList("in", "set", "id"));

    public void process(Source source, Class<?> klass, CompoundParams global) {
        if (Generator.class.isAssignableFrom(klass)) {
            Config local = this.localConfig(global);
            String mnemonic = this.getMnemonic(klass);
            String annotation = CaseTools.ucase((String)mnemonic);
            String directory = this.getPackageDirectory(local);
            Source newSource = source.newSource(Source.Set.set((String)local.set), directory + "/" + annotation + ".java");
            this.writeContent(newSource, mnemonic, annotation, this.getImplementedKeysSorted(klass));
        }
    }

    private String getPackageDirectory(Config local) {
        if (local.in.isEmpty()) {
            return "";
        }
        boolean packageIsAbsolute = !local.in.startsWith(".");
        return (packageIsAbsolute ? "/" : "") + local.in.substring(packageIsAbsolute ? 0 : 1).replaceAll("\\.", "/");
    }

    private List<String> getImplementedKeysSorted(Class<?> klass) {
        try {
            Set implementedKeys = ((AbstractJavaGenerator)klass.getConstructor(new Class[0]).newInstance(new Object[0])).implementedKeys();
            if (implementedKeys == null) {
                return Collections.emptyList();
            }
            return implementedKeys.stream().sorted().collect(Collectors.toList());
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            throw new GeciException("Cannot generate annotation for " + klass.getName() + " because it does not have an implementedKeys() method.", (Throwable)ex);
        }
    }

    private String getMnemonic(Class<?> klass) {
        try {
            return ((AbstractJavaGenerator)klass.getConstructor(new Class[0]).newInstance(new Object[0])).mnemonic();
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            throw new GeciException("Cannot generate annotation for " + klass.getName() + " because it does not have a mnemonic() method.", (Throwable)ex);
        }
    }

    private void writeContent(Source source, String mnemonic, String annotation, List<String> keys) {
        try (Segment segment = source.open();){
            segment.write("package %s;", new Object[]{source.getPackageName()}).newline().write("import java.lang.annotation.Retention;", new Object[0]).write("import java.lang.annotation.RetentionPolicy;", new Object[0]).write("import javax0.geci.annotations.Geci;", new Object[0]).newline().write("@Geci(\"%s\")", new Object[]{mnemonic}).write("@Retention(RetentionPolicy.RUNTIME)", new Object[0]).write_r("public @interface %s {", new Object[]{annotation}).newline().write(this.parameterMethod("value"), new Object[0]);
            keys.stream().filter(key -> !key.equals("id")).map(this::parameterMethod).forEach(x$0 -> segment.write(x$0, new Object[0]));
            segment.write_l("}", new Object[0]);
        }
    }

    private String parameterMethod(String param) {
        return "String " + param + "() default \"\";";
    }

    public static Builder builder() {
        return new AnnotationBuilder().new Builder();
    }

    public Set<String> implementedKeys() {
        return implementedKeys;
    }

    private Config localConfig(CompoundParams params) {
        Config local = new Config();
        local.in = params.get("in", this.config.in);
        local.set = params.get("set", this.config.set);
        return local;
    }

    public class Builder
    implements GeneratorBuilder {
        public Builder in(String in) {
            AnnotationBuilder.this.config.in = in;
            return this;
        }

        public Builder set(String set) {
            AnnotationBuilder.this.config.set = set;
            return this;
        }

        public AnnotationBuilder build() {
            return AnnotationBuilder.this;
        }
    }

    private static class Config {
        private String set = "";
        private String in = ".annotation";

        private Config() {
        }
    }
}

