/*
 * Decompiled with CFR 0.152.
 */
package javax0.geci.accessor;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import javax0.geci.api.GeciException;
import javax0.geci.api.GeneratorBuilder;
import javax0.geci.api.Segment;
import javax0.geci.api.Source;
import javax0.geci.tools.AbstractFilteredFieldsGenerator;
import javax0.geci.tools.CaseTools;
import javax0.geci.tools.CompoundParams;
import javax0.geci.tools.GeciReflectionTools;

public class AbstractAccessor
extends AbstractFilteredFieldsGenerator {
    private static final Set<String> accessModifiers = new HashSet<String>(Arrays.asList("public", "private", "protected", "package"));
    protected final Config config = new Config();
    private static final Set<String> implementedKeys = new HashSet<String>(Arrays.asList("access", "filter", "getter", "mnemonic", "only", "setter", "id"));

    protected boolean processAllClasses() {
        return this.config.processAllClasses;
    }

    protected String defaultFilterExpression() {
        return this.config.filter;
    }

    protected void writeGetter(Field field, String name, String getterName, String type, String access, Segment segment) {
        segment._r("%s%s%s %s() {", new Object[]{access, this.conditionalSpace(access), type, getterName}).write("return %s;", new Object[]{this.config.getterReturnValueDecorator.apply(name)})._l("}", new Object[0]).newline();
    }

    protected void writeSetter(Field field, String name, String setterName, String type, String access, Segment segment) {
    }

    protected static String getterName(String name) {
        return "get" + CaseTools.ucase((String)name);
    }

    protected static String setterName(String name) {
        return "set" + CaseTools.ucase((String)name);
    }

    private String check(String access) {
        if (!access.endsWith("!") && !accessModifiers.contains(access)) {
            throw new GeciException("'" + access + "' is not a valid access modifier", new Object[0]);
        }
        String modifiedAccess = access.endsWith("!") ? access.substring(0, access.length() - 1) : access;
        if (modifiedAccess.equals("package")) {
            return "";
        }
        return modifiedAccess;
    }

    protected String conditionalSpace(String access) {
        return access.equals("") ? "" : " ";
    }

    public void process(Source source, Class<?> klass, CompoundParams params, Field field, Segment segment) {
        boolean isFinal = Modifier.isFinal(field.getModifiers());
        String name = field.getName();
        String fieldType = GeciReflectionTools.typeAsString((Member)field);
        String access = this.check(params.get("access", "public"));
        String setter = params.get("setter", () -> this.config.setterNameGenerator.apply(name));
        String getter = params.get("getter", () -> this.config.getterNameGenerator.apply(name));
        String only = params.get("only");
        if (!isFinal && !"getter".equals(only)) {
            this.writeSetter(field, name, setter, fieldType, access, segment);
        }
        if (!"setter".equals(only)) {
            this.writeGetter(field, name, getter, fieldType, access, segment);
        }
    }

    public static Builder builder() {
        return new AbstractAccessor().new Builder();
    }

    public Set<String> implementedKeys() {
        return implementedKeys;
    }

    private Config localConfig(CompoundParams params) {
        Config local = new Config();
        local.access = params.get("access", this.config.access);
        local.filter = params.get("filter", this.config.filter);
        local.getter = params.get("getter", this.config.getter);
        local.getterNameGenerator = this.config.getterNameGenerator;
        local.getterReturnValueDecorator = this.config.getterReturnValueDecorator;
        local.mnemonic = params.get("mnemonic", this.config.mnemonic);
        local.only = params.get("only", this.config.only);
        local.processAllClasses = this.config.processAllClasses;
        local.setter = params.get("setter", this.config.setter);
        local.setterNameGenerator = this.config.setterNameGenerator;
        return local;
    }

    public class Builder
    implements GeneratorBuilder {
        public Builder access(String access) {
            AbstractAccessor.this.config.access = access;
            return this;
        }

        public Builder filter(String filter) {
            AbstractAccessor.this.config.filter = filter;
            return this;
        }

        public Builder getter(String getter) {
            AbstractAccessor.this.config.getter = getter;
            return this;
        }

        public Builder getterNameGenerator(Function<String, String> getterNameGenerator) {
            AbstractAccessor.this.config.getterNameGenerator = getterNameGenerator;
            return this;
        }

        public Builder getterReturnValueDecorator(Function<String, String> getterReturnValueDecorator) {
            AbstractAccessor.this.config.getterReturnValueDecorator = getterReturnValueDecorator;
            return this;
        }

        public Builder mnemonic(String mnemonic) {
            AbstractAccessor.this.config.mnemonic = mnemonic;
            return this;
        }

        public Builder only(String only) {
            AbstractAccessor.this.config.only = only;
            return this;
        }

        public Builder processAllClasses(boolean processAllClasses) {
            AbstractAccessor.this.config.processAllClasses = processAllClasses;
            return this;
        }

        public Builder setter(String setter) {
            AbstractAccessor.this.config.setter = setter;
            return this;
        }

        public Builder setterNameGenerator(Function<String, String> setterNameGenerator) {
            AbstractAccessor.this.config.setterNameGenerator = setterNameGenerator;
            return this;
        }

        public AbstractAccessor build() {
            return AbstractAccessor.this;
        }
    }

    protected static class Config {
        protected String mnemonic = "";
        protected String access = "public";
        protected String filter = "true";
        protected String getter = null;
        protected String setter = null;
        protected String only = "";
        protected boolean processAllClasses = false;
        protected Function<String, String> getterNameGenerator = AbstractAccessor::getterName;
        protected Function<String, String> setterNameGenerator = AbstractAccessor::setterName;
        protected Function<String, String> getterReturnValueDecorator = name -> name;

        protected Config() {
        }
    }
}

