/*
 * Decompiled with CFR 0.152.
 */
package javax0.geci.api;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import javax0.geci.api.GeciException;
import javax0.geci.api.Logger;
import javax0.geci.api.Segment;

public interface Source {
    public static Maven maven(String root) {
        return new Maven(root);
    }

    public static Maven maven() {
        return new Maven();
    }

    public Segment open(String var1) throws IOException;

    public void allowDefaultSegment();

    public Segment safeOpen(String var1) throws IOException;

    public Segment temporary();

    public Segment open();

    public java.util.Set<String> segmentNames();

    public List<String> getLines();

    default public List<String> borrows() {
        return this.getLines();
    }

    public void returns(List<String> var1);

    public String getAbsoluteFile();

    public Source newSource(String var1);

    public Source newSource(Set var1, String var2);

    public void init(String var1) throws IOException;

    public String getKlassName();

    public String getKlassSimpleName();

    public String getPackageName();

    public Class<?> getKlass();

    public Logger getLogger();

    public static class Maven {
        private final String rootModuleDir;
        private String module = null;

        private Maven() {
            this.rootModuleDir = null;
        }

        private Maven(String root) {
            this.rootModuleDir = root;
        }

        private NamedSourceSet source(String name, String mainOrTest, String javaOrResources) {
            if (this.module == null) {
                return new NamedSourceSet(Set.set(name, true), new String[]{"./src/" + mainOrTest + "/" + javaOrResources});
            }
            if (this.rootModuleDir == null) {
                return new NamedSourceSet(Set.set(name, true), new String[]{"./" + this.module + "/src/" + mainOrTest + "/" + javaOrResources, "../" + this.module + "/src/" + mainOrTest + "/" + javaOrResources, "./src/" + mainOrTest + "/" + javaOrResources});
            }
            return new NamedSourceSet(Set.set(name, true), new String[]{this.rootModuleDir + "/" + this.module + "/src/" + mainOrTest + "/" + javaOrResources, "./" + this.module + "/src/" + mainOrTest + "/" + javaOrResources});
        }

        public NamedSourceSet mainSource() {
            return this.source("mainSource", "main", "java");
        }

        public NamedSourceSet testSource() {
            return this.source("testSource", "test", "java");
        }

        public NamedSourceSet testResources() {
            return this.source("testResources", "test", "resources");
        }

        public NamedSourceSet mainResources() {
            return this.source("mainResources", "main", "resources");
        }

        public Maven module(String module) {
            this.module = module;
            return this;
        }
    }

    public static class Predicates {
        public static Predicate<String> exists() {
            return file -> new File((String)file).isDirectory();
        }

        public static Predicate<String> hasTheFile(String anchor) {
            return Predicates.exists().and(file -> new File(file + anchor).exists());
        }

        public static Predicate<String> hasOneOfTheFiles(String ... anchors) {
            return Predicates.exists().and(file -> Arrays.stream(anchors).anyMatch(anchor -> new File(file + anchor).exists()));
        }

        public static Predicate<String> hasAllTheFiles(String ... anchors) {
            return Predicates.exists().and(file -> Arrays.stream(anchors).allMatch(anchor -> new File(file + anchor).exists()));
        }
    }

    public static class NamedSourceSet {
        public final Set set;
        public final String[] directories;

        public NamedSourceSet(Set set, String[] directories) {
            this.set = set;
            this.directories = directories;
        }
    }

    public static class Set {
        private String name;
        private final boolean autoName;

        private Set(String name, boolean autoName) {
            if (name == null && autoName) {
                throw new GeciException("When the name for a set is not specified it cannot be 'autoName'", new Object[0]);
            }
            if (name == null) {
                name = this.randomUniqueName();
            }
            this.name = name;
            this.autoName = autoName;
        }

        private String randomUniqueName() {
            return "" + super.hashCode();
        }

        public void tryRename() {
            if (this.autoName) {
                this.name = this.randomUniqueName();
            }
        }

        public static Set set(String name) {
            return new Set(name, false);
        }

        public static Set set(String name, boolean autoName) {
            return new Set(name, autoName);
        }

        public static Set set() {
            return Set.set(null);
        }

        public String toString() {
            return this.name;
        }

        public boolean equals(Object that) {
            if (this == that) {
                return true;
            }
            if (!(that instanceof Set)) {
                return false;
            }
            Set set = (Set)that;
            return Objects.equals(this.name, set.name);
        }

        public int hashCode() {
            return Objects.hash(this.name);
        }
    }
}

