/*
 * Decompiled with CFR 0.152.
 */
package javax0.geci.api;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax0.geci.api.Context;
import javax0.geci.api.DirectoryLocator;
import javax0.geci.api.Generator;
import javax0.geci.api.GeneratorBuilder;
import javax0.geci.api.SegmentSplitHelper;
import javax0.geci.api.Source;

public interface Geci {
    public static final String MAIN_SOURCE = "mainSource";
    public static final String MAIN_RESOURCES = "mainResources";
    public static final String TEST_SOURCE = "testSource";
    public static final String TEST_RESOURCES = "testResources";

    public Geci source(String ... var1);

    public Geci trace(String var1);

    public Geci diffOutput(String var1);

    public Geci source(Predicate<String> var1, String ... var2);

    public Geci source(Source.Set var1, DirectoryLocator var2);

    public Geci source(DirectoryLocator var1);

    public Geci source(Source.Set var1, String ... var2);

    public Geci source(Source.Set var1, Predicate<String> var2, String ... var3);

    public Geci splitHelper(String var1, SegmentSplitHelper var2);

    default public Geci source(Source.NamedSourceSet nameAndSet) {
        return this.source(nameAndSet.set, nameAndSet.directories);
    }

    default public Geci source(Source.Set set, Source.NamedSourceSet nameAndSet) {
        return this.source(set, nameAndSet.directories);
    }

    default public Geci source(String set, Source.NamedSourceSet nameAndSet) {
        return this.source(Source.Set.set(set), nameAndSet.directories);
    }

    public Geci source(Source.Maven var1);

    public Geci register(Generator ... var1);

    default public Geci register(GeneratorBuilder ... generatorBuilders) {
        Generator[] generators = (Generator[])Arrays.stream(generatorBuilders).map(GeneratorBuilder::build).toArray(Generator[]::new);
        return this.register(generators);
    }

    public Geci only(String ... var1);

    public Geci ignore(String ... var1);

    public Geci ignoreBinary();

    public Geci output(Source.Set ... var1);

    public Geci output();

    public Geci only(Predicate<Path> ... var1);

    public Geci ignore(Predicate<Path> ... var1);

    public Geci comparator(BiPredicate<List<String>, List<String>> var1);

    public Context context();

    public Geci context(Context var1);

    public boolean generate() throws Exception;
}

