/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.jwt.internal.org.bouncycastle.pqc.crypto.mceliece;

import com.auth0.jwt.internal.org.bouncycastle.crypto.CipherParameters;
import com.auth0.jwt.internal.org.bouncycastle.crypto.Digest;
import com.auth0.jwt.internal.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.auth0.jwt.internal.org.bouncycastle.crypto.params.ParametersWithRandom;
import com.auth0.jwt.internal.org.bouncycastle.pqc.crypto.MessageEncryptor;

public class McEliecePointchevalDigestCipher {
    private final Digest messDigest;
    private final MessageEncryptor mcElieceCCA2Cipher;
    private boolean forEncrypting;

    public McEliecePointchevalDigestCipher(MessageEncryptor messageEncryptor, Digest digest) {
        this.mcElieceCCA2Cipher = messageEncryptor;
        this.messDigest = digest;
    }

    public void init(boolean bl, CipherParameters cipherParameters) {
        this.forEncrypting = bl;
        AsymmetricKeyParameter asymmetricKeyParameter = cipherParameters instanceof ParametersWithRandom ? (AsymmetricKeyParameter)((ParametersWithRandom)cipherParameters).getParameters() : (AsymmetricKeyParameter)cipherParameters;
        if (bl && asymmetricKeyParameter.isPrivate()) {
            throw new IllegalArgumentException("Encrypting Requires Public Key.");
        }
        if (!bl && !asymmetricKeyParameter.isPrivate()) {
            throw new IllegalArgumentException("Decrypting Requires Private Key.");
        }
        this.reset();
        this.mcElieceCCA2Cipher.init(bl, cipherParameters);
    }

    public byte[] messageEncrypt() {
        if (!this.forEncrypting) {
            throw new IllegalStateException("McEliecePointchevalDigestCipher not initialised for encrypting.");
        }
        byte[] byArray = new byte[this.messDigest.getDigestSize()];
        this.messDigest.doFinal(byArray, 0);
        byte[] byArray2 = null;
        try {
            byArray2 = this.mcElieceCCA2Cipher.messageEncrypt(byArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return byArray2;
    }

    public byte[] messageDecrypt(byte[] byArray) {
        byte[] byArray2 = null;
        if (this.forEncrypting) {
            throw new IllegalStateException("McEliecePointchevalDigestCipher not initialised for decrypting.");
        }
        try {
            byArray2 = this.mcElieceCCA2Cipher.messageDecrypt(byArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return byArray2;
    }

    public void update(byte by) {
        this.messDigest.update(by);
    }

    public void update(byte[] byArray, int n, int n2) {
        this.messDigest.update(byArray, n, n2);
    }

    public void reset() {
        this.messDigest.reset();
    }
}

